/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.io.IOException;
import java.util.Arrays;
import javax.xml.datatype.XMLGregorianCalendar;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wcs11.DomainSubsetType;
import net.opengis.wcs11.OutputType;
import net.opengis.wcs11.TimeSequenceType;
import net.opengis.wcs11.Wcs11Factory;
import net.opengis.wcs20.DimensionSliceType;
import net.opengis.wcs20.DimensionTrimType;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.Wcs20Factory;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.geotools.wcs.v2_0.WCS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class WCS2GetCoverageRequestBuilder {
    private GetCoverageType getCoverageType = Wcs20Factory.eINSTANCE.createGetCoverageType();
    private net.opengis.wcs11.GetCoverageType wcs111GetCoverage = Wcs11Factory.eINSTANCE.createGetCoverageType();

    private WCS2GetCoverageRequestBuilder() {
        this.wcs111GetCoverage.setVersion("1.1.1");
        OutputType outputType = Wcs11Factory.eINSTANCE.createOutputType();
        outputType.setFormat("image/tiff");
        this.wcs111GetCoverage.setOutput(outputType);
        this.getCoverageType.setVersion("2.0.0");
        this.getCoverageType.setFormat("image/tiff");
    }

    public WCS2GetCoverageRequestBuilder coverageId(String coverageId) {
        this.getCoverageType.setCoverageId(coverageId);
        CodeType codeType = Ows11Factory.eINSTANCE.createCodeType();
        codeType.setValue(coverageId);
        this.wcs111GetCoverage.setIdentifier(codeType);
        return this;
    }

    public WCS2GetCoverageRequestBuilder date(XMLGregorianCalendar date) {
        DimensionSliceType dimensionTrim = Wcs20Factory.eINSTANCE.createDimensionSliceType();
        dimensionTrim.setSlicePoint(date.toXMLFormat());
        dimensionTrim.setDimension("time");
        dimensionTrim.setCRS("http://www.opengis.net/def/trs/ISO-8601/0/Gregorian UTC");
        this.getCoverageType.getDimensionSubset().add((Object)dimensionTrim);
        TimeSequenceType timeSequenceType = Wcs11Factory.eINSTANCE.createTimeSequenceType();
        timeSequenceType.getTimePosition().add((Object)date);
        return this;
    }

    public WCS2GetCoverageRequestBuilder bbox(double minLon, double maxLon, double minLat, double maxLat) {
        DimensionTrimType latTrim = Wcs20Factory.eINSTANCE.createDimensionTrimType();
        latTrim.setCRS("http://www.opengis.net/def/crs/EPSG/0/4326");
        latTrim.setTrimLow(minLat + "");
        latTrim.setTrimHigh(maxLat + "");
        latTrim.setDimension("Lat");
        this.getCoverageType.getDimensionSubset().add((Object)latTrim);
        DimensionTrimType lonTrim = Wcs20Factory.eINSTANCE.createDimensionTrimType();
        lonTrim.setCRS("http://www.opengis.net/def/crs/EPSG/0/4326");
        lonTrim.setTrimLow(minLon + "");
        lonTrim.setTrimHigh(maxLon + "");
        lonTrim.setDimension("Long");
        this.getCoverageType.getDimensionSubset().add((Object)lonTrim);
        DomainSubsetType domainSubset = this.getWCS11DomainSubset();
        BoundingBoxType boundingbox = Ows11Factory.eINSTANCE.createBoundingBoxType();
        boundingbox.setCrs("http://www.opengis.net/def/crs/EPSG/0/4326");
        boundingbox.setLowerCorner(Arrays.asList(minLat, minLon));
        boundingbox.setUpperCorner(Arrays.asList(maxLat, maxLon));
        domainSubset.setBoundingBox(boundingbox);
        return this;
    }

    private DomainSubsetType getWCS11DomainSubset() {
        DomainSubsetType domainSubset = this.wcs111GetCoverage.getDomainSubset();
        if (domainSubset == null) {
            domainSubset = Wcs11Factory.eINSTANCE.createDomainSubsetType();
            this.wcs111GetCoverage.setDomainSubset(domainSubset);
        }
        return domainSubset;
    }

    public String asXML(String version) throws IOException {
        if ("1.1.1".equals(version)) {
            Encoder encoder = new Encoder((Configuration)new WCSConfiguration());
            encoder.setIndenting(true);
            encoder.setOmitXMLDeclaration(true);
            encoder.getNamespaces().declarePrefix("ows", "http://www.opengis.net/ows/1.1");
            return encoder.encodeAsString((Object)this.wcs111GetCoverage, org.geotools.wcs.v1_1.WCS.GetCoverage);
        }
        Encoder encoder = new Encoder((Configuration)new org.geotools.wcs.v2_0.WCSConfiguration());
        encoder.setIndenting(true);
        encoder.setOmitXMLDeclaration(true);
        return encoder.encodeAsString((Object)this.getCoverageType, WCS.GetCoverage);
    }

    public static WCS2GetCoverageRequestBuilder newBuilder() {
        return new WCS2GetCoverageRequestBuilder();
    }
}

