/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.util.List;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geotools.util.MapEntry;
import org.junit.Assert;
import org.junit.Test;

public class CoverageIdConverterTest {
    @Test
    public void testEncode() {
        String result = NCNameResourceCodec.encode((String)"ws", (String)"name");
        Assert.assertEquals((Object)"ws__name", (Object)result);
    }

    @Test
    public void testDecode01() {
        String qualifiedName = "ws__name";
        List decode = NCNameResourceCodec.decode((String)qualifiedName);
        Assert.assertEquals((long)1L, (long)decode.size());
        Assert.assertEquals((Object)"ws", (Object)((MapEntry)decode.get(0)).getKey());
        Assert.assertEquals((Object)"name", (Object)((MapEntry)decode.get(0)).getValue());
    }

    @Test
    public void testDecode02() {
        String qualifiedName = "s1__s2__s3";
        List decode = NCNameResourceCodec.decode((String)qualifiedName);
        Assert.assertEquals((long)2L, (long)decode.size());
        Assert.assertEquals((Object)"s1__s2", (Object)((MapEntry)decode.get(0)).getKey());
        Assert.assertEquals((Object)"s3", (Object)((MapEntry)decode.get(0)).getValue());
        Assert.assertEquals((Object)"s1", (Object)((MapEntry)decode.get(1)).getKey());
        Assert.assertEquals((Object)"s2__s3", (Object)((MapEntry)decode.get(1)).getValue());
    }

    @Test
    public void testDecode03() {
        String qualifiedName = "s1___s2";
        List decode = NCNameResourceCodec.decode((String)qualifiedName);
        Assert.assertEquals((long)2L, (long)decode.size());
        Assert.assertEquals((Object)"s1_", (Object)((MapEntry)decode.get(0)).getKey());
        Assert.assertEquals((Object)"s2", (Object)((MapEntry)decode.get(0)).getValue());
        Assert.assertEquals((Object)"s1", (Object)((MapEntry)decode.get(1)).getKey());
        Assert.assertEquals((Object)"_s2", (Object)((MapEntry)decode.get(1)).getValue());
    }

    @Test
    public void testDecodeBad() {
        String qualifiedName = "bad_qualified_name";
        List decode = NCNameResourceCodec.decode((String)qualifiedName);
        Assert.assertEquals((long)1L, (long)decode.size());
        Assert.assertNull((Object)((MapEntry)decode.get(0)).getKey());
        Assert.assertEquals((Object)"bad_qualified_name", (Object)((MapEntry)decode.get(0)).getValue());
    }
}

