/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.HashMap;
import java.util.Map;
import net.opengis.wcs10.GetCoverageType;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.kvp.Wcs10GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageReaderTest
extends WCSTestSupport {
    static Wcs10GetCoverageRequestReader reader;

    @Before
    public void setUp() {
        reader = new Wcs10GetCoverageRequestReader(this.getCatalog());
    }

    @Test
    public void testMissingParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        raw.put("format", "image/tiff");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, boundingBox is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        raw.put("version", "1.0.0");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("crs", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        }
        catch (WcsException e) {
            Assert.fail((String)"This time all mandatory params where provided?");
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
    }

    private Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.0.0");
        raw.put("request", "GetCoverage");
        return raw;
    }

    @Test
    public void testUnknownCoverageParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = "fairyTales:rumpelstilskin";
        raw.put("sourcecoverage", "fairyTales:rumpelstilskin");
        raw.put("format", "SuperCoolFormat");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("crs", "EPSG:4326");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"That coverage is not registered???");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"sourcecoverage", (Object)e.getLocator());
        }
    }

    @Test
    public void testBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getSourceCoverage());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat().getValue());
        Assert.assertEquals((Object)"EPSG:4326", (Object)getCoverage.getOutput().getCrs().getValue());
    }

    @Test
    public void testInterpolation() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        raw.put("interpolation", "nearest neighbor");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getSourceCoverage());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat().getValue());
        Assert.assertEquals((Object)"nearest neighbor", (Object)getCoverage.getInterpolationMethod().toString());
        raw = this.baseMap();
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        raw.put("interpolation", "bilinear");
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getSourceCoverage());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat().getValue());
        Assert.assertEquals((Object)"bilinear", (Object)getCoverage.getInterpolationMethod().toString());
        raw = this.baseMap();
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        raw.put("interpolation", "nearest");
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getSourceCoverage());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat().getValue());
        Assert.assertEquals((Object)"nearest neighbor", (Object)getCoverage.getInterpolationMethod().toString());
        raw = this.baseMap();
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        raw.put("interpolation", "bicubic");
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getSourceCoverage());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat().getValue());
        Assert.assertEquals((Object)"bicubic", (Object)getCoverage.getInterpolationMethod().toString());
    }

    @Test
    public void testUnsupportedCRS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("CRS", "urn:ogc:def:crs:EPSG:6.6:-1000");
        raw.put("width", "150");
        raw.put("height", "150");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"crs", (Object)e.getLocator());
            Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        }
    }
}

