/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.IOException;
import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.wcs.test.WCSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WCSTestSupport {
    @Before
    public void revertTasmaniaDem() throws IOException {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
    }

    @Test
    public void testGetBasic() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodes = xpath.getMatchingNodes("//wcs:OnlineResource/@xlink:href", dom);
        Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String text = node.getTextContent();
            Assert.assertThat((Object)text, (Matcher)CoreMatchers.endsWith((String)"?"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtraOperationKVP() throws Exception {
        URLMangler testMangler = (baseURL, path, kvp, type) -> {
            if (type == URLMangler.URLType.SERVICE) {
                kvp.put("test", "abc");
            }
        };
        GeoServerExtensions.extensions(URLMangler.class);
        GeoServerExtensionsHelper.singleton((String)"wcs10CapsTestMangler", (Object)testMangler, (Class[])new Class[]{URLMangler.class});
        try {
            Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
            XpathEngine xpath = XMLUnit.newXpathEngine();
            NodeList nodes = xpath.getMatchingNodes("//wcs:OnlineResource/@xlink:href", dom);
            Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String text = node.getTextContent();
                Map kvp2 = KvpUtils.parseQueryString((String)text);
                Assert.assertEquals((Object)"abc", kvp2.get("test"));
                Assert.assertThat((Object)text, (Matcher)CoreMatchers.endsWith((String)"&"));
            }
        }
        finally {
            GeoServerExtensionsHelper.clear();
        }
    }

    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageStoreInfo cvInfo = this.getCatalog().getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart());
        cvInfo.setURL("file:///I/AM/NOT/THERE");
        this.getCatalog().save((StoreInfo)cvInfo);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        Assert.assertEquals((long)(count - 1), (long)dom.getElementsByTagName("wcs:CoverageOfferingBrief").getLength());
    }

    @Test
    public void testNoServiceContactInfo() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    @Test
    public void testPostBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    @Test
    public void testUpdateSequenceInferiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=-1");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((Object)"wcs:WCS_Capabilities", (Object)root.getNodeName());
        Assert.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateSequenceInferiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"-1\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((Object)"wcs:WCS_Capabilities", (Object)root.getNodeName());
        Assert.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateSequenceEqualsGet() throws Exception {
        long i = this.getGeoServer().getGlobal().getUpdateSequence();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&updateSequence=" + i);
        Node root = dom.getFirstChild();
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)"CurrentUpdateSequence", (Object)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("code").getNodeValue());
    }

    @Test
    public void testUpdateSequenceEqualsPost() throws Exception {
        long i = this.getGeoServer().getGlobal().getUpdateSequence();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"" + i + "\"/>";
        Document dom = this.postAsDOM("wcs", request);
        Node root = dom.getFirstChild();
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)"CurrentUpdateSequence", (Object)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("code").getNodeValue());
    }

    @Test
    public void testUpdateSequenceSuperiorGet() throws Exception {
        long i = this.getGeoServer().getGlobal().getUpdateSequence() + 1L;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&updateSequence=" + i);
        this.checkOws11Exception(dom);
    }

    @Test
    public void testUpdateSequenceSuperiorPost() throws Exception {
        long i = this.getGeoServer().getGlobal().getUpdateSequence() + 1L;
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"" + i + "\" version=\"1.0.0\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkOws11Exception(dom);
    }

    @Test
    public void testSectionsBogus() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=Bogus");
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)"/ServiceExceptionReport/ServiceException/@code", (Document)dom);
    }

    @Test
    public void testSectionsAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=/");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Service)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Capability)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ContentMetadata)", (Document)dom);
    }

    @Test
    public void testAcceptVersions() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&acceptversions=1.0.0");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    @Test
    public void testOneSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=/WCS_Capabilities/Service");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Service)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:Capability)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:ContentMetadata)", (Document)dom);
    }

    @Test
    public void testMetadataLinks() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/tasmania/dem.xml");
        ml.setMetadataType("FGDC");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.print(dom);
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        String xpathBase = "//wcs:CoverageOfferingBrief[wcs:name = '" + this.getLayerId(MockData.TASMANIA_DEM) + "']/wcs:metadataLink";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"FGDC", (String)(xpathBase + "/@metadataType"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)(xpathBase + "/@xlink:href"), (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        try {
            Catalog catalog = this.getCatalog();
            CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
            MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
            ml.setContent("/metadata?key=value");
            ml.setMetadataType("FGDC");
            ml.setAbout("http://www.geoserver.org");
            ci.getMetadataLinks().add(ml);
            catalog.save((ResourceInfo)ci);
            String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
            Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
            this.print(dom);
            this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
            String xpathBase = "//wcs:CoverageOfferingBrief[wcs:name = '" + this.getLayerId(MockData.TASMANIA_DEM) + "']/wcs:metadataLink";
            XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"FGDC", (String)(xpathBase + "/@metadataType"), (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?key=value"), (String)(xpathBase + "/@xlink:href"), (Document)dom);
        }
        finally {
            global.getSettings().setProxyBaseUrl(null);
            this.getGeoServer().save(global);
        }
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        int expected = this.getCatalog().getCoverageStores().size();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        Assert.assertEquals((long)expected, (long)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
        expected = this.getCatalog().getCoverageStoresByWorkspace(MockData.CDF_PREFIX).size();
        dom = this.getAsDOM("cdf/wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        Assert.assertEquals((long)expected, (long)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
    }

    @Test
    public void testLayerQualified() throws Exception {
        int expected = this.getCatalog().getCoverageStores().size();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        Assert.assertEquals((long)expected, (long)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
        dom = this.getAsDOM("wcs/World/wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
    }

    @Test
    public void testTimeCoverage() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        String base = "//wcs:CoverageOfferingBrief[wcs:name='wcs:watertemp']//wcs:lonLatEnvelope";
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)(base + "/gml:timePosition[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)(base + "/gml:timePosition[2]"), (Document)dom);
    }

    @Test
    public void testTimeRangeCoverage() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        String base = "//wcs:CoverageOfferingBrief[wcs:name='sf:timeranges']//wcs:lonLatEnvelope";
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)(base + "/gml:timePosition[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)(base + "/gml:timePosition[2]"), (Document)dom);
    }
}

