/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.opengis.coverage.grid.GridCoverage;

public class AscCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public static final String ARCGRID_COVERAGE_FORMAT = "ARCGRID";
    public static final String ARCGRID_COMPRESSED_COVERAGE_FORMAT = "ARCGRID-GZIP";
    private static final String ARCGRID_MIME_TYPE = "text/plain";
    private static final String ARCGRID_COMPRESSED_MIME_TYPE = "application/x-gzip";
    private static final String ARCGRID_FILE_EXTENSION = "asc";
    private static final String ARCGRID_COMPRESSED_FILE_EXTENSION = "asc.gz";

    public AscCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, Arrays.asList(ARCGRID_COVERAGE_FORMAT, ARCGRID_COMPRESSED_COVERAGE_FORMAT, "ArcGrid", "ArcGrid-GZIP"), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ArcGrid", AscCoverageResponseDelegate.ARCGRID_FILE_EXTENSION);
                this.put("ArcGrid-GZIP", AscCoverageResponseDelegate.ARCGRID_COMPRESSED_FILE_EXTENSION);
                this.put(AscCoverageResponseDelegate.ARCGRID_MIME_TYPE, AscCoverageResponseDelegate.ARCGRID_FILE_EXTENSION);
                this.put(AscCoverageResponseDelegate.ARCGRID_COMPRESSED_MIME_TYPE, AscCoverageResponseDelegate.ARCGRID_COMPRESSED_FILE_EXTENSION);
                this.put(AscCoverageResponseDelegate.ARCGRID_COVERAGE_FORMAT, AscCoverageResponseDelegate.ARCGRID_FILE_EXTENSION);
                this.put(AscCoverageResponseDelegate.ARCGRID_COMPRESSED_COVERAGE_FORMAT, AscCoverageResponseDelegate.ARCGRID_COMPRESSED_FILE_EXTENSION);
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ArcGrid", AscCoverageResponseDelegate.ARCGRID_MIME_TYPE);
                this.put("ArcGrid-GZIP", AscCoverageResponseDelegate.ARCGRID_COMPRESSED_MIME_TYPE);
                this.put(AscCoverageResponseDelegate.ARCGRID_COVERAGE_FORMAT, AscCoverageResponseDelegate.ARCGRID_MIME_TYPE);
                this.put(AscCoverageResponseDelegate.ARCGRID_COMPRESSED_COVERAGE_FORMAT, AscCoverageResponseDelegate.ARCGRID_COMPRESSED_MIME_TYPE);
            }
        });
    }

    private boolean isOutputCompressed(String outputFormat) {
        return ARCGRID_COMPRESSED_COVERAGE_FORMAT.equalsIgnoreCase(outputFormat) || "application/arcgrid;gzipped=\"true\"".equals(outputFormat) || ARCGRID_COMPRESSED_MIME_TYPE.equals(outputFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        if (sourceCoverage == null) {
            throw new IllegalStateException(new StringBuffer("It seems prepare() has not been called").append(" or has not succeeded").toString());
        }
        GZIPOutputStream gzipOut = null;
        if (this.isOutputCompressed(outputFormat)) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        ArcGridWriter writer = null;
        try {
            writer = new ArcGridWriter((Object)output);
            writer.write((GridCoverage)sourceCoverage, null);
            if (gzipOut != null) {
                gzipOut.finish();
                gzipOut.flush();
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.dispose();
                }
            }
            catch (Throwable throwable) {}
            if (gzipOut != null) {
                IOUtils.closeQuietly((OutputStream)gzipOut);
            }
            sourceCoverage.dispose(true);
        }
    }
}

