/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/self/password"})
public class UserPasswordController
extends RestBaseController {
    static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.rest");
    static final String UP_NEW_PW = "newPassword";
    static final String XML_ROOT_ELEM = "userPassword";

    @GetMapping
    public void passwordGet() {
        throw new RestException("You can not request the password!", HttpStatus.METHOD_NOT_ALLOWED);
    }

    @PutMapping(consumes={"application/json", "application/xml", "text/xml", "text/json"})
    public void passwordPut(@RequestBody Map<String, String> putMap) {
        if (!this.getManager().checkAuthenticationForRole(SecurityContextHolder.getContext().getAuthentication(), GeoServerRole.AUTHENTICATED_ROLE)) {
            throw new RestException("Amdinistrative privelges required", HttpStatus.METHOD_NOT_ALLOWED);
        }
        try {
            String userName = SecurityContextHolder.getContext().getAuthentication().getName();
            GeoServerUserGroupService ugService = null;
            for (GeoServerUserGroupService service : this.getManager().loadUserGroupServices()) {
                if (service.getUserByUsername(userName) == null) continue;
                ugService = service;
                break;
            }
            if (ugService == null) {
                throw new RestException("Cannot calculate if PUT is allowed (service not found)", HttpStatus.UNPROCESSABLE_ENTITY);
            }
        }
        catch (IOException e) {
            throw new RestException("Cannot calculate if PUT is allowed (" + e.getMessage() + ")", HttpStatus.UNPROCESSABLE_ENTITY, (Throwable)e);
        }
        String newpass = putMap.get(UP_NEW_PW);
        if (StringUtils.isBlank((CharSequence)newpass)) {
            throw new RestException("Missing 'newPassword'", HttpStatus.BAD_REQUEST);
        }
        GeoServerUser user = null;
        GeoServerUserGroupService ugService = null;
        try {
            String userName = SecurityContextHolder.getContext().getAuthentication().getName();
            for (GeoServerUserGroupService service : this.getManager().loadUserGroupServices()) {
                user = service.getUserByUsername(userName);
                if (user == null) continue;
                ugService = service;
                break;
            }
        }
        catch (IOException e) {
            throw new RestException("Cannot retrieve user service", HttpStatus.FAILED_DEPENDENCY, (Throwable)e);
        }
        if (ugService == null) {
            throw new RestException("User service not found", HttpStatus.FAILED_DEPENDENCY);
        }
        if (!ugService.canCreateStore()) {
            throw new RestException("User service does not support changing pw", HttpStatus.FAILED_DEPENDENCY);
        }
        try {
            UserGroupStoreValidationWrapper ugStore = new UserGroupStoreValidationWrapper(ugService.createStore());
            user.setPassword(newpass);
            ugStore.updateUser(user);
            ugStore.store();
            ugService.load();
            LOGGER.log(Level.INFO, "Changed password for user {0}", user.getUsername());
        }
        catch (IOException e) {
            throw new RestException("Internal IO error", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (PasswordPolicyException e) {
            throw new RestException("Bad password", HttpStatus.UNPROCESSABLE_ENTITY, (Throwable)e);
        }
    }

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }
}

