/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import org.geoserver.rest.security.AbstractAclController;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/services"})
public class ServiceAccessController
extends AbstractAclController {
    public ServiceAccessController() {
        super(ServiceAccessRuleDAO.get());
    }

    protected void addRuleToMap(Comparable rule, Map map) {
        ServiceAccessRule ruleObject = (ServiceAccessRule)rule;
        map.put(ruleObject.getKey(), ruleObject.getValue());
    }

    protected String keyFor(Comparable rule) {
        return ((ServiceAccessRule)rule).getKey();
    }

    protected Comparable convertEntryToRule(Map.Entry entry) {
        String[] parts = this.parseElements((String)entry.getKey());
        return new ServiceAccessRule(parts[0], parts[1], this.parseRoles((String)entry.getValue()));
    }

    @Override
    protected String validateRuleKey(String ruleKey) {
        String[] elements = this.parseElements(ruleKey);
        if (elements.length != 2) {
            return "Invalid rule " + ruleKey + ", the expected format is service.method=role1,role2,...";
        }
        if ("*".equals(elements[0]) && !"*".equals(elements[1])) {
            return "Invalid rule " + ruleKey + ", when namespace is * then also layer must be *.";
        }
        return null;
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }

    @Override
    protected String getBasePath() {
        return "/security/acl/services";
    }
}

