/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.List;
import java.util.Map;
import org.geoserver.rest.catalog.MapXMLConverter;
import org.geoserver.rest.security.RuleMap;
import org.jdom2.Element;
import org.springframework.stereotype.Component;

@Component
public class RuleMapXMLConverter
extends MapXMLConverter {
    static final String ROOTELEMENT = "rules";
    static final String RULEELEMENT = "rule";
    static final String RESOURCEATTR = "resource";

    public int getPriority() {
        return 50;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return RuleMap.class.isAssignableFrom(clazz);
    }

    @Override
    protected String getMapName(Map<?, ?> map) {
        return ROOTELEMENT;
    }

    @Override
    protected final void insert(Element elem, Object o) {
        if (o instanceof RuleMap) {
            Map ruleMap = (Map)o;
            for (Map.Entry entry : ruleMap.entrySet()) {
                Element ruleElement = new Element(RULEELEMENT);
                ruleElement.setAttribute(RESOURCEATTR, (String)entry.getKey());
                ruleElement.setText((String)entry.getValue());
                elem.getChildren().add(ruleElement);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected Map<String, String> convert(Element elem) {
        RuleMap<String, String> ruleMap = new RuleMap<String, String>();
        List children = elem.getChildren();
        for (Element ruleElement : children) {
            String resource = ruleElement.getAttributeValue(RESOURCEATTR);
            ruleMap.put(resource, ruleElement.getTextTrim());
        }
        return ruleMap;
    }
}

