/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import java.util.regex.Pattern;
import org.geoserver.rest.security.AbstractAclController;
import org.geoserver.security.impl.RESTAccessRuleDAO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/rest"})
public class RestAccessController
extends AbstractAclController {
    static final Pattern KEYPATTERN = Pattern.compile("\\S+:(GET|POST|PUT|DELETE|HEAD)(,(GET|POST|PUT|DELETE|HEAD))*");

    public RestAccessController() {
        super(RESTAccessRuleDAO.get());
    }

    protected void addRuleToMap(Comparable rule, Map map) {
        String[] parts = ((String)((Object)rule)).split("=");
        map.put(parts[0], parts[1]);
    }

    protected String keyFor(Comparable rule) {
        return ((String)((Object)rule)).split("=")[0];
    }

    protected Comparable convertEntryToRule(Map.Entry entry) {
        return entry.getKey() + "=" + entry.getValue();
    }

    @Override
    protected String validateRuleKey(String ruleKey) {
        if (!KEYPATTERN.matcher(ruleKey).matches()) {
            return "Invalid '" + ruleKey + "' not matching " + KEYPATTERN;
        }
        return null;
    }

    @Override
    protected String getBasePath() {
        return "/security/acl/rest";
    }
}

