/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.NamedMap;
import org.geoserver.security.GeoServerSecurityManager;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/masterpw"})
public class MasterPasswordController
extends RestBaseController {
    static final String MP_CURRENT_KEY = "oldMasterPassword";
    static final String MP_NEW_KEY = "newMasterPassword";
    static final String XML_ROOT_ELEM = "masterPassword";

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    @GetMapping(produces={"application/json", "text/json", "application/xml", "text/xml"})
    public NamedMap<String, String> masterPasswordGet() throws IOException {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw new RestException("Amdinistrative privelges required", HttpStatus.FORBIDDEN);
        }
        char[] masterpw = this.getManager().getMasterPasswordForREST();
        NamedMap<String, String> m = new NamedMap<String, String>(XML_ROOT_ELEM);
        m.put(MP_CURRENT_KEY, new String(masterpw));
        this.getManager().disposePassword(masterpw);
        return m;
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void masterPasswordPut(@RequestBody Map<String, String> putMap) throws IOException {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw new RestException("Amdinistrative privelges required", HttpStatus.METHOD_NOT_ALLOWED);
        }
        try {
            String providerName = this.getManager().loadMasterPasswordConfig().getProviderName();
            if (this.getManager().loadMasterPassswordProviderConfig(providerName).isReadOnly()) {
                throw new RestException("Master password provider does not allow writes", HttpStatus.METHOD_NOT_ALLOWED);
            }
        }
        catch (IOException e) {
            throw new RestException("Master password provider does not allow writes", HttpStatus.METHOD_NOT_ALLOWED);
        }
        String current = putMap.get(MP_CURRENT_KEY);
        String newpass = putMap.get(MP_NEW_KEY);
        if (!StringUtils.isNotBlank((CharSequence)current)) {
            throw new RestException("no master password", HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.isNotBlank((CharSequence)newpass)) {
            throw new RestException("no master password", HttpStatus.BAD_REQUEST);
        }
        char[] currentArray = current.trim().toCharArray();
        char[] newpassArray = newpass.trim().toCharArray();
        GeoServerSecurityManager m = this.getManager();
        try {
            m.saveMasterPasswordConfig(m.loadMasterPasswordConfig(), currentArray, newpassArray, newpassArray);
        }
        catch (Exception e) {
            throw new RestException("Cannot change master password", HttpStatus.UNPROCESSABLE_ENTITY, (Throwable)e);
        }
        finally {
            m.disposePassword(currentArray);
            m.disposePassword(newpassArray);
        }
    }
}

