/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.resources;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import freemarker.template.ObjectWrapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.AtomLink;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.ResourceStoreFactory;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.XStreamJSONMessageConverter;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.converters.XStreamXMLMessageConverter;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;

@RestController
@RequestMapping(path={"/rest/resource", "/rest/resource/**"})
public class ResourceController
extends RestBaseController {
    private ResourceStore resources;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");
    private final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
    private final DateFormat FORMAT_HEADER = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    @Autowired
    public ResourceController(@Qualifier(value="resourceStore") ResourceStoreFactory factory) throws Exception {
        this.FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.FORMAT_HEADER.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.resources = factory.getObject();
    }

    public ResourceController(ResourceStore store) {
        this.FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.FORMAT_HEADER.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.resources = store;
    }

    protected String getTemplateName(Object object) {
        if (object instanceof ResourceDirectoryInfo) {
            return "resourceDirectoryInfo.ftl";
        }
        if (object instanceof ResourceMetadataInfo) {
            return "resourceMetadataInfo.ftl";
        }
        return super.getTemplateName(object);
    }

    protected static MediaType getMediaType(Resource resource, HttpServletRequest request) {
        if (resource.getType() == Resource.Type.DIRECTORY) {
            return ResourceController.getFormat(request);
        }
        if (resource.getType() == Resource.Type.RESOURCE) {
            String mimeType = URLConnection.guessContentTypeFromName(resource.name());
            if (mimeType == null || MediaType.APPLICATION_OCTET_STREAM.toString().equals(mimeType)) {
                try (BufferedInputStream is = new BufferedInputStream(resource.in());){
                    mimeType = URLConnection.guessContentTypeFromStream(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return mimeType == null ? MediaType.APPLICATION_OCTET_STREAM : MediaType.valueOf((String)mimeType);
        }
        return null;
    }

    protected Resource resource(HttpServletRequest request) {
        String path = request.getPathInfo();
        path = path.substring(9);
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RestException("Could not decode the resource URL to UTF-8 format", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return this.resources.get(path);
    }

    protected static Operation operation(String operation) {
        if (operation != null) {
            operation = operation.trim().toUpperCase();
            try {
                return Operation.valueOf(operation);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unknown operation '" + operation + "' requested");
            }
        }
        return Operation.DEFAULT;
    }

    protected static MediaType getFormat(HttpServletRequest request) {
        return ResourceController.getFormat(RESTUtils.getQueryStringValue((HttpServletRequest)request, (String)"format"));
    }

    protected static MediaType getFormat(String format) {
        if ("xml".equals(format)) {
            return MediaType.APPLICATION_XML;
        }
        if ("json".equals(format)) {
            return MediaType.APPLICATION_JSON;
        }
        return MediaType.TEXT_HTML;
    }

    protected static String href(String path) {
        return ResponseUtils.buildURL((String)RequestInfo.get().servletURI("resource/"), (String)ResponseUtils.urlEncode((String)path, (char[])new char[]{'/'}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
    }

    protected static String formatHtmlLink(String link) {
        return link.replaceAll("&", "&amp;");
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, produces={"*/*"})
    public Object resourceGet(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="operation", required=false, defaultValue="default") String operationName, @RequestParam(required=false, defaultValue="text/html") String format) {
        Object result;
        Resource resource = this.resource(request);
        Operation operation = ResourceController.operation(operationName);
        response.setContentType(ResourceController.getFormat(format).toString());
        if (operation == Operation.METADATA) {
            result = this.wrapObject(new ResourceMetadataInfo(resource, request), ResourceMetadataInfo.class);
        } else {
            if (resource.getType() == Resource.Type.UNDEFINED) {
                throw new ResourceNotFoundException("Undefined resource path.");
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            MediaType mediaType = ResourceController.getMediaType(resource, request);
            responseHeaders.setContentType(mediaType);
            response.setContentType(mediaType.toString());
            result = request.getMethod().equals("HEAD") ? new ResponseEntity((Object)"", (MultiValueMap)responseHeaders, HttpStatus.OK) : (resource.getType() == Resource.Type.DIRECTORY ? this.wrapObject(new ResourceDirectoryInfo(resource, request), ResourceDirectoryInfo.class) : new ResponseEntity((Object)resource.in(), (MultiValueMap)responseHeaders, HttpStatus.OK));
            response.setHeader("Location", ResourceController.href(resource.path()));
            response.setHeader("Last-Modified", this.FORMAT_HEADER.format(resource.lastmodified()));
            if (!"".equals(resource.path())) {
                response.setHeader("Resource-Parent", ResourceController.href(resource.parent().path()));
            }
            response.setHeader("Resource-Type", resource.getType().toString().toLowerCase());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PutMapping(consumes={"*/*"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void resourcePut(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="operation", required=false, defaultValue="default") String operationName) {
        boolean isNew;
        Resource resource = this.resource(request);
        if (resource.getType() == Resource.Type.DIRECTORY) {
            throw new RestException("Attempting to write data to a directory.", HttpStatus.METHOD_NOT_ALLOWED);
        }
        Operation operation = ResourceController.operation(operationName);
        if (operation == Operation.METADATA) {
            throw new RestException("Attempting to write data to metadata.", HttpStatus.METHOD_NOT_ALLOWED);
        }
        boolean bl = isNew = resource.getType() == Resource.Type.UNDEFINED;
        if (operation == Operation.COPY || operation == Operation.MOVE) {
            String path;
            try {
                path = IOUtils.toString((InputStream)request.getInputStream());
            }
            catch (IOException e) {
                throw new RestException("Unable to read content:" + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
            Resource source = this.resources.get(path);
            if (source.getType() == Resource.Type.UNDEFINED) {
                throw new RestException("Unable to locate '" + path + "'.", HttpStatus.NOT_FOUND);
            }
            if (operation == Operation.MOVE) {
                boolean moved = source.renameTo(resource);
                if (!moved) {
                    throw new RestException("Rename operation failed.", HttpStatus.INTERNAL_SERVER_ERROR);
                }
            } else {
                if (source.getType() == Resource.Type.DIRECTORY) {
                    throw new RestException("Cannot copy directory.", HttpStatus.METHOD_NOT_ALLOWED);
                }
                try {
                    IOUtils.copy((InputStream)source.in(), (OutputStream)resource.out());
                }
                catch (IOException e) {
                    throw new RestException("Copy operation failed:" + e, HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
        } else {
            if (operation != Operation.DEFAULT) throw new IllegalStateException("Unexpected operation '" + (Object)((Object)operation) + "'");
            try {
                IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)resource.out());
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.fine("PUT resource: " + resource.path());
                }
            }
            catch (IOException e) {
                throw new RestException("Unable to read content to '" + resource.path() + "':" + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if (!isNew) return;
        response.setStatus(HttpStatus.CREATED.value());
    }

    @DeleteMapping
    public void resourceDelete(HttpServletRequest request) {
        Resource resource = this.resource(request);
        if (Resource.Type.UNDEFINED.equals((Object)resource.getType())) {
            throw new ResourceNotFoundException("Resource '" + resource.path() + "' not found");
        }
        boolean removed = resource.delete();
        if (!removed) {
            throw new RestException("Resource '" + resource.path() + "' not removed", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected Resource fileUpload(Resource directory, String filename, HttpServletRequest request) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("PUT file: mimetype=" + request.getContentType() + ", path=" + directory.path());
        }
        try {
            return RESTUtils.handleBinUpload((String)filename, (Resource)directory, (boolean)false, (HttpServletRequest)request);
        }
        catch (IOException problem) {
            throw new RestException(problem.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)problem);
        }
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xstream = persister.getXStream();
        xstream.alias("child", ResourceChildInfo.class);
        xstream.alias("ResourceDirectory", ResourceDirectoryInfo.class);
        xstream.alias("ResourceMetadata", ResourceMetadataInfo.class);
        if (converter instanceof XStreamXMLMessageConverter) {
            AtomLink.configureXML(xstream);
            xstream.aliasField("atom:link", ResourceParentInfo.class, "link");
            xstream.aliasField("atom:link", ResourceChildInfo.class, "link");
        } else if (converter instanceof XStreamJSONMessageConverter) {
            AtomLink.configureJSON(xstream);
        }
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper(clazz, Arrays.asList(AtomLink.class, ResourceDirectoryInfo.class, ResourceMetadataInfo.class, ResourceParentInfo.class, ResourceChildInfo.class));
    }

    @XStreamAlias(value="ResourceDirectory")
    protected static class ResourceDirectoryInfo
    extends ResourceMetadataInfo {
        private List<ResourceChildInfo> children = new ArrayList<ResourceChildInfo>();

        public ResourceDirectoryInfo(String name, ResourceParentInfo parent, Date lastModified, String type) {
            super(name, parent, lastModified, type);
        }

        public ResourceDirectoryInfo(Resource resource, HttpServletRequest request) {
            super(resource, request, true);
            for (Resource child : resource.list()) {
                this.children.add(new ResourceChildInfo(child.name(), new AtomLink(ResourceController.href(child.path()), "alternate", ResourceController.getMediaType(child, request).toString())));
            }
        }

        public List<ResourceChildInfo> getChildren() {
            return this.children;
        }
    }

    @XStreamAlias(value="ResourceMetadata")
    protected static class ResourceMetadataInfo {
        private String name;
        private ResourceParentInfo parent;
        private Date lastModified;
        private String type;

        public ResourceMetadataInfo(String name, ResourceParentInfo parent, Date lastModified, String type) {
            this.name = name;
            this.parent = parent;
            this.lastModified = lastModified;
            this.type = type;
        }

        protected ResourceMetadataInfo(Resource resource, HttpServletRequest request, boolean isDir) {
            if (!resource.path().isEmpty()) {
                this.parent = new ResourceParentInfo("/" + resource.parent().path(), new AtomLink(ResourceController.href(resource.parent().path()), "alternate", ResourceController.getFormat(request).toString()));
            }
            this.lastModified = new Date(resource.lastmodified());
            this.type = isDir ? null : resource.getType().toString().toLowerCase();
            this.name = resource.name();
        }

        public ResourceMetadataInfo(Resource resource, HttpServletRequest request) {
            this(resource, request, false);
        }

        public ResourceParentInfo getParent() {
            return this.parent;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    @XStreamAlias(value="child")
    protected static class ResourceChildInfo {
        private String name;
        private AtomLink link;

        public ResourceChildInfo(String name, AtomLink link) {
            this.name = name;
            this.link = link;
        }

        public String getName() {
            return this.name;
        }

        public AtomLink getLink() {
            return this.link;
        }
    }

    protected static class ResourceParentInfo {
        private String path;
        private AtomLink link;

        public ResourceParentInfo(String path, AtomLink link) {
            this.path = path;
            this.link = link;
        }

        public String getPath() {
            return this.path;
        }

        public AtomLink getLink() {
            return this.link;
        }
    }

    public static enum Operation {
        DEFAULT,
        METADATA,
        MOVE,
        COPY;

    }

    @Configuration
    static class ResourceControllerConfiguration {
        ResourceControllerConfiguration() {
        }

        @Bean
        ContentNegotiationStrategy resourceContentNegotiationStrategy() {
            return webRequest -> {
                HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
                if (new PatternsRequestCondition(new String[]{"/resource", "/resource/**"}).getMatchingCondition(request) != null) {
                    return Collections.singletonList(ResourceController.getFormat(request));
                }
                return new ArrayList();
            };
        }
    }
}

