/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/rest/workspaces"}, produces={"application/json", "application/xml", "text/html"})
public class WorkspaceController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(WorkspaceController.class);

    @Autowired
    public WorkspaceController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping
    public RestWrapper workspacesGet() {
        List wkspaces = this.catalog.getWorkspaces();
        return this.wrapList(wkspaces, WorkspaceInfo.class);
    }

    @GetMapping(value={"/{workspaceName}"})
    public RestWrapper<WorkspaceInfo> workspaceGet(@PathVariable String workspaceName) {
        WorkspaceInfo wkspace = this.catalog.getWorkspaceByName(workspaceName);
        if (wkspace == null) {
            throw new ResourceNotFoundException("No such workspace: '" + workspaceName + "' found");
        }
        LOGGER.info("GET " + workspaceName);
        LOGGER.info("got " + wkspace.getName());
        return this.wrapObject(wkspace, WorkspaceInfo.class);
    }

    @PostMapping(consumes={"text/xml", "application/xml", "text/json", "application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> workspacePost(@RequestBody WorkspaceInfo workspace, @RequestParam(defaultValue="false", name="default") boolean makeDefault, UriComponentsBuilder builder) {
        if (this.catalog.getWorkspaceByName(workspace.getName()) != null) {
            throw new RestException("Workspace '" + workspace.getName() + "' already exists", HttpStatus.UNAUTHORIZED);
        }
        this.catalog.add(workspace);
        String name = workspace.getName();
        LOGGER.info("Added workspace " + name);
        if (makeDefault) {
            this.catalog.setDefaultWorkspace(workspace);
            LOGGER.info("made workspace " + name + " default");
        }
        LOGGER.info("POST workspace " + name);
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            LOGGER.fine("Automatically creating namespace for workspace " + workspace.getName());
            namespace = this.catalog.getFactory().createNamespace();
            namespace.setPrefix(workspace.getName());
            namespace.setURI("http://" + workspace.getName());
            namespace.setIsolated(workspace.isIsolated());
            this.catalog.add(namespace);
        }
        UriComponents uriComponents = this.getUriComponents(name, builder);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        return new ResponseEntity((Object)name, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/{workspaceName}"}, consumes={"text/xml", "application/xml", "text/json", "application/json"})
    public void workspacePut(@RequestBody WorkspaceInfo workspace, @PathVariable String workspaceName, UriComponentsBuilder builder) {
        if ("default".equals(workspaceName)) {
            this.catalog.setDefaultWorkspace(workspace);
        } else {
            WorkspaceInfo wks = this.catalog.getWorkspaceByName(workspaceName);
            if (wks == null) {
                throw new RestException("Can't change a non existant workspace (" + workspaceName + ")", HttpStatus.NOT_FOUND);
            }
            String infoName = workspace.getName();
            if (infoName != null && infoName.isEmpty()) {
                throw new RestException("The workspace name cannot be empty", HttpStatus.FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateWorkspace(wks, workspace);
            this.catalog.save(wks);
        }
    }

    @DeleteMapping(path={"/{workspaceName}"})
    protected void workspaceDelete(@PathVariable String workspaceName, @RequestParam(defaultValue="false", name="recurse") boolean recurse) {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspaceName);
        if (ws == null) {
            throw new RestException("Workspace '" + workspaceName + "' not found", HttpStatus.NOT_FOUND);
        }
        if (!recurse) {
            if (!this.catalog.getStoresByWorkspace(ws, StoreInfo.class).isEmpty()) {
                throw new RestException("Workspace not empty", HttpStatus.FORBIDDEN);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws.getName());
            if (ns != null) {
                if (!this.catalog.getFeatureTypesByNamespace(ns).isEmpty()) {
                    throw new RestException("Namespace for workspace not empty.", HttpStatus.FORBIDDEN);
                }
                this.catalog.remove(ns);
            }
            this.catalog.remove(ws);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(ws);
        }
        LOGGER.info("DELETE workspace " + ws);
    }

    private UriComponents getUriComponents(String name, UriComponentsBuilder builder) {
        UriComponents uriComponents = builder.path("/workspaces/{id}").buildAndExpand(new Object[]{name});
        return uriComponents;
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<WorkspaceInfo>(WorkspaceInfo.class){

            protected void wrapInternal(Map<String, Object> properties, SimpleHash model, WorkspaceInfo wkspace) {
                if (properties == null) {
                    try {
                        properties = model.toMap();
                    }
                    catch (TemplateModelException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                this.collectSources(DataStoreInfo.class, "dataStores", properties, wkspace);
                this.collectSources(CoverageStoreInfo.class, "coverageStores", properties, wkspace);
                this.collectSources(WMSStoreInfo.class, "wmsStores", properties, wkspace);
                this.collectSources(WMTSStoreInfo.class, "wmtsStores", properties, wkspace);
                WorkspaceInfo def = WorkspaceController.this.catalog.getDefaultWorkspace();
                if (def.equals(wkspace)) {
                    properties.put("isDefault", Boolean.TRUE);
                } else {
                    properties.put("isDefault", Boolean.FALSE);
                }
            }

            protected <T extends StoreInfo> void collectSources(Class<T> clazz, String propsName, Map<String, Object> properties, WorkspaceInfo wkspace) {
                ArrayList dsProps = new ArrayList();
                List wmssources = WorkspaceController.this.catalog.getStoresByWorkspace(wkspace, clazz);
                for (StoreInfo ds : wmssources) {
                    HashMap<String, String> names = new HashMap<String, String>();
                    names.put("name", ds.getName());
                    dsProps.add(Collections.singletonMap("properties", names));
                }
                if (!dsProps.isEmpty()) {
                    properties.putIfAbsent(propsName, dsProps);
                }
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    WorkspaceInfo wk = (WorkspaceInfo)w;
                    this.wrapInternal(null, model, wk);
                }
            }
        };
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WorkspaceInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<WorkspaceInfo> getObjectClass() {
                return WorkspaceInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = (Map)RequestContextHolder.getRequestAttributes().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                String workspace = (String)uriTemplateVars.get("workspaceName");
                if (workspace == null) {
                    return null;
                }
                return WorkspaceController.this.catalog.getWorkspaceByName(workspace);
            }

            protected void postEncodeWorkspace(WorkspaceInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("dataStores");
                converter.encodeCollectionLink("datastores", writer);
                writer.endNode();
                writer.startNode("coverageStores");
                converter.encodeCollectionLink("coveragestores", writer);
                writer.endNode();
                writer.startNode("wmsStores");
                converter.encodeCollectionLink("wmsstores", writer);
                writer.endNode();
                writer.startNode("wmtsStores");
                converter.encodeCollectionLink("wmtsstores", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    converter.encodeLink("/workspaces/" + converter.encode(ref), writer);
                }
            }
        });
    }

    protected String getTemplateName(Object object) {
        if (object instanceof WorkspaceInfo) {
            return "WorkspaceInfo";
        }
        return null;
    }
}

