/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/wmtsstores"})
public class WMTSStoreController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(WMTSStoreController.class);

    @Autowired
    public WMTSStoreController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<WMTSStoreInfo> getStores(@PathVariable String workspaceName) {
        List stores = this.catalog.getStoresByWorkspace(workspaceName, WMTSStoreInfo.class);
        return this.wrapList(stores, WMTSStoreInfo.class);
    }

    @GetMapping(path={"/{storeName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<WMTSStoreInfo> getStore(@PathVariable String workspaceName, @PathVariable String storeName) {
        WMTSStoreInfo store = this.getExistingWMTSStore(workspaceName, storeName);
        return this.wrapObject(store, WMTSStoreInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> postStore(@RequestBody WMTSStoreInfo store, @PathVariable String workspaceName, UriComponentsBuilder builder) {
        if (store.getWorkspace() != null) {
            WorkspaceInfo ws = store.getWorkspace();
            if (!workspaceName.equals(ws.getName())) {
                throw new RestException("Expected workspace " + workspaceName + " but client specified " + ws.getName(), HttpStatus.FORBIDDEN);
            }
        } else {
            store.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
        }
        store.setEnabled(true);
        this.catalog.validate((StoreInfo)store, false).throwIfInvalid();
        this.catalog.add((StoreInfo)store);
        String storeName = store.getName();
        LOGGER.info("POST wmts store " + storeName);
        UriComponents uriComponents = builder.path("/workspaces/{workspaceName}/wmtsstores/{storeName}").buildAndExpand(new Object[]{workspaceName, storeName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        return new ResponseEntity((Object)storeName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/{storeName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void putStore(@RequestBody WMTSStoreInfo info, @PathVariable String workspaceName, @PathVariable String storeName) {
        WMTSStoreInfo original = this.getExistingWMTSStore(workspaceName, storeName);
        if (info.getWorkspace() != null && !original.getWorkspace().equals(info.getWorkspace())) {
            throw new RestException("Attempting to move " + storeName + " from " + original.getWorkspace().getName() + " to " + info.getWorkspace().getName() + " via PUT", HttpStatus.FORBIDDEN);
        }
        if (!original.getName().equals(info.getName())) {
            throw new RestException("Attempting to rename " + storeName + " to " + info.getName() + " via PUT", HttpStatus.FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateWMTSStore(original, info);
        this.catalog.validate((StoreInfo)original, false).throwIfInvalid();
        this.catalog.save((StoreInfo)original);
        this.clear(original);
        LOGGER.info("PUT wmts store " + workspaceName + "," + storeName);
    }

    private WMTSStoreInfo getExistingWMTSStore(String workspaceName, String storeName) {
        WMTSStoreInfo original = (WMTSStoreInfo)this.catalog.getStoreByName(workspaceName, storeName, WMTSStoreInfo.class);
        if (original == null) {
            throw new ResourceNotFoundException("No such wmts store: " + workspaceName + "," + storeName);
        }
        return original;
    }

    @DeleteMapping(value={"/{storeName}"})
    public void deleteStore(@PathVariable String workspaceName, @PathVariable String storeName, @RequestParam(name="recurse", required=false, defaultValue="false") boolean recurse) throws IOException {
        WMTSStoreInfo cs = this.getExistingWMTSStore(workspaceName, storeName);
        if (!recurse) {
            if (!this.catalog.getResourcesByStore((StoreInfo)cs, WMTSLayerInfo.class).isEmpty()) {
                throw new RestException("wmtsstore not empty", HttpStatus.UNAUTHORIZED);
            }
            this.catalog.remove((StoreInfo)cs);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(cs);
        }
        this.clear(cs);
        LOGGER.info("DELETE wmts store " + workspaceName + ":s" + workspaceName);
    }

    void clear(WMTSStoreInfo info) {
        this.catalog.getResourcePool().clear(info);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WMTSStoreInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<WMTSStoreInfo> getObjectClass() {
                return WMTSStoreInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = (Map)RequestContextHolder.getRequestAttributes().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String store = (String)uriTemplateVars.get("storeName");
                if (workspace == null || store == null) {
                    return null;
                }
                return WMTSStoreController.this.catalog.getStoreByName(workspace, store, WMTSStoreInfo.class);
            }

            protected void postEncodeWMTSStore(WMTSStoreInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("layers");
                converter.encodeCollectionLink("layers", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    converter.encodeLink("/workspaces/" + converter.encode(ref), writer);
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<WMTSStoreInfo>(WMTSStoreInfo.class){

            protected void wrapInternal(Map properties, SimpleHash model, WMTSStoreInfo store) {
                if (properties == null) {
                    try {
                        properties = model.toMap();
                    }
                    catch (TemplateModelException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                ArrayList dsProps = new ArrayList();
                List resources = WMTSStoreController.this.catalog.getResourcesByStore((StoreInfo)store, WMTSLayerInfo.class);
                for (WMTSLayerInfo resource : resources) {
                    HashMap<String, String> names = new HashMap<String, String>();
                    names.put("name", resource.getName());
                    dsProps.add(Collections.singletonMap("properties", names));
                }
                if (!dsProps.isEmpty()) {
                    properties.putIfAbsent("layers", dsProps);
                }
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    WMTSStoreInfo wk = (WMTSStoreInfo)w;
                    this.wrapInternal((Map)null, model, wk);
                }
            }
        };
    }
}

