/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.AvailableResources;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/wmtslayers", "/rest/workspaces/{workspaceName}/wmtsstores/{storeName}/layers"})
public class WMTSLayerController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(WMTSLayerController.class);

    @Autowired
    public WMTSLayerController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public Object layersGet(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @RequestParam(required=false, defaultValue="false") boolean quietOnNotFound, @RequestParam(required=false, defaultValue="configured") String list) {
        switch (list) {
            case "available": {
                LOGGER.fine(() -> this.logMessage("GET available WMTS layers from ", workspaceName, storeName, null));
                return new AvailableResources(this.getAvailableLayersInternal(workspaceName, storeName, quietOnNotFound), "wmtsLayerName");
            }
            case "configured": {
                LOGGER.fine(() -> this.logMessage("GET configured WMTS layers from ", workspaceName, storeName, null));
                return this.wrapList(this.getConfiguredLayersInternal(workspaceName, storeName, quietOnNotFound), WMTSLayerInfo.class);
            }
        }
        throw new RestException("Unknown list type " + list, HttpStatus.NOT_IMPLEMENTED);
    }

    Collection<WMTSStoreInfo> getStoresInternal(NamespaceInfo ns, String storeName, boolean quietOnNotFound) {
        if (Objects.nonNull(storeName)) {
            return Collections.singleton(this.getStoreInternal(ns, storeName));
        }
        return this.catalog.getStoresByWorkspace(ns.getPrefix(), WMTSStoreInfo.class);
    }

    List<String> getAvailableLayersInternal(String workspaceName, String storeName, boolean quietOnNotFound) {
        NamespaceInfo ns = this.getNamespaceInternal(workspaceName);
        Collection<WMTSStoreInfo> stores = this.getStoresInternal(ns, storeName, quietOnNotFound);
        return stores.stream().flatMap(store -> {
            WebMapTileServer ds;
            try {
                ds = store.getWebMapTileServer(null);
            }
            catch (IOException e) {
                throw new RestException("Could not load wmts store: " + storeName, HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
            List layerList = ds.getCapabilities().getLayerList();
            return layerList.stream().map(Layer::getName).filter(Objects::nonNull).filter(name -> !name.isEmpty()).filter(name -> !this.layerConfigured((WMTSStoreInfo)store, (String)name));
        }).collect(Collectors.toList());
    }

    boolean layerConfigured(WMTSStoreInfo store, String nativeName) {
        Filter filter = Predicates.and((Filter)Predicates.equal((String)"store.name", (Object)store.getName()), (Filter)Predicates.equal((String)"nativeName", (Object)nativeName));
        try (CloseableIterator it = this.catalog.list(WMTSLayerInfo.class, filter, Integer.valueOf(0), Integer.valueOf(1), null);){
            boolean bl = it.hasNext();
            return bl;
        }
    }

    List<WMTSLayerInfo> getConfiguredLayersInternal(String workspaceName, String storeName, boolean quietOnNotFound) {
        NamespaceInfo ns = this.getNamespaceInternal(workspaceName);
        Collection<WMTSStoreInfo> stores = this.getStoresInternal(ns, storeName, quietOnNotFound);
        return stores.stream().flatMap(store -> this.catalog.getResourcesByStore((StoreInfo)store, WMTSLayerInfo.class).stream()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{layerName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<WMTSLayerInfo> layerGet(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String layerName) {
        LOGGER.fine(() -> this.logMessage("GET", workspaceName, storeName, layerName));
        WMTSLayerInfo layer = this.getResourceInternal(workspaceName, storeName, layerName);
        return this.wrapObject(layer, WMTSLayerInfo.class);
    }

    protected NamespaceInfo getNamespaceInternal(String workspaceName) {
        if (Objects.isNull(workspaceName)) {
            throw new NullPointerException();
        }
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspaceName);
        if (Objects.isNull(ns)) {
            throw new ResourceNotFoundException("Could not find workspace " + workspaceName);
        }
        return ns;
    }

    protected WMTSStoreInfo getStoreInternal(NamespaceInfo ns, String storeName) {
        if (Objects.isNull(storeName)) {
            throw new NullPointerException();
        }
        return (WMTSStoreInfo)this.catalog.getStoreByName(ns.getPrefix(), storeName, WMTSStoreInfo.class);
    }

    protected WMTSLayerInfo getResourceInternal(String workspaceName, @Nullable String storeName, String layerName) {
        NamespaceInfo ns = this.getNamespaceInternal(workspaceName);
        if (Objects.isNull(layerName)) {
            throw new NullPointerException();
        }
        if (Objects.isNull(storeName)) {
            WMTSLayerInfo layer = (WMTSLayerInfo)this.catalog.getResourceByName(ns, layerName, WMTSLayerInfo.class);
            if (Objects.isNull(layer)) {
                throw new ResourceNotFoundException("No such cascaded wmts: " + workspaceName + "," + layerName);
            }
            return layer;
        }
        WMTSStoreInfo store = this.getStoreInternal(ns, storeName);
        WMTSLayerInfo layer = (WMTSLayerInfo)this.catalog.getResourceByStore((StoreInfo)store, layerName, WMTSLayerInfo.class);
        if (Objects.isNull(layer)) {
            throw new ResourceNotFoundException("No such cascaded wmts: " + workspaceName + "," + layerName);
        }
        return layer;
    }

    @PutMapping(value={"/{layerName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void layerPut(@RequestBody WMTSLayerInfo update, @PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String layerName, @RequestParam(name="calculate", required=false) String calculate) {
        LOGGER.fine(() -> this.logMessage("PUT", workspaceName, storeName, layerName));
        WMTSLayerInfo original = this.getResourceInternal(workspaceName, storeName, layerName);
        this.calculateOptionalFields((ResourceInfo)update, (ResourceInfo)original, calculate);
        new CatalogBuilder(this.catalog).updateWMTSLayer(original, update);
        this.catalog.validate((ResourceInfo)original, false).throwIfInvalid();
        this.catalog.getResourcePool().clear(original.getStore());
        this.catalog.save((ResourceInfo)original);
    }

    @DeleteMapping(value={"/{layerName}"})
    public void layerDelete(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String layerName, @RequestParam(name="recurse", defaultValue="false") boolean recurse) {
        LOGGER.fine(() -> this.logMessage("DELETE", workspaceName, storeName, layerName));
        WMTSLayerInfo resource = this.getResourceInternal(workspaceName, storeName, layerName);
        List layers = this.catalog.getLayers((ResourceInfo)resource);
        if (recurse) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE WMTS layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestException("wmts layer referenced by layer(s)", HttpStatus.FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)resource);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> layerPost(@RequestBody WMTSLayerInfo resource, @PathVariable String workspaceName, @PathVariable(required=false) String storeName, UriComponentsBuilder builder) throws Exception {
        String resourceName = this.handleObjectPost(resource, workspaceName, storeName);
        LOGGER.fine(() -> this.logMessage("POST", workspaceName, storeName, resourceName));
        UriComponents uriComponents = Objects.isNull(storeName) ? builder.path("/workspaces/{workspaceName}/wmtslayers/{wmtslayer}").buildAndExpand(new Object[]{workspaceName, resourceName}) : builder.path("/workspaces/{workspaceName}/wmtsstores/{storeName}/layers/{wmtslayer}").buildAndExpand(new Object[]{workspaceName, storeName, resourceName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        return new ResponseEntity((Object)resourceName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    String logMessage(String message, String workspaceName, @Nullable String storeName, @Nullable String layerName) {
        return message + (Objects.isNull(layerName) ? "" : " WMTS Layer " + layerName + " in") + (Objects.isNull(storeName) ? "" : " store " + storeName + " in") + " in workspace " + workspaceName;
    }

    private String handleObjectPost(WMTSLayerInfo resource, String workspaceName, String storeName) throws Exception {
        WMTSStoreInfo store;
        NamespaceInfo ns = this.getNamespaceInternal(workspaceName);
        if (resource.getStore() != null) {
            if (Objects.nonNull(storeName) && !Objects.equals(storeName, resource.getStore().getName())) {
                throw new RestException("Expected wmts store " + storeName + " but client specified " + resource.getStore().getName(), HttpStatus.FORBIDDEN);
            }
            store = resource.getStore();
        } else {
            store = this.getStoreInternal(ns, storeName);
            resource.setStore((StoreInfo)store);
        }
        if (resource.getNamespace() != null) {
            if (!workspaceName.equals(resource.getNamespace().getPrefix())) {
                throw new RestException("Expected workspace " + workspaceName + " but client specified " + resource.getNamespace().getPrefix(), HttpStatus.FORBIDDEN);
            }
        } else {
            resource.setNamespace(this.catalog.getNamespaceByPrefix(workspaceName));
        }
        resource.setEnabled(true);
        NamespaceInfo foundns = resource.getNamespace();
        if (foundns != null && !foundns.getPrefix().equals(workspaceName)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspaceName + ", overriding.");
            foundns = null;
        }
        if (foundns == null) {
            resource.setNamespace(ns);
        }
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.setStore((StoreInfo)store);
        cb.initWMTSLayer(resource);
        resource.setEnabled(true);
        this.catalog.validate((ResourceInfo)resource, true).throwIfInvalid();
        this.catalog.add((ResourceInfo)resource);
        this.catalog.add(new CatalogBuilder(this.catalog).buildLayer((ResourceInfo)resource));
        return resource.getName();
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WMTSLayerInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<WMTSLayerInfo> getObjectClass() {
                return WMTSLayerInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = (Map)RequestContextHolder.getRequestAttributes().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                String workspaceName = (String)uriTemplateVars.get("workspaceName");
                String storeName = (String)uriTemplateVars.get("storeName");
                String layerName = (String)uriTemplateVars.get("layerName");
                if (workspaceName == null || storeName == null || layerName == null) {
                    return null;
                }
                WMTSStoreInfo store = (WMTSStoreInfo)WMTSLayerController.this.catalog.getStoreByName(workspaceName, storeName, WMTSStoreInfo.class);
                if (store == null) {
                    return null;
                }
                return WMTSLayerController.this.catalog.getResourceByStore((StoreInfo)store, layerName, WMTSLayerInfo.class);
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    converter.encodeLink("/namespaces/" + converter.encode(ns.getPrefix()), writer);
                }
                if (obj instanceof WMTSStoreInfo) {
                    WMTSStoreInfo store = (WMTSStoreInfo)obj;
                    converter.encodeLink("/workspaces/" + converter.encode(store.getWorkspace().getName()) + "/wmtsstores/" + converter.encode(store.getName()), writer);
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<WMTSLayerInfo>(WMTSLayerInfo.class){

            protected void wrapInternal(Map properties, SimpleHash model, WMTSLayerInfo object) {
                try {
                    properties.put("boundingBox", object.boundingBox());
                    properties.put("capabilitiesURL", object.getStore().getCapabilitiesURL());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

