/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.TemplateInfo;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.util.Filter;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/templates", "/rest/workspaces/{workspaceName}/templates", "/rest/workspaces/{workspaceName}/datastores/{storeName}/templates", "/rest/workspaces/{workspaceName}/datastores/{storeName}/featuretypes/{featureTypeName}/templates", "/rest/workspaces/{workspaceName}/coveragestores/{storeName}/templates", "/rest/workspaces/{workspaceName}/coveragestores/{storeName}/coverages/{featureTypeName}/templates"})
public class TemplateController
extends AbstractCatalogController {
    private GeoServerResourceLoader resources;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");

    @Autowired
    public TemplateController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
        this.resources = catalog.getResourceLoader();
    }

    @DeleteMapping(value={"/{templateName}"})
    public void templateDelete(HttpServletResponse response, @PathVariable(required=false) String workspaceName, @PathVariable(required=false) String storeName, @PathVariable(required=false) String featureTypeName, @PathVariable String templateName) {
        String filename = templateName + "." + "ftl";
        String path = Paths.path((String[])new String[]{TemplateController.path(workspaceName, storeName, featureTypeName), filename});
        Resource resource = this.resources.get(path);
        if (resource.getType() != Resource.Type.RESOURCE) {
            throw new ResourceNotFoundException("Template not found: '" + path + "'");
        }
        boolean removed = resource.delete();
        if (!removed) {
            throw new RestException("Template '" + path + "' not removed", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/{templateName}"}, produces={"text/plain"})
    public void templateGet(@PathVariable(required=false) String workspaceName, @PathVariable(required=false) String storeName, @PathVariable(required=false) String featureTypeName, @PathVariable String templateName, HttpServletResponse response) {
        String filename = templateName + "." + "ftl";
        String path = Paths.path((String[])new String[]{TemplateController.path(workspaceName, storeName, featureTypeName), filename});
        Resource resource = this.resources.get(path);
        if (resource.getType() != Resource.Type.RESOURCE) {
            throw new ResourceNotFoundException("Template not found: '" + path + "'");
        }
        try {
            byte[] bytes = resource.getContents();
            response.setContentType("text/plain");
            response.setContentLength(bytes.length);
            try (ServletOutputStream output = response.getOutputStream();){
                output.write(bytes);
                output.flush();
            }
        }
        catch (IOException problem) {
            throw new RestException(problem.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)problem);
        }
    }

    @PutMapping(value={"/{templateName}"}, consumes={"text/plain", "text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void templatePut(@PathVariable(required=false) String workspaceName, @PathVariable(required=false) String storeName, @PathVariable(required=false) String featureTypeName, @PathVariable String templateName, HttpServletRequest request) {
        String filename = templateName + "." + "ftl";
        String path = TemplateController.path(workspaceName, storeName, featureTypeName);
        Resource directory = this.resources.get(path);
        Resource resource = this.fileUpload(directory, filename, request);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("PUT template: " + resource.path());
        }
    }

    @GetMapping(produces={"text/html", "application/json", "application/xml"})
    public RestWrapper<TemplateInfo> templatesGet(@PathVariable(required=false) String workspaceName, @PathVariable(required=false) String storeName, @PathVariable(required=false) String featureTypeName) {
        String path = TemplateController.path(workspaceName, storeName, featureTypeName);
        Resource directory = this.resources.get(path);
        switch (directory.getType()) {
            case RESOURCE: 
            case UNDEFINED: {
                throw new ResourceNotFoundException("Directory not found: '" + path + "'");
            }
        }
        List files = Resources.list((Resource)directory, (Filter)new Resources.ExtensionFilter(new String[]{"FTL"}), (boolean)false);
        ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
        for (Resource file : files) {
            list.add(new TemplateInfo(file));
        }
        return this.wrapList(list, TemplateInfo.class);
    }

    private Resource fileUpload(Resource directory, String filename, HttpServletRequest request) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("PUT file: mimetype=" + request.getContentType() + ", path=" + directory.path());
        }
        try {
            return RESTUtils.handleBinUpload((String)filename, (Resource)directory, (boolean)false, (HttpServletRequest)request);
        }
        catch (IOException problem) {
            throw new RestException(problem.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)problem);
        }
    }

    public static String path(String workspace, String store, String type) {
        ArrayList<String> path = new ArrayList<String>();
        path.add("workspaces");
        if (workspace != null) {
            path.add(workspace);
            if (store != null) {
                path.add(store);
                if (type != null) {
                    path.add(type);
                }
            }
        }
        return Paths.path((String[])path.toArray(new String[0]));
    }
}

