/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/rest/namespaces"}, produces={"application/json", "application/xml", "text/html"})
public class NamespaceController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(NamespaceController.class);

    @Autowired
    public NamespaceController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(value={"/{namespaceName}"}, produces={"application/json", "text/html", "application/xml"})
    public RestWrapper<NamespaceInfo> namespaceGet(@PathVariable String namespaceName) {
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(namespaceName);
        if (namespace == null) {
            throw new ResourceNotFoundException("No such namespace: '" + namespaceName + "' found");
        }
        LOGGER.info("GET " + namespaceName);
        LOGGER.info("got " + namespace.getName());
        return this.wrapObject(namespace, NamespaceInfo.class);
    }

    @GetMapping
    public RestWrapper getNamespaces() {
        List wkspaces = this.catalog.getNamespaces();
        return this.wrapList(wkspaces, NamespaceInfo.class);
    }

    @PostMapping(consumes={"text/xml", "application/xml", "text/json", "application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> namespacePost(@RequestBody NamespaceInfo namespace, UriComponentsBuilder builder) {
        this.catalog.add(namespace);
        String name = namespace.getName();
        LOGGER.info("Added namespace " + name);
        if (this.catalog.getWorkspaceByName(namespace.getPrefix()) == null) {
            WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
            ws.setName(namespace.getPrefix());
            ws.setIsolated(namespace.isIsolated());
            this.catalog.add(ws);
        }
        UriComponents uriComponents = this.getUriComponents(name, builder);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        return new ResponseEntity((Object)name, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/{prefix}"}, consumes={"text/xml", "application/xml", "text/json", "application/json"})
    public void namespacePut(@RequestBody NamespaceInfo namespace, @PathVariable String prefix, UriComponentsBuilder builder) {
        if ("default".equals(prefix)) {
            this.catalog.setDefaultNamespace(namespace);
        } else {
            NamespaceInfo nsi = this.catalog.getNamespaceByPrefix(prefix);
            if (nsi == null) {
                throw new RestException("Can't change a non existant namespace (" + prefix + ")", HttpStatus.NOT_FOUND);
            }
            String infoName = namespace.getName();
            if (infoName != null && !prefix.equals(infoName)) {
                throw new RestException("Can't change name of namespace", HttpStatus.FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateNamespace(nsi, namespace);
            this.catalog.save(nsi);
        }
    }

    @DeleteMapping(path={"/{prefix}"})
    protected void namespaceDelete(@PathVariable String prefix) {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(prefix);
        if (prefix.equals("default")) {
            throw new RestException("Can't delete the default namespace", HttpStatus.METHOD_NOT_ALLOWED);
        }
        if (ns == null) {
            throw new RestException("Namespace '" + prefix + "' not found", HttpStatus.NOT_FOUND);
        }
        if (!this.catalog.getResourcesByNamespace(ns, ResourceInfo.class).isEmpty()) {
            throw new RestException("Namespace not empty", HttpStatus.UNAUTHORIZED);
        }
        this.catalog.remove(ns);
    }

    private UriComponents getUriComponents(String name, UriComponentsBuilder builder) {
        UriComponents uriComponents = builder.path("/namespaces/{id}").buildAndExpand(new Object[]{name});
        return uriComponents;
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<NamespaceInfo>(NamespaceInfo.class){

            protected void wrapInternal(Map properties, SimpleHash model, NamespaceInfo namespace) {
                NamespaceInfo def;
                if (properties == null) {
                    try {
                        properties = model.toMap();
                    }
                    catch (TemplateModelException e) {
                        e.printStackTrace();
                    }
                }
                if ((def = NamespaceController.this.catalog.getDefaultNamespace()).equals((Object)namespace)) {
                    properties.put("isDefault", Boolean.TRUE);
                } else {
                    properties.put("isDefault", Boolean.FALSE);
                }
                ArrayList resources = new ArrayList();
                List res = NamespaceController.this.catalog.getResourcesByNamespace(namespace, ResourceInfo.class);
                for (ResourceInfo r : res) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("name", r.getName());
                    props.put("description", r.getDescription());
                    resources.add(Collections.singletonMap("properties", props));
                }
                properties.put("resources", resources);
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    NamespaceInfo ns = (NamespaceInfo)w;
                    this.wrapInternal((Map)null, model, ns);
                }
            }
        };
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return NamespaceInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<NamespaceInfo> getObjectClass() {
                return NamespaceInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = (Map)RequestContextHolder.getRequestAttributes().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                String prefix = (String)uriTemplateVars.get("namespaceName");
                if (prefix == null) {
                    return null;
                }
                return NamespaceController.this.catalog.getNamespaceByPrefix(prefix);
            }

            protected void postEncodeNamespace(NamespaceInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    converter.encodeLink("/namespaces/" + converter.encode(ref), writer);
                }
            }
        });
    }
}

