/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geoserver.rest.catalog.NamedMap;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class MapXMLConverter
extends BaseMessageConverter<Map<?, ?>> {
    public MapXMLConverter() {
        super(new MediaType[]{MediaType.TEXT_XML, MediaType.APPLICATION_XML});
    }

    protected boolean supports(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) && !Properties.class.isAssignableFrom(clazz);
    }

    public Map<?, ?> readInternal(Class<? extends Map<?, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(this.catalog.getResourcePool().getEntityResolver());
        try {
            doc = builder.build(inputMessage.getBody());
        }
        catch (JDOMException e) {
            throw new IOException("Error building document", e);
        }
        Element elem = doc.getRootElement();
        Object result = this.convert(elem);
        return (Map)result;
    }

    public void writeInternal(Map<?, ?> map, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Element root = new Element(this.getMapName(map));
        Document doc = new Document(root);
        this.insert(root, map);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, outputMessage.getBody());
    }

    protected String getMapName(Map<?, ?> map) {
        if (map instanceof NamedMap) {
            return ((NamedMap)map).getName();
        }
        return "root";
    }

    protected Object convert(Element elem) {
        List children = elem.getChildren();
        if (children.size() == 0) {
            if (elem.getContent().size() == 0) {
                return null;
            }
            return elem.getText();
        }
        if (children.get(0) instanceof Element) {
            Element child = (Element)children.get(0);
            if (child.getName().equals("entry")) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (Object o : elem.getChildren("entry")) {
                    Element curr = (Element)o;
                    l.add(this.convert(curr));
                }
                return l;
            }
            NamedMap m = new NamedMap(child.getName());
            for (Object aChildren : children) {
                Element curr = (Element)aChildren;
                m.put(curr.getName(), this.convert(curr));
            }
            return m;
        }
        throw new RuntimeException("Unable to parse XML");
    }

    protected void insert(Element elem, Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                Element newElem = new Element(entry.getKey().toString());
                this.insert(newElem, entry.getValue());
                elem.addContent((Content)newElem);
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object entry : collection) {
                Element newElem = new Element("entry");
                this.insert(newElem, entry);
                elem.addContent((Content)newElem);
            }
        } else {
            elem.addContent(object == null ? "" : object.toString());
        }
    }
}

