/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import org.geoserver.rest.catalog.FormatCollectionWrapper;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.wfs.GML;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public abstract class FeatureCollectionConverter<T>
extends BaseMessageConverter<T> {
    public FeatureCollectionConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return SimpleFeatureCollection.class.isAssignableFrom(clazz) || FormatCollectionWrapper.JSONCollectionWrapper.class.isAssignableFrom(clazz);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    protected void writeGeoJsonl(SimpleFeatureCollection features, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        FeatureJSON json = new FeatureJSON();
        boolean geometryless = ((SimpleFeatureType)features.getSchema()).getGeometryDescriptor() == null;
        json.setEncodeFeatureCollectionBounds(!geometryless);
        json.setEncodeFeatureCollectionCRS(!geometryless);
        json.writeFeatureCollection((FeatureCollection)features, outputMessage.getBody());
    }

    protected void writeGML(SimpleFeatureCollection features, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        GML gml = new GML(GML.Version.WFS1_0);
        gml.setNamespace("gf", ((SimpleFeatureType)features.getSchema()).getName().getNamespaceURI());
        gml.encode(outputMessage.getBody(), features);
    }
}

