/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogRepository;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractStoreUploadController;
import org.geoserver.rest.util.RESTUploadPathMapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.URLs;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/coveragestores/{storeName}/{method}.{format}"})
public class CoverageStoreFileController
extends AbstractStoreUploadController {
    protected static final HashMap<String, String> FORMAT_LOOKUP = new HashMap();

    @Autowired
    public CoverageStoreFileController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @PostMapping
    @ResponseStatus(code=HttpStatus.ACCEPTED)
    public void coverageStorePost(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable AbstractStoreUploadController.UploadMethod method, @PathVariable String format, @RequestParam(required=false) String filename, HttpServletRequest request) throws IOException {
        StructuredGridCoverage2DReader sr;
        CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        if (info == null) {
            throw new ResourceNotFoundException("No such coverage store: " + workspaceName + "," + storeName);
        }
        GridCoverageReader reader = info.getGridCoverageReader(null, null);
        if (reader instanceof StructuredGridCoverage2DReader) {
            sr = (StructuredGridCoverage2DReader)reader;
            if (sr.isReadOnly()) {
                throw new RestException("Coverage store found, but it cannot harvest extra resources", HttpStatus.METHOD_NOT_ALLOWED);
            }
        } else {
            throw new RestException("Coverage store found, but it does not support resource harvesting", HttpStatus.METHOD_NOT_ALLOWED);
        }
        sr = (StructuredGridCoverage2DReader)reader;
        ArrayList<File> uploadedFiles = new ArrayList<File>();
        for (Resource res : this.doFileUpload(method, workspaceName, storeName, filename, format, request)) {
            uploadedFiles.add(Resources.find((Resource)res));
        }
        sr.harvest(null, uploadedFiles, GeoTools.getDefaultHints());
    }

    @PutMapping(produces={"application/xml", "application/json"})
    @ResponseStatus(code=HttpStatus.CREATED)
    public RestWrapper<CoverageStoreInfo> coverageStorePut(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable AbstractStoreUploadController.UploadMethod method, @PathVariable String format, @RequestParam(name="configure", required=false) String configure, @RequestParam(name="USE_JAI_IMAGEREAD", required=false) Boolean useJaiImageRead, @RequestParam(name="coverageName", required=false) String coverageName, @RequestParam(required=false) String filename, HttpServletRequest request) throws IOException {
        Format coverageFormat = this.getCoverageFormat(format);
        List<Resource> files = this.doFileUpload(method, workspaceName, storeName, filename, format, request);
        Resource uploadedFile = files.get(0);
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        builder.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
        CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        boolean add = false;
        if (info == null) {
            LOGGER.info("Auto-configuring coverage store: " + storeName);
            info = builder.buildCoverageStore(storeName);
            add = true;
        } else {
            LOGGER.info("Using existing coverage store: " + storeName);
        }
        info.setType(coverageFormat.getName());
        URL uploadedFileURL = URLs.fileToUrl((File)Resources.find((Resource)uploadedFile));
        if (method.isInline()) {
            String url;
            int def;
            StringBuilder urlBuilder;
            String defaultRoot = "/data/" + workspaceName + "/" + storeName;
            try {
                urlBuilder = new StringBuilder(Resources.find((Resource)uploadedFile).toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                throw new RestException("Error create building coverage URL", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
            if (uploadedFile.getType() == Resource.Type.DIRECTORY && uploadedFile.name().equals(storeName)) {
                def = urlBuilder.indexOf(defaultRoot);
                url = def >= 0 ? "file:data/" + workspaceName + "/" + storeName : urlBuilder.toString();
            } else {
                def = urlBuilder.indexOf(defaultRoot);
                if (def >= 0) {
                    String itemPath = urlBuilder.substring(def + defaultRoot.length());
                    url = "file:data/" + workspaceName + "/" + storeName + itemPath;
                } else {
                    url = urlBuilder.toString();
                }
            }
            if (url.contains("+")) {
                url = url.replace("+", "%2B");
            }
            if (url.contains(" ")) {
                url = url.replace(" ", "%20");
            }
            info.setURL(url);
        } else {
            info.setURL(uploadedFileURL.toExternalForm());
        }
        if (add) {
            if (!this.catalog.validate((StoreInfo)info, true).isValid()) {
                throw new RuntimeException("Validation failed");
            }
            this.catalog.add((StoreInfo)info);
        } else {
            if (!this.catalog.validate((StoreInfo)info, false).isValid()) {
                throw new RuntimeException("Validation failed");
            }
            this.catalog.save((StoreInfo)info);
        }
        builder.setStore((StoreInfo)info);
        if ("none".equalsIgnoreCase(configure)) {
            return null;
        }
        AbstractGridCoverage2DReader reader = null;
        try {
            RestWrapper names;
            CatalogRepository repository = this.catalog.getResourcePool().getRepository();
            Hints hints = new Hints(new RenderingHints((RenderingHints.Key)Hints.REPOSITORY, repository));
            reader = ((AbstractGridFormat)coverageFormat).getReader((Object)uploadedFileURL, hints);
            if (reader == null) {
                throw new RestException("Could not acquire reader for coverage.", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            HashMap<String, Boolean> customParameters = new HashMap<String, Boolean>();
            if (useJaiImageRead != null) {
                customParameters.put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().toString(), useJaiImageRead);
            }
            if (((String[])(names = reader.getGridCoverageNames())).length > 1 && coverageName != null) {
                throw new RestException("The reader found more than one coverage, coverageName cannot be used in this case (it would generate the same name for all coverages found", HttpStatus.BAD_REQUEST);
            }
            if (((String[])names).length > 1) {
                for (String name : names) {
                    SingleGridCoverage2DReader singleReader = new SingleGridCoverage2DReader((GridCoverage2DReader)reader, name);
                    this.configureCoverageInfo(builder, info, add, name, name, (GridCoverage2DReader)singleReader, customParameters);
                }
            } else {
                this.configureCoverageInfo(builder, info, add, names[0], coverageName, (GridCoverage2DReader)reader, customParameters);
            }
            RestWrapper restWrapper = this.wrapObject(info, CoverageStoreInfo.class);
            return restWrapper;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException("Error auto-configuring coverage", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Format getCoverageFormat(String format) {
        String coverageFormatName = FORMAT_LOOKUP.get(format);
        if (coverageFormatName == null) {
            throw new RestException("Unsupported format: " + format + ", available formats are: " + FORMAT_LOOKUP.keySet().toString(), HttpStatus.BAD_REQUEST);
        }
        try {
            return CoverageStoreUtils.acquireFormat((String)coverageFormatName);
        }
        catch (Exception e) {
            throw new RestException("Coveragestore format unavailable: " + coverageFormatName, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void configureCoverageInfo(CatalogBuilder builder, CoverageStoreInfo storeInfo, boolean add, String nativeName, String coverageName, GridCoverage2DReader reader, Map customParameters) throws Exception {
        CoverageInfo cinfo = builder.buildCoverage(reader, customParameters);
        if (coverageName != null) {
            cinfo.setName(coverageName);
        }
        if (nativeName != null) {
            cinfo.setNativeCoverageName(nativeName);
        }
        if (!add) {
            String name = coverageName != null ? coverageName : nativeName;
            CoverageInfo existing = this.catalog.getCoverageByCoverageStore(storeInfo, name);
            if (existing == null) {
                List coverages = this.catalog.getCoveragesByCoverageStore(storeInfo);
                if (coverages.size() == 1 && ((CoverageInfo)coverages.get(0)).getNativeName() == null) {
                    existing = (CoverageInfo)coverages.get(0);
                }
                if (coverages.size() == 0) {
                    add = true;
                } else {
                    for (CoverageInfo ci : coverages) {
                        if (!ci.getNativeName().equals(name)) continue;
                        existing = ci;
                    }
                    if (existing == null) {
                        add = true;
                    }
                }
            }
            if (existing != null) {
                builder.updateCoverage(existing, cinfo);
                this.catalog.validate((ResourceInfo)existing, false).throwIfInvalid();
                this.catalog.save((ResourceInfo)existing);
                cinfo = existing;
            }
        }
        if ("UNKNOWN".equals(cinfo.getSRS())) {
            cinfo.setSRS("EPSG:4326");
        }
        if (add) {
            this.catalog.validate((ResourceInfo)cinfo, true).throwIfInvalid();
            this.catalog.add((ResourceInfo)cinfo);
            LayerInfo layerInfo = builder.buildLayer(cinfo);
            boolean valid = true;
            try {
                if (!this.catalog.validate(layerInfo, true).isValid()) {
                    valid = false;
                }
            }
            catch (Exception e) {
                valid = false;
            }
            layerInfo.setEnabled(valid);
            this.catalog.add(layerInfo);
        } else {
            this.catalog.save((ResourceInfo)cinfo);
        }
    }

    @Override
    protected Resource findPrimaryFile(Resource directory, String format) {
        AbstractGridFormat coverageFormat = (AbstractGridFormat)this.getCoverageFormat(format);
        if (coverageFormat.accepts((Object)directory.dir())) {
            return directory;
        }
        for (Resource f : directory.list()) {
            if (f.getType() == Resource.Type.DIRECTORY) {
                Resource result = this.findPrimaryFile(f, format);
                if (result == null) continue;
                return result;
            }
            if (!coverageFormat.accepts((Object)f.file())) continue;
            return f;
        }
        return null;
    }

    protected List<Resource> doFileUpload(AbstractStoreUploadController.UploadMethod method, String workspaceName, String storeName, String filename, String format, HttpServletRequest request) throws IOException {
        boolean postRequest;
        Resource directory = null;
        boolean bl = postRequest = request != null && HttpMethod.POST.name().equalsIgnoreCase(request.getMethod());
        if (method.isInline()) {
            directory = method == AbstractStoreUploadController.UploadMethod.url ? this.createFinalRoot(null, null, postRequest) : this.createFinalRoot(workspaceName, storeName, postRequest);
        }
        return this.handleFileUpload(storeName, workspaceName, filename, method, format, directory, request);
    }

    private Resource createFinalRoot(String workspaceName, String storeName, boolean isPost) throws IOException {
        CoverageStoreInfo coverage;
        Resource directory = null;
        if (isPost && storeName != null && (coverage = this.catalog.getCoverageStoreByName(storeName)) != null && (workspaceName == null || coverage.getWorkspace().getName().equalsIgnoreCase(workspaceName))) {
            directory = Resources.fromPath((String)URLs.urlToFile((URL)new URL(coverage.getURL())).getPath(), (Resource)this.catalog.getResourceLoader().get(""));
        }
        if (directory == null) {
            directory = this.catalog.getResourceLoader().get(Paths.path((String[])new String[]{"data", workspaceName, storeName}));
        }
        StringBuilder root = new StringBuilder(directory.path());
        HashMap storeParams = new HashMap();
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapStorePath(root, workspaceName, storeName, storeParams);
        }
        directory = Resources.fromPath((String)root.toString());
        return directory;
    }

    static {
        for (Format format : CoverageStoreUtils.formats) {
            FORMAT_LOOKUP.put(format.getName().toLowerCase(), format.getName());
        }
    }
}

