/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/coveragestores"})
public class CoverageStoreController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(CoverageStoreController.class);

    @Autowired
    public CoverageStoreController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<CoverageStoreInfo> coverageStoresGet(@PathVariable String workspaceName) {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspaceName);
        if (ws == null) {
            throw new ResourceNotFoundException("No such workspace : " + workspaceName);
        }
        List coverageStores = this.catalog.getCoverageStoresByWorkspace(ws);
        return this.wrapList(coverageStores, CoverageStoreInfo.class);
    }

    @GetMapping(path={"{storeName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<CoverageStoreInfo> coverageStoreGet(@PathVariable String workspaceName, @PathVariable String storeName) {
        CoverageStoreInfo coverageStore = this.getExistingCoverageStore(workspaceName, storeName);
        return this.wrapObject(coverageStore, CoverageStoreInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> coverageStorePost(@RequestBody CoverageStoreInfo coverageStore, @PathVariable String workspaceName, UriComponentsBuilder builder) {
        this.catalog.validate((StoreInfo)coverageStore, true).throwIfInvalid();
        this.catalog.add((StoreInfo)coverageStore);
        String storeName = coverageStore.getName();
        LOGGER.info("POST coverage store " + storeName);
        UriComponents uriComponents = builder.path("/workspaces/{workspaceName}/coveragestores/{storeName}").buildAndExpand(new Object[]{workspaceName, storeName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        return new ResponseEntity((Object)storeName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"{storeName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void coverageStorePut(@RequestBody CoverageStoreInfo info, @PathVariable String workspaceName, @PathVariable String storeName) {
        CoverageStoreInfo original = this.getExistingCoverageStore(workspaceName, storeName);
        new CatalogBuilder(this.catalog).updateCoverageStore(original, info);
        this.catalog.validate((StoreInfo)original, false).throwIfInvalid();
        this.catalog.save((StoreInfo)original);
        this.clear(original);
        LOGGER.info("PUT coverage store " + workspaceName + "," + storeName);
    }

    private CoverageStoreInfo getExistingCoverageStore(String workspaceName, String storeName) {
        CoverageStoreInfo original = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        if (original == null) {
            throw new ResourceNotFoundException("No such coverage store: " + workspaceName + "," + storeName);
        }
        return original;
    }

    @DeleteMapping(value={"{storeName}"})
    public void coverageStoreDelete(@PathVariable String workspaceName, @PathVariable String storeName, @RequestParam(name="recurse", required=false, defaultValue="false") boolean recurse, @RequestParam(name="purge", required=false, defaultValue="none") String deleteType) throws IOException {
        CoverageStoreInfo cs = this.getExistingCoverageStore(workspaceName, storeName);
        if (!recurse) {
            if (!this.catalog.getCoveragesByCoverageStore(cs).isEmpty()) {
                throw new RestException("coveragestore not empty", HttpStatus.UNAUTHORIZED);
            }
            this.catalog.remove((StoreInfo)cs);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(cs);
        }
        this.delete(deleteType, cs);
        this.clear(cs);
        LOGGER.info("DELETE coverage store " + workspaceName + ":s" + workspaceName);
    }

    private void delete(String deleteType, CoverageStoreInfo cs) throws IOException {
        if (!deleteType.equalsIgnoreCase("none") && (deleteType.equalsIgnoreCase("all") || deleteType.equalsIgnoreCase("metadata"))) {
            boolean deleteData = deleteType.equalsIgnoreCase("all");
            GridCoverageReader reader = cs.getGridCoverageReader(null, null);
            if (reader instanceof StructuredGridCoverage2DReader) {
                ((StructuredGridCoverage2DReader)reader).delete(deleteData);
            }
        }
    }

    void clear(CoverageStoreInfo info) {
        this.catalog.getResourcePool().clear(info);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return CoverageStoreInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<CoverageStoreInfo> getObjectClass() {
                return CoverageStoreInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = (Map)RequestContextHolder.getRequestAttributes().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String coveragestore = (String)uriTemplateVars.get("storeName");
                if (workspace == null || coveragestore == null) {
                    return null;
                }
                return CoverageStoreController.this.catalog.getCoverageStoreByName(workspace, coveragestore);
            }

            protected void postEncodeCoverageStore(CoverageStoreInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("coverages");
                converter.encodeCollectionLink("coverages", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    converter.encodeLink("/workspaces/" + converter.encode(ref), writer);
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<CoverageStoreInfo>(CoverageStoreInfo.class){

            protected void wrapInternal(Map properties, SimpleHash model, CoverageStoreInfo dataStoreInfo) {
                if (properties == null) {
                    try {
                        properties = model.toMap();
                    }
                    catch (TemplateModelException e) {
                        e.printStackTrace();
                    }
                }
                ArrayList csProps = new ArrayList();
                List coverages = CoverageStoreController.this.catalog.getCoveragesByCoverageStore(dataStoreInfo);
                for (CoverageInfo coverage : coverages) {
                    HashMap<String, String> names = new HashMap<String, String>();
                    names.put("name", coverage.getName());
                    csProps.add(Collections.singletonMap("properties", names));
                }
                if (!csProps.isEmpty()) {
                    properties.putIfAbsent("coverages", csProps);
                }
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    CoverageStoreInfo wk = (CoverageStoreInfo)w;
                    this.wrapInternal((Map)null, model, wk);
                }
            }
        };
    }
}

