/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.XStream;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.platform.ModuleStatusImpl;
import org.geoserver.platform.RenderingEngineStatus;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/about/status"}, produces={"text/html", "application/json", "application/xml"})
public class AboutStatusController
extends RestBaseController {
    @GetMapping
    protected RestWrapper<ModuleStatus> statusGet() throws Exception {
        List applicationStatus = GeoServerExtensions.extensions(ModuleStatus.class).stream().map(ModuleStatusImpl::new).collect(Collectors.toList());
        return this.wrapList(applicationStatus, ModuleStatus.class);
    }

    @GetMapping(value={"/{target}"})
    protected RestWrapper<ModuleStatus> statusGet(@PathVariable String target) throws Exception {
        List applicationStatus = GeoServerExtensions.extensions(ModuleStatus.class).stream().map(ModuleStatusImpl::new).filter(AboutStatusController.getModule(target)).collect(Collectors.toList());
        if (applicationStatus.isEmpty()) {
            throw new RestException("No such module: " + target, HttpStatus.NOT_FOUND);
        }
        return this.wrapList(applicationStatus, ModuleStatus.class);
    }

    protected static Predicate<ModuleStatus> getModule(String target) {
        return m -> m.getModule().equalsIgnoreCase(target);
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xs = persister.getXStream();
        xs.processAnnotations(ModuleStatus.class);
        xs.allowTypes(new Class[]{ModuleStatus.class});
        xs.alias("about", List.class);
        xs.alias("status", ModuleStatus.class);
        xs.addDefaultImplementation(ModuleStatusImpl.class, ModuleStatus.class);
        xs.addDefaultImplementation(RenderingEngineStatus.class, ModuleStatus.class);
    }

    protected String getTemplateName(Object object) {
        return "ModuleStatusImpl";
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return ModuleStatus.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new BeansWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                if (obj instanceof List) {
                    List list = (List)obj;
                    SimpleHash hash = new SimpleHash();
                    hash.put("values", (Object)new CollectionModel((Collection)list, new BeansWrapper(){

                        public TemplateModel wrap(Object object) throws TemplateModelException {
                            if (object instanceof ModuleStatus) {
                                ModuleStatus status = (ModuleStatus)object;
                                SimpleHash hash = new SimpleHash();
                                hash.put("module", (Object)status.getModule());
                                hash.put("name", (Object)status.getName());
                                hash.put("isAvailable", (Object)Boolean.toString(status.isAvailable()));
                                hash.put("isEnabled", (Object)Boolean.toString(status.isEnabled()));
                                status.getComponent().ifPresent(component -> hash.put("component", component));
                                status.getVersion().ifPresent(version -> hash.put("version", version));
                                status.getMessage().ifPresent(message -> {
                                    String noControlChars = message.replaceAll("\u001b", "ESC").replaceAll("\b", "BACK").replaceAll("\u0007", "BELL");
                                    String escaped = StringEscapeUtils.escapeXml((String)noControlChars).replaceAll("\n", "<br/>");
                                    hash.put("message", (Object)escaped);
                                });
                                return hash;
                            }
                            return super.wrap(object);
                        }
                    }));
                    return hash;
                }
                return super.wrap(obj);
            }
        };
    }
}

