/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.ManifestLoader;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/about"}, produces={"text/html", "application/json", "application/xml"})
@ControllerAdvice
public class AboutController
extends RestBaseController {
    @GetMapping(value={"/manifest"})
    public RestWrapper<ManifestLoader.AboutModel> manifestGet(@RequestParam(name="manifest", required=false) String regex, @RequestParam(required=false) String from, @RequestParam(required=false) String to, @RequestParam(required=false) String key, @RequestParam(required=false) String value) {
        return this.wrapObject(this.getModel(ManifestLoader.AboutModel.AboutModelType.RESOURCES, regex, from, to, key, value), ManifestLoader.AboutModel.class);
    }

    @GetMapping(value={"/version"})
    public RestWrapper<ManifestLoader.AboutModel> versionGet(@RequestParam(name="manifest", required=false) String regex, @RequestParam(required=false) String from, @RequestParam(required=false) String to, @RequestParam(required=false) String key, @RequestParam(required=false) String value) {
        return this.wrapObject(this.getModel(ManifestLoader.AboutModel.AboutModelType.VERSIONS, regex, from, to, key, value), ManifestLoader.AboutModel.class);
    }

    protected ManifestLoader.AboutModel getModel(ManifestLoader.AboutModel.AboutModelType type, String regex, String from, String to, String key, String value) {
        ManifestLoader.AboutModel model = null;
        if (regex != null) {
            model = AboutController.buildAboutModel(type).filterNameByRegex(regex);
        }
        if (from != null && to != null) {
            model = model != null ? model.filterNameByRange(from, to) : AboutController.buildAboutModel(type).filterNameByRange(from, to);
        }
        if (model == null) {
            model = AboutController.buildAboutModel(type);
        }
        if (key != null && value != null) {
            model = model.filterPropertyByKeyValue(value, key);
        } else if (key != null) {
            model = model.filterPropertyByKey(key);
        } else if (value != null) {
            model = model.filterPropertyByValue(value);
        }
        if (model != null) {
            return model;
        }
        return AboutController.buildAboutModel(type);
    }

    private static ManifestLoader.AboutModel buildAboutModel(ManifestLoader.AboutModel.AboutModelType type) {
        if (type.equals((Object)ManifestLoader.AboutModel.AboutModelType.RESOURCES)) {
            return ManifestLoader.getResources();
        }
        return ManifestLoader.getVersions();
    }

    protected String getTemplateName(Object object) {
        if (object instanceof ManifestLoader.AboutModel) {
            return "AboutModel.ftl";
        }
        return null;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return ManifestLoader.AboutModel.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        if (ManifestLoader.AboutModel.class.isAssignableFrom(clazz)) {
            return new ObjectToMapWrapper<ManifestLoader.AboutModel>(ManifestLoader.AboutModel.class){

                protected void wrapInternal(Map properties, SimpleHash model, ManifestLoader.AboutModel object) {
                    ArrayList manifests = new ArrayList();
                    for (ManifestLoader.AboutModel.ManifestModel manifest : object.getManifests()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("name", manifest.getName());
                        ArrayList<String> props = new ArrayList<String>();
                        map.put("properties", props);
                        ArrayList values = new ArrayList();
                        map.put("valuez", values);
                        for (String key : manifest.getEntries().keySet()) {
                            props.add(key);
                            values.add(manifest.getEntries().get(key));
                        }
                        manifests.add(map);
                    }
                    properties.put("manifests", manifests);
                }
            };
        }
        return null;
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xs = persister.getXStream();
        xs.processAnnotations(ManifestLoader.AboutModel.class);
        xs.allowTypes(new Class[]{ManifestLoader.AboutModel.class});
        xs.addImplicitCollection(ManifestLoader.AboutModel.class, "manifests");
        xs.alias("about", ManifestLoader.AboutModel.class);
        xs.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return type.equals(ManifestLoader.AboutModel.ManifestModel.class);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                ManifestLoader.AboutModel.ManifestModel model = (ManifestLoader.AboutModel.ManifestModel)source;
                writer.addAttribute("name", model.getName());
                for (Map.Entry entry : model.getEntries().entrySet()) {
                    context.convertAnother(entry, new Converter(){

                        public boolean canConvert(Class type) {
                            return Map.Entry.class.isAssignableFrom(type);
                        }

                        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                            Map.Entry e = (Map.Entry)source;
                            writer.startNode((String)e.getKey());
                            writer.setValue((String)e.getValue());
                            writer.endNode();
                        }

                        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                    });
                }
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new UnsupportedOperationException("Not implemented");
            }
        });
        xs.alias("resource", ManifestLoader.AboutModel.ManifestModel.class);
        xs.addImplicitCollection(ManifestLoader.AboutModel.ManifestModel.class, "entries");
        xs.useAttributeFor(ManifestLoader.AboutModel.ManifestModel.class, "name");
        xs.alias("property", Map.Entry.class);
        xs.autodetectAnnotations(true);
    }
}

