/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;

public class PutIgnoringExtensionContentNegotiationStrategy
implements ContentNegotiationStrategy {
    PatternsRequestCondition pathMatcher;
    List<MediaType> mediaTypes;

    public PutIgnoringExtensionContentNegotiationStrategy(PatternsRequestCondition pathMatcher, List<MediaType> mediaTypes) {
        this.pathMatcher = pathMatcher;
        this.mediaTypes = mediaTypes;
    }

    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (this.pathMatcher.getMatchingCondition(request) != null && ("PUT".equals(request.getMethod()) || "POST".equals(request.getMethod()))) {
            return this.mediaTypes;
        }
        return new ArrayList<MediaType>();
    }
}

