/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import org.geoserver.rest.security.SecurityRESTTestSupport;
import org.geoserver.rest.security.xml.JaxbUser;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.xml.XMLUserGroupService;
import org.junit.Assert;
import org.junit.Test;

public class XStreamParserTest
extends SecurityRESTTestSupport {
    private final String restSecurityUserGroupUsersUrl = "/rest/security/usergroup/users";
    private final String xmlBody = "<user><userName>Jim</userName><password>password</password><enabled>true</enabled></user>";
    private final String jsonBody = "{\"user\":{\"userName\":\"mr_json\",\"password\":\"pass_me_a_json\",\"enabled\":true}}";

    @Test
    public void jsonReadWriteTest() throws Exception, IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xstream.setMode(1001);
        xstream.alias("user", JaxbUser.class);
        JaxbUser user = new JaxbUser();
        user.setUserName("test");
        user.setPassword("pass");
        user.setEnabled(Boolean.valueOf(true));
        String jsonString = xstream.toXML((Object)user);
        Assert.assertNotNull((Object)jsonString);
        JaxbUser parseUser = (JaxbUser)xstream.fromXML("{\"user\":{\"userName\":\"mr_json\",\"password\":\"pass_me_a_json\",\"enabled\":true}}");
        Assert.assertNotNull((Object)parseUser);
    }

    @Test
    public void postUserXMLTest() throws Exception, IOException {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        Assert.assertEquals((long)201L, (long)this.postAsServletResponse("/rest/security/usergroup/users", "<user><userName>Jim</userName><password>password</password><enabled>true</enabled></user>", "application/xml").getStatus());
        GeoServerUser user = service.getUserByUsername("Jim");
        Assert.assertNotNull((Object)user);
        this.logout();
    }

    @Test
    public void postUserJSONTest() throws Exception, IOException {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        Assert.assertEquals((long)201L, (long)this.postAsServletResponse("/rest/security/usergroup/users", "{\"user\":{\"userName\":\"mr_json\",\"password\":\"pass_me_a_json\",\"enabled\":true}}", "application/json").getStatus());
        GeoServerUser user = service.getUserByUsername("mr_json");
        Assert.assertNotNull((Object)user);
        this.logout();
    }
}

