/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import org.geoserver.rest.security.RolesRestController;
import org.geoserver.rest.security.UsersRestController;
import org.geoserver.rest.security.xml.JaxbGroupList;
import org.geoserver.rest.security.xml.JaxbRoleList;
import org.geoserver.rest.security.xml.JaxbUser;
import org.geoserver.rest.security.xml.JaxbUserList;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.test.GeoServerTestSupport;
import org.junit.Before;
import org.junit.Test;

public class UserRoleRestControllerTest
extends GeoServerTestSupport {
    private static final String USER_SERVICE = "default";
    protected UsersRestController usersController;
    protected RolesRestController rolesController;

    @Before
    public void oneTimeSetUp() throws Exception {
        this.setValidating(true);
        super.oneTimeSetUp();
        this.usersController = (UsersRestController)applicationContext.getBean(UsersRestController.class);
        this.rolesController = (RolesRestController)applicationContext.getBean(RolesRestController.class);
    }

    @Test
    public void test() throws PasswordPolicyException, IOException {
        JaxbUser user = new JaxbUser();
        user.setUserName("pipo");
        user.setPassword("secret");
        user.setEnabled(Boolean.valueOf(true));
        this.usersController.insertUser(USER_SERVICE, user);
        this.usersController.insertGroup(USER_SERVICE, "clowns");
        this.usersController.insertGroup(USER_SERVICE, "circus");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "clowns");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "circus");
        JaxbUserList users = this.usersController.getUsers(USER_SERVICE);
        boolean found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            UserRoleRestControllerTest.assertTrue((boolean)u.isEnabled());
            found = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)found);
        users = this.usersController.getUsersFromGroup(USER_SERVICE, "clowns");
        found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            UserRoleRestControllerTest.assertTrue((boolean)u.isEnabled());
            found = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)found);
        JaxbGroupList groups = this.usersController.getGroupsFromUser(USER_SERVICE, "pipo");
        UserRoleRestControllerTest.assertEquals((int)2, (int)groups.getGroups().size());
        UserRoleRestControllerTest.assertTrue((boolean)groups.getGroups().contains("clowns"));
        UserRoleRestControllerTest.assertTrue((boolean)groups.getGroups().contains("circus"));
        this.usersController.disassociateUserFromGroup(USER_SERVICE, "pipo", "circus");
        groups = this.usersController.getGroupsFromUser(USER_SERVICE, "pipo");
        UserRoleRestControllerTest.assertEquals((int)1, (int)groups.getGroups().size());
        UserRoleRestControllerTest.assertTrue((boolean)groups.getGroups().contains("clowns"));
        UserRoleRestControllerTest.assertFalse((boolean)groups.getGroups().contains("circus"));
        this.usersController.deleteGroup(USER_SERVICE, "circus");
        UserRoleRestControllerTest.assertEquals((int)1, (int)groups.getGroups().size());
        UserRoleRestControllerTest.assertTrue((boolean)groups.getGroups().contains("clowns"));
        UserRoleRestControllerTest.assertFalse((boolean)groups.getGroups().contains("circus"));
        user = new JaxbUser();
        user.setEnabled(Boolean.valueOf(false));
        this.usersController.updateUser(USER_SERVICE, "pipo", user);
        users = this.usersController.getUsers(USER_SERVICE);
        found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            UserRoleRestControllerTest.assertFalse((boolean)u.isEnabled());
            found = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)found);
        this.rolesController.insert("vozen");
        this.rolesController.insert("kwiestenbiebel");
        users = this.usersController.getUsers(USER_SERVICE);
        JaxbRoleList roles = this.rolesController.get();
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("vozen"));
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.associate("vozen", "pipo");
        this.rolesController.associate("kwiestenbiebel", "pipo");
        roles = this.rolesController.getUser("pipo");
        UserRoleRestControllerTest.assertEquals((int)2, (int)roles.getRoles().size());
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("vozen"));
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.disassociate("kwiestenbiebel", "pipo");
        roles = this.rolesController.getUser("pipo");
        UserRoleRestControllerTest.assertEquals((int)1, (int)roles.getRoles().size());
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("vozen"));
        UserRoleRestControllerTest.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.delete("kwiestenbiebel");
        UserRoleRestControllerTest.assertEquals((int)1, (int)roles.getRoles().size());
        UserRoleRestControllerTest.assertTrue((boolean)roles.getRoles().contains("vozen"));
        UserRoleRestControllerTest.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.usersController.deleteUser(USER_SERVICE, "pipo");
        users = this.usersController.getUsers(USER_SERVICE);
        found = false;
        for (JaxbUser u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            found = true;
        }
        UserRoleRestControllerTest.assertFalse((boolean)found);
        boolean notfound = false;
        try {
            this.usersController.getUsers("blabla");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.usersController.getGroupsFromUser(USER_SERVICE, "niemand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.usersController.getUsersFromGroup(USER_SERVICE, "onbestaand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.rolesController.delete("onbestaand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        UserRoleRestControllerTest.assertTrue((boolean)notfound);
    }
}

