/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.test.JSONAssert;
import org.apache.commons.lang3.SystemUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ResourceControllerTest
extends GeoServerSystemTestSupport {
    private final String STR_MY_TEST;
    private final String STR_MY_NEW_TEST;
    private final NamespaceContext NS_XML;
    private final NamespaceContext NS_HTML;
    private final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
    private final DateFormat FORMAT_HEADER = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private Resource myRes;

    public ResourceControllerTest() {
        CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
        this.STR_MY_TEST = encoder.canEncode("\u00e9\u00f6") ? "This is my test. \u00e9 \u00f6" : "This is my test.";
        this.STR_MY_NEW_TEST = encoder.canEncode("\u20ac\u00e8") ? "This is my new test. \u20ac \u00e8" : "This is my new test.";
        this.FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.FORMAT_HEADER.setTimeZone(TimeZone.getTimeZone("GMT"));
        HashMap<String, String> mapXML = new HashMap<String, String>();
        mapXML.put("atom", "http://www.w3.org/2005/Atom");
        this.NS_XML = new SimpleNamespaceContext(mapXML);
        HashMap<String, String> mapHTML = new HashMap<String, String>();
        mapHTML.put("x", "http://www.w3.org/1999/xhtml");
        this.NS_HTML = new SimpleNamespaceContext(mapHTML);
    }

    @Before
    public void initialise() throws IOException {
        this.myRes = this.getDataDirectory().get("/mydir/myres");
        try (OutputStreamWriter os = new OutputStreamWriter(this.myRes.out());){
            os.append(this.STR_MY_TEST);
        }
        os = new OutputStreamWriter(this.getDataDirectory().get("/mydir2/myres.xml").out());
        var2_2 = null;
        try {
            os.append(this.STR_MY_TEST);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var2_2 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        os = new OutputStreamWriter(this.getDataDirectory().get("/mydir2/myres.json").out());
        var2_2 = null;
        try {
            os.append(this.STR_MY_TEST);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var2_2 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        os = new OutputStreamWriter(this.getDataDirectory().get("/mydir2/fake.png").out());
        var2_2 = null;
        try {
            os.append("This is not a real png file.");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var2_2 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        os = new OutputStreamWriter(this.getDataDirectory().get("/po\u00ebzie/caf\u00e9").out());
        var2_2 = null;
        try {
            os.append("The content of this file is irrelevant.");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var2_2 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        IOUtils.copyStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("testimage.png"), (OutputStream)this.getDataDirectory().get("/mydir2/imagewithoutextension").out(), (boolean)true, (boolean)true);
    }

    @Test
    public void testResource() throws Exception {
        String str = this.getAsString("/rest/resource/mydir/myres").trim();
        Assert.assertEquals((Object)this.STR_MY_TEST, (Object)str);
    }

    @Test
    public void testResourceMetadataXML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        Document doc = this.getAsDOM("/rest/resource/mydir/myres?operation=mEtAdATa&format=xml");
        XMLAssert.assertXpathEvaluatesTo((String)"myres", (String)"/ResourceMetadata/name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"/mydir", (String)"/ResourceMetadata/parent/path", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/mydir", (String)"/ResourceMetadata/parent/atom:link/@href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)this.FORMAT.format(this.myRes.lastmodified()), (String)"/ResourceMetadata/lastModified", (Document)doc);
    }

    @Test
    public void testResourceMetadataJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/resource/mydir/myres?operation=metadata&format=json");
        String expected = "{\"ResourceMetadata\": {  \"name\": \"myres\",  \"parent\":   {    \"path\": \"/mydir\",    \"link\": {       \"href\": \"http://localhost:8080/geoserver/rest/resource/mydir\",       \"rel\": \"alternate\",                       \"type\": \"application/json\"     }   },  \"lastModified\": \"" + this.FORMAT.format(this.myRes.lastmodified()) + "\",  \"type\": \"resource\"}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)((JSONObject)json));
    }

    @Test
    public void testResourceMetadataWithResourceExtension() throws Exception {
        String str = this.getAsString("/rest/resource/mydir2/myres.xml").trim();
        Assert.assertEquals((Object)this.STR_MY_TEST, (Object)str);
        str = this.getAsString("/rest/resource/mydir2/myres.json").trim();
        Assert.assertEquals((Object)this.STR_MY_TEST, (Object)str);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        str = this.getAsString("/rest/resource/mydir2/myres.xml?operation=mEtAdATa&format=xml");
        Assert.assertTrue((boolean)str.startsWith("<ResourceMetadata"));
        str = this.getAsString("/rest/resource/mydir2/myres.json?operation=mEtAdATa&format=xml");
        Assert.assertTrue((boolean)str.startsWith("<ResourceMetadata"));
        str = this.getAsString("/rest/resource/mydir2/myres.xml?operation=metadata&format=json");
        Assert.assertTrue((boolean)str.startsWith("{\"ResourceMetadata\""));
        str = this.getAsString("/rest/resource/mydir2/myres.json?operation=metadata&format=json");
        Assert.assertTrue((boolean)str.startsWith("{\"ResourceMetadata\""));
    }

    @Test
    public void testResourceMetadataHTML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_HTML);
        Document doc = this.getAsDOM("/rest/resource/mydir/myres?operation=metadata&format=html");
        XMLAssert.assertXpathEvaluatesTo((String)"Name: 'myres'", (String)"/x:html/x:body/x:ul/x:li[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/mydir", (String)"/x:html/x:body/x:ul/x:li[2]/x:a/@href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Type: resource", (String)"/x:html/x:body/x:ul/x:li[3]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)("Last modified: " + new Date(this.myRes.lastmodified()).toString()), (String)"/x:html/x:body/x:ul/x:li[4]", (Document)doc);
    }

    @Test
    public void testResourceHeaders() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/resource/mydir2/fake.png");
        Assert.assertEquals((Object)this.FORMAT_HEADER.format(this.getDataDirectory().get("/mydir2/fake.png").lastmodified()), (Object)response.getHeader("Last-Modified"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/resource/mydir2", (Object)response.getHeader("Resource-Parent"));
        Assert.assertEquals((Object)"resource", (Object)response.getHeader("Resource-Type"));
        ResourceControllerTest.assertContentType((String)"image/png", (MockHttpServletResponse)response);
    }

    @Test
    public void testResourceHead() throws Exception {
        MockHttpServletResponse response = this.headAsServletResponse("/rest/resource/mydir2/fake.png");
        Assert.assertEquals((Object)this.FORMAT_HEADER.format(this.getDataDirectory().get("/mydir2/fake.png").lastmodified()), (Object)response.getHeader("Last-Modified"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/resource/mydir2", (Object)response.getHeader("Resource-Parent"));
        Assert.assertEquals((Object)"resource", (Object)response.getHeader("Resource-Type"));
        ResourceControllerTest.assertContentType((String)"image/png", (MockHttpServletResponse)response);
    }

    @Test
    public void testSpecialCharacterNames() throws Exception {
        Assume.assumeTrue((SystemUtils.IS_OS_WINDOWS || this.getDataDirectory().get("po?zie").getType() == Resource.Type.UNDEFINED ? 1 : 0) != 0);
        Assert.assertEquals((Object)Resource.Type.DIRECTORY, (Object)this.getDataDirectory().get("po\u00ebzie").getType());
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        Document doc = this.getAsDOM("/rest/resource/po%c3%abzie?format=xml");
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/po%C3%ABzie/caf%C3%A9", (String)"/ResourceDirectory/children/child/atom:link/@href", (Document)doc);
        MockHttpServletResponse response = this.getAsServletResponse("/rest/resource/po%c3%abzie/caf%c3%a9?format=xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"resource", (Object)response.getHeader("Resource-Type"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/resource/po%C3%ABzie", (Object)response.getHeader("Resource-Parent"));
    }

    @Test
    public void testDirectoryXML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        Document doc = this.getAsDOM("/rest/resource/mydir?format=xml");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"mydir", (String)"/ResourceDirectory/name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"/", (String)"/ResourceDirectory/parent/path", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/", (String)"/ResourceDirectory/parent/atom:link/@href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)this.FORMAT.format(this.myRes.parent().lastmodified()), (String)"/ResourceDirectory/lastModified", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"myres", (String)"/ResourceDirectory/children/child/name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/mydir/myres", (String)"/ResourceDirectory/children/child/atom:link/@href", (Document)doc);
    }

    @Test
    public void testDirectoryJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/resource/mydir?format=json");
        this.print(json);
        String expected = "{\"ResourceDirectory\": {\"name\": \"mydir\",\"parent\":   {  \"path\": \"/\",    \"link\":     {      \"href\": \"http://localhost:8080/geoserver/rest/resource/\",      \"rel\": \"alternate\",      \"type\": \"application/json\"  }},\"lastModified\": \"" + this.FORMAT.format(this.myRes.parent().lastmodified()) + "\",  \"children\": {\"child\": [  {    \"name\": \"myres\",    \"link\":     {      \"href\": \"http://localhost:8080/geoserver" + "/rest" + "/resource/mydir/myres\",      \"rel\": \"alternate\",      \"type\": \"application/octet-stream\"    }  }]}}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)((JSONObject)json));
    }

    @Test
    public void testDirectoryHTML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_HTML);
        Document doc = this.getAsDOM("/rest/resource/mydir?format=html");
        XMLAssert.assertXpathEvaluatesTo((String)"Name: 'mydir'", (String)"/x:html/x:body/x:ul/x:li[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/", (String)"/x:html/x:body/x:ul/x:li[2]/x:a/@href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)("Last modified: " + new Date(this.myRes.parent().lastmodified()).toString()), (String)"/x:html/x:body/x:ul/x:li[3]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/resource/mydir/myres", (String)"/x:html/x:body/x:ul/x:li[4]/x:ul/x:li/x:a/@href", (Document)doc);
    }

    @Test
    public void testDirectoryRootXML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        Document doc = this.getAsDOM("/rest/resource?format=xml");
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/ResourceDirectory/name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/ResourceDirectory/parent", (Document)doc);
    }

    @Test
    public void testDirectoryRootHTML() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_HTML);
        Document doc = this.getAsDOM("/rest/resource?format=html");
        XMLAssert.assertXpathEvaluatesTo((String)"Name: ''", (String)"/x:html/x:body/x:ul/x:li[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Parent: ", (String)"/x:html/x:body/x:ul/x:li[2]", (Document)doc);
    }

    @Test
    public void testDirectoryHeaders() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/resource/mydir?format=xml");
        Assert.assertEquals((Object)this.FORMAT_HEADER.format(this.myRes.parent().lastmodified()), (Object)response.getHeader("Last-Modified"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/resource/", (Object)response.getHeader("Resource-Parent"));
        Assert.assertEquals((Object)"directory", (Object)response.getHeader("Resource-Type"));
        ResourceControllerTest.assertContentType((String)"application/xml", (MockHttpServletResponse)response);
    }

    @Test
    public void testDirectoryHead() throws Exception {
        MockHttpServletResponse response = this.headAsServletResponse("/rest/resource/mydir?format=xml");
        Assert.assertEquals((Object)this.FORMAT_HEADER.format(this.myRes.parent().lastmodified()), (Object)response.getHeader("Last-Modified"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/resource/", (Object)response.getHeader("Resource-Parent"));
        Assert.assertEquals((Object)"directory", (Object)response.getHeader("Resource-Type"));
        ResourceControllerTest.assertContentType((String)"application/xml", (MockHttpServletResponse)response);
    }

    @Test
    public void testDirectoryMimeTypes() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)this.NS_XML);
        Document doc = this.getAsDOM("/rest/resource/mydir2?format=xml");
        XMLAssert.assertXpathEvaluatesTo((String)"image/png", (String)"/ResourceDirectory/children/child[name='imagewithoutextension']/atom:link/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"image/png", (String)"/ResourceDirectory/children/child[name='fake.png']/atom:link/@type", (Document)doc);
    }

    @Test
    public void testUpload() throws Exception {
        this.put("/rest/resource/mydir/mynewres", this.STR_MY_NEW_TEST);
        Resource newRes = this.getDataDirectory().get("/mydir/mynewres");
        try (InputStream is = newRes.in();){
            Assert.assertEquals((Object)this.STR_MY_NEW_TEST, (Object)IOUtils.toString((InputStream)is));
        }
        newRes.delete();
    }

    @Test
    public void testCopy() throws Exception {
        this.put("/rest/resource/mydir/mynewres?operation=cOpY", "/mydir/myres");
        Resource newRes = this.getDataDirectory().get("/mydir/mynewres");
        Assert.assertTrue((boolean)Resources.exists((Resource)this.myRes));
        Assert.assertTrue((boolean)Resources.exists((Resource)newRes));
        try (InputStream is = newRes.in();){
            Assert.assertEquals((Object)this.STR_MY_TEST, (Object)IOUtils.toString((InputStream)is));
        }
        newRes.delete();
    }

    @Test
    public void testMove() throws Exception {
        this.put("/rest/resource/mydir/mynewres?operation=move", "/mydir/myres");
        Resource newRes = this.getDataDirectory().get("/mydir/mynewres");
        Assert.assertFalse((boolean)Resources.exists((Resource)this.myRes));
        Assert.assertTrue((boolean)Resources.exists((Resource)newRes));
        try (InputStream is = newRes.in();){
            Assert.assertEquals((Object)this.STR_MY_TEST, (Object)IOUtils.toString((InputStream)is));
        }
        newRes.renameTo(this.myRes);
    }

    @Test
    public void testMoveDirectory() throws Exception {
        this.put("/rest/resource/mydir/mynewdir?operation=move", "/mydir");
        this.put("/rest/resource/mynewdir?operation=move", "/mydir");
        Resource newDir = this.getDataDirectory().get("/mynewdir");
        Assert.assertTrue((boolean)Resources.exists((Resource)newDir));
        Assert.assertTrue((newDir.getType() == Resource.Type.DIRECTORY ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Resources.exists((Resource)this.myRes));
        Assert.assertTrue((boolean)Resources.exists((Resource)this.getDataDirectory().get("/mynewdir/myres")));
        newDir.renameTo(this.getDataDirectory().get("/mydir"));
    }

    @Test
    public void testDelete() throws Exception {
        Resource newRes = this.getDataDirectory().get("/mydir/mynewres");
        Resources.copy((Resource)this.myRes, (Resource)newRes);
        Assert.assertTrue((boolean)Resources.exists((Resource)newRes));
        this.deleteAsServletResponse("/rest/resource/mydir/mynewres");
        Assert.assertFalse((boolean)Resources.exists((Resource)newRes));
    }

    @Test
    public void testErrorResponseCodes() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/resource/doesntexist");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.deleteAsServletResponse("/rest/resource/doesntexist");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.putAsServletResponse("/rest/resource/mydir");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.putAsServletResponse("/rest/resource/mynewdir?operation=copy", "/mydir", "text/plain");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.putAsServletResponse("/rest/resource/mynewres?operation=copy", "/doesntexist", "text/plain");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.putAsServletResponse("/rest/resource/mynewres?operation=move", "/doesntexist", "text/plain");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.postAsServletResponse("/rest/resource/mydir", "blabla");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    public MockHttpServletResponse headAsServletResponse(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("HEAD");
        request.setContent(new byte[0]);
        return this.dispatch((HttpServletRequest)request, null);
    }
}

