/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.net.URL;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.catalog.HttpTestUtils;
import org.geoserver.rest.catalog.WMSStoreController;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMSStoreTest
extends CatalogRESTTestSupport {
    @ClassRule
    public static TestHttpClientRule clientMocker = new TestHttpClientRule();
    private static String capabilities;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName("sf"));
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL(capabilities);
        catalog.add((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo layer = cb.buildWMSLayer("world4326");
        catalog.add((ResourceInfo)layer);
    }

    @BeforeClass
    public static void mockServer() throws Exception {
        capabilities = clientMocker.getServer() + "/geoserver/wms?REQUEST=GetCapabilities&VERSION=1.3.0&SERVICE=WMS";
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(WMSStoreTest.class.getResource("caps130.xml"), "text/xml", new String[0]));
        clientMocker.bind((HTTPClient)client, capabilities);
    }

    @Test
    public void testBeanPresent() throws Exception {
        Assert.assertThat((Object)GeoServerExtensions.extensions(RestBaseController.class), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(WMSStoreController.class)));
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores.xml");
        Assert.assertEquals((Object)"wmsStores", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size(), (long)dom.getElementsByTagName("wmsStore").getLength());
    }

    @Test
    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmsstores.json");
        Assert.assertTrue((boolean)(json instanceof JSONObject));
        Object stores = ((JSONObject)json).getJSONObject("wmsStores").get("wmsStore");
        Assert.assertNotNull((Object)stores);
        if (stores instanceof JSONArray) {
            Assert.assertEquals((long)catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size(), (long)((JSONArray)stores).size());
        } else {
            Assert.assertEquals((long)1L, (long)catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size());
        }
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores.html");
        List stores = catalog.getStoresByWorkspace("sf", WMSStoreInfo.class);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)stores.size(), (long)links.getLength());
        for (int i = 0; i < stores.size(); ++i) {
            WMSStoreInfo store = (WMSStoreInfo)stores.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(store.getName() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmsstores").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.xml");
        Assert.assertEquals((Object)"wmsStore", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"demo", (Object)xp.evaluate("/wmsStore/name", dom));
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/wmsStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/wmsStore/capabilitiesURL", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        WMSStoreInfo store = (WMSStoreInfo)catalog.getStoreByName("sf", "demo", WMSStoreInfo.class);
        Assert.assertThat((Object)store, (Matcher)Matchers.notNullValue());
        List resources = catalog.getResourcesByStore((StoreInfo)store, WMSLayerInfo.class);
        Assert.assertThat((Object)resources, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.html");
        WMSStoreInfo wms = (WMSStoreInfo)catalog.getStoreByName("demo", WMSStoreInfo.class);
        List wmsLayers = catalog.getResourcesByStore((StoreInfo)wms, WMSLayerInfo.class);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)wmsLayers.size(), (long)links.getLength());
        for (int i = 0; i < wmsLayers.size(); ++i) {
            WMSLayerInfo wl = (WMSLayerInfo)wmsLayers.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(wl.getName() + ".html"));
        }
    }

    @Test
    public void testGetWrongWMSStore() throws Exception {
        String ws = "sf";
        String wms = "sfssssss";
        String requestPath = "/rest/workspaces/" + ws + "/wmsstores/" + wms + ".html";
        String exception = "No such wms store: " + ws + "," + wms;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testPostAsXML() throws Exception {
        String xml = "<wmsStore><name>newWMSStore</name><capabilitiesURL>http://somehost/wms?</capabilitiesURL><workspace>sf</workspace></wmsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        Assert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmsstores/newWMSStore")));
        WMSStoreInfo newStore = (WMSStoreInfo)catalog.getStoreByName("newWMSStore", WMSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wms?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testPostAsXMLNoWorkspace() throws Exception {
        String xml = "<wmsStore><name>newWMSStore</name><capabilitiesURL>http://somehost/wms?</capabilitiesURL></wmsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        Assert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmsstores/newWMSStore")));
        WMSStoreInfo newStore = (WMSStoreInfo)catalog.getStoreByName("newWMSStore", WMSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wms?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmsstores/demo.json");
        JSONObject store = ((JSONObject)json).getJSONObject("wmsStore");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"demo", (Object)store.get("name"));
        Assert.assertEquals((Object)"sf", (Object)store.getJSONObject("workspace").get("name"));
        Assert.assertEquals((Object)capabilities, (Object)store.getString("capabilitiesURL"));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeStore("sf", "newWMSStore");
        String json = "{'wmsStore':{'capabilitiesURL': 'http://somehost/wms?','workspace':'sf','name':'newWMSStore',}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmsstores/newWMSStore"));
        WMSStoreInfo newStore = (WMSStoreInfo)catalog.getStoreByName("newWMSStore", WMSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wms?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<wmsStore><name>demo</name><enabled>false</enabled></wmsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmsStore/enabled", (Document)dom);
        String xml = "<wmsStore><name>demo</name><enabled>false</enabled></wmsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmsStore/enabled", (Document)dom);
        Assert.assertFalse((boolean)((WMSStoreInfo)catalog.getStoreByName("sf", "demo", WMSStoreInfo.class)).isEnabled());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        WMSStoreInfo wsi = (WMSStoreInfo)catalog.getStoreByName("sf", "demo", WMSStoreInfo.class);
        wsi.setEnabled(true);
        catalog.save((StoreInfo)wsi);
        Assert.assertTrue((boolean)wsi.isEnabled());
        int maxConnections = wsi.getMaxConnections();
        int readTimeout = wsi.getReadTimeout();
        int connectTimeout = wsi.getConnectTimeout();
        boolean useConnectionPooling = wsi.isUseConnectionPooling();
        String xml = "<wmsStore><name>demo</name></wmsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        wsi = (WMSStoreInfo)catalog.getStoreByName("sf", "demo", WMSStoreInfo.class);
        Assert.assertTrue((boolean)wsi.isEnabled());
        Assert.assertEquals((long)maxConnections, (long)wsi.getMaxConnections());
        Assert.assertEquals((long)readTimeout, (long)wsi.getReadTimeout());
        Assert.assertEquals((long)connectTimeout, (long)wsi.getConnectTimeout());
        Assert.assertEquals((Object)useConnectionPooling, (Object)wsi.isUseConnectionPooling());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<wmsStore><name>changed</name></wmsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/nonExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        this.removeStore("sf", "newWMSStore");
        this.testPostAsXML();
        Assert.assertNotNull((Object)catalog.getStoreByName("sf", "newWMSStore", WMSStoreInfo.class));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/newWMSStore").getStatus());
        Assert.assertNull((Object)catalog.getStoreByName("sf", "newWMSStore", WMSStoreInfo.class));
    }

    @Test
    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<wmsStore><name>newName</name></wmsStore>";
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml").getStatus());
    }

    @Test
    public void testPutWorkspaceChangeForbidden() throws Exception {
        String xml = "<wmsStore><workspace>gs</workspace></wmsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.FORBIDDEN));
    }
}

