/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.net.URL;
import junit.framework.AssertionFailedError;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.catalog.HttpTestUtils;
import org.geoserver.rest.catalog.WMSLayerController;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMSLayerTest
extends CatalogRESTTestSupport {
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName("sf"));
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL(this.clientMocker.getServer() + "/geoserver/wms?REQUEST=GetCapabilities&VERSION=1.3.0&SERVICE=WMS");
        catalog.add((StoreInfo)wms);
        this.addStatesWmsLayer();
    }

    @Before
    public void addStatesWmsLayer() throws Exception {
        String capabilities = this.clientMocker.getServer() + "/geoserver/wms?REQUEST=GetCapabilities&VERSION=1.3.0&SERVICE=WMS";
        WMSLayerInfo wml = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        if (wml == null) {
            wml = catalog.getFactory().createWMSLayer();
            wml.setName("states");
            wml.setNativeName("topp:states");
            wml.setStore(catalog.getStoreByName("demo", WMSStoreInfo.class));
            wml.setCatalog(catalog);
            wml.setNamespace(catalog.getNamespaceByPrefix("sf"));
            wml.setSRS("EPSG:4326");
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            wml.setNativeCRS(wgs84);
            wml.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
            wml.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            catalog.add((ResourceInfo)wml);
        }
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("caps130.xml"), "text/xml", new String[0]));
        this.clientMocker.bind((HTTPClient)client, capabilities);
    }

    @After
    public void removeLayer() throws Exception {
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", "states"));
        if (l != null) {
            catalog.remove(l);
        }
    }

    @Before
    public void removeBugsites() throws Exception {
        ResourceInfo r;
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", "bugsites"));
        if (l != null) {
            catalog.remove(l);
        }
        if ((r = catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class)) != null) {
            catalog.remove(r);
        }
    }

    @Test
    public void testBeanPresent() throws Exception {
        Assert.assertThat((Object)GeoServerExtensions.extensions(RestBaseController.class), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(WMSLayerController.class)));
    }

    @Test
    public void testGetAllByWorkspace() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmslayers.xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((long)catalog.getResourcesByNamespace(catalog.getNamespaceByPrefix("sf"), WMSLayerInfo.class).size(), (long)dom.getElementsByTagName("wmsLayer").getLength());
    }

    @Test
    public void testGetAllByWMSStore() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers.xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wmsLayer").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wmsLayer/name[text()='states'])", (Document)dom);
    }

    @Test
    public void testGetAllAvailable() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo/wmslayers.xml?list=available", 200);
        XMLAssert.assertXpathExists((String)"/list/wmsLayerName[text() = 'world4326']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/list/wmsLayerName[text() = 'anotherLayer']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/list/wmsLayerName[text() = 'topp:states']", (Document)dom);
    }

    @Test
    public void testGetAllAvailableJSON() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers.json?list=available");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        JSON json = this.json(response);
        JSONArray names = (JSONArray)((JSONObject)((JSONObject)json).get("list")).get("string");
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)"world4326"), Matchers.equalTo((Object)"anotherLayer")}));
    }

    protected JSON getAsJSON(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        try {
            return this.json(response);
        }
        catch (JSONException ex) {
            throw new AssertionFailedError("Invalid JSON: \"" + response.getContentAsString() + "\"");
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers").getStatus());
    }

    @Test
    public void testPostAsXML() throws Exception {
        Assert.assertThat((Object)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class), (Matcher)Matchers.nullValue());
        String xml = "<wmsLayer><name>bugsites</name><nativeName>world4326</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><store>demo</store></wmsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        Assert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmsstores/demo/wmslayers/bugsites")));
        WMSLayerInfo layer = (WMSLayerInfo)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class);
        Assert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostAsXMLNoWorkspace() throws Exception {
        Assert.assertThat((Object)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class), (Matcher)Matchers.nullValue());
        String xml = "<wmsLayer><name>bugsites</name><nativeName>world4326</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><store>demo</store></wmsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmslayers/", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        Assert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmslayers/bugsites")));
        WMSLayerInfo layer = (WMSLayerInfo)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class);
        Assert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        Assert.assertThat((Object)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class), (Matcher)Matchers.nullValue());
        String json = "{'wmsLayer':{'name':'bugsites','nativeName':'world4326','srs':'EPSG:4326','nativeCRS':'EPSG:4326','store':'demo'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/", json, "text/json");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        Assert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmsstores/demo/wmslayers/bugsites")));
        WMSLayerInfo layer = (WMSLayerInfo)catalog.getResourceByName("sf", "bugsites", WMSLayerInfo.class);
        Assert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<wmsLayer><name>og:restricted</name></wmsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmslayers/states.xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((Object)"wmsLayer", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"states", (String)"/wmsLayer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"/wmsLayer/srs", (Document)dom);
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)xp.evaluate("/wmsLayer/nativeCRS", dom));
        WMSLayerInfo wml = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        ReferencedEnvelope re = wml.getLatLonBoundingBox();
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinX() + ""), (String)"/wmsLayer/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxX() + ""), (String)"/wmsLayer/latLonBoundingBox/maxx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinY() + ""), (String)"/wmsLayer/latLonBoundingBox/miny", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxY() + ""), (String)"/wmsLayer/latLonBoundingBox/maxy", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmslayers/states.json");
        JSONObject featureType = ((JSONObject)json).getJSONObject("wmsLayer");
        Assert.assertNotNull((Object)featureType);
        Assert.assertEquals((Object)"states", (Object)featureType.get("name"));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)featureType.get("nativeCRS"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)featureType.get("srs"));
    }

    @Test
    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmslayers/states.html");
    }

    @Test
    public void testGetWrongWMSLayer() throws Exception {
        String ws = "sf";
        String wms = "demo";
        String wl = "statessssss";
        String requestPath = "/rest/workspaces/" + ws + "/wmslayers/" + wl + ".html";
        String requestPath2 = "/rest/workspaces/" + ws + "/wmsstores/" + wms + "/wmslayers/" + wl + ".html";
        String exception = "No such cascaded wms: " + ws + "," + wl;
        String exception2 = "No such cascaded wms layer: " + ws + "," + wms + "," + wl;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)exception)));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.isEmptyString());
        response = this.getAsServletResponse(requestPath2);
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)exception));
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)exception)));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<wmsLayer><title>Lots of states here</title></wmsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states", xml, "text/xml");
        Assert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo/wmslayers/states.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"Lots of states here", (String)"/wmsLayer/title", (Document)dom);
        WMSLayerInfo wli = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        Assert.assertEquals((Object)"Lots of states here", (Object)wli.getTitle());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        WMSLayerInfo wli = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        wli.setEnabled(true);
        catalog.save((ResourceInfo)wli);
        wli = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        Assert.assertTrue((boolean)wli.isEnabled());
        boolean isAdvertised = wli.isAdvertised();
        String xml = "<wmsLayer><title>Lots of states here</title></wmsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        wli = (WMSLayerInfo)catalog.getResourceByName("sf", "states", WMSLayerInfo.class);
        Assert.assertTrue((boolean)wli.isEnabled());
        Assert.assertEquals((Object)isAdvertised, (Object)wli.isAdvertised());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<wmsLayer><title>new title</title></wmsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/bugsites", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        Assert.assertThat((Object)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states"), HttpTestUtils.hasStatus(HttpStatus.OK));
        Assert.assertNull((Object)catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/NonExistent").getStatus());
    }

    void addLayer() {
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", "states"));
        if (l == null) {
            l = catalog.getFactory().createLayer();
            l.setResource(catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
            catalog.add(l);
        }
    }

    @Test
    public void testDeleteNonRecursive() throws Exception {
        this.addLayer();
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        this.addLayer();
        Assert.assertNotNull((Object)catalog.getLayerByName("sf:states"));
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/demo/wmslayers/states?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("sf:states"));
        Assert.assertNull((Object)catalog.getResourceByName("sf", "states", WMSLayerInfo.class));
    }

    @Test
    public void testResourceLink() throws Exception {
        this.addLayer();
        Document doc = this.getAsDOM("/rest/layers/states.xml");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String resourceUrl = xpath.evaluate("//resource/atom:link/@href", doc);
        resourceUrl = resourceUrl.substring(resourceUrl.indexOf("/rest"));
        doc = this.getAsDOM(resourceUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"states", (String)"/wmsLayer/name", (Document)doc);
    }
}

