/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class TemplateControllerTest
extends CatalogRESTTestSupport {
    public void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Override
    @Before
    public void login() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    private String getIndexAsString(String childPath, String format) throws Exception {
        String indexUrl = childPath.substring(0, childPath.lastIndexOf("/"));
        if (format != null) {
            indexUrl = indexUrl + "." + format;
        }
        return this.getAsString(indexUrl);
    }

    private static String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1, path.length());
    }

    private void testGetPutGetDeleteGet(String path, String content) throws Exception {
        String name = TemplateControllerTest.getName(path);
        String htmlIndexToken = "geoserver" + path + "\">" + name + "</a></li>";
        String xmlIndexToken = "<name>" + name + "</name>";
        String jsonIndexToken = "{\"name\":\"" + name + "\"";
        this.assertNotFound(path);
        Assert.assertFalse((boolean)this.getIndexAsString(path, null).contains(htmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "html").contains(htmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "xml").contains(xmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "json").contains(jsonIndexToken));
        this.put(path, content).close();
        String list = this.getIndexAsString(path, null);
        if (!list.contains(htmlIndexToken)) {
            Assert.assertTrue((String)("list " + path), (boolean)list.contains(htmlIndexToken));
        }
        Assert.assertTrue((String)("list " + path), (boolean)this.getIndexAsString(path, "html").contains(htmlIndexToken));
        Assert.assertTrue((String)("list " + path), (boolean)this.getIndexAsString(path, "xml").contains(xmlIndexToken));
        Assert.assertTrue((String)("list " + path), (boolean)this.getIndexAsString(path, "json").contains(jsonIndexToken));
        Assert.assertEquals((Object)content, (Object)this.getAsString(path).trim());
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(path).getStatus());
        this.assertNotFound(path);
        Assert.assertFalse((boolean)this.getIndexAsString(path, null).contains(htmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "html").contains(htmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "xml").contains(xmlIndexToken));
        Assert.assertFalse((boolean)this.getIndexAsString(path, "json").contains(jsonIndexToken));
    }

    @Test
    public void testGetPutGetDeleteGet() throws Exception {
        String path = "/rest/templates/my_template.ftl";
        this.testGetPutGetDeleteGet(path, "hello world");
    }

    private List<String> getAllPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/rest/templates/aTemplate.ftl");
        paths.add("/rest/templates/anotherTemplate.ftl");
        paths.add("/rest/workspaces/topp/templates/aTemplate.ftl");
        paths.add("/rest/workspaces/topp/templates/anotherTemplate.ftl");
        paths.add("/rest/workspaces/topp/datastores/states_shapefile/templates/aTemplate.ftl");
        paths.add("/rest/workspaces/topp/datastores/states_shapefile/templates/anotherTemplate.ftl");
        paths.add("/rest/workspaces/topp/datastores/states_shapefile/featuretypes/states/templates/aTemplate.ftl");
        paths.add("/rest/workspaces/topp/datastores/states_shapefile/featuretypes/states/templates/anotherTemplate.ftl");
        paths.add("/rest/workspaces/wcs/coveragestores/DEM/templates/aTemplate.ftl");
        paths.add("/rest/workspaces/wcs/coveragestores/DEM/templates/anotherTemplate.ftl");
        paths.add("/rest/workspaces/wcs/coveragestores/DEM/coverages/tazdem.tiff/templates/aTemplate.ftl");
        paths.add("/rest/workspaces/wcs/coveragestores/DEM/coverages/tazdem.tiff/templates/anotherTemplate.ftl");
        return paths;
    }

    @Test
    public void testAllPathsSequentially() throws Exception {
        Random random = new Random();
        for (String path : this.getAllPaths()) {
            this.testGetPutGetDeleteGet(path, "hello test " + random.nextInt(1000));
        }
    }

    void assertNotFound(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path + "?quietOnNotFound=true");
        Assert.assertEquals((String)("404 expected for '" + path + "'"), (long)404L, (long)response.getStatus());
    }

    @Test
    public void testAllPaths() throws Exception {
        String contentHeader = "hello path ";
        List<String> paths = this.getAllPaths();
        for (String path : paths) {
            this.assertNotFound(path);
        }
        for (String path : paths) {
            this.put(path, contentHeader + path).close();
        }
        for (String path : paths) {
            Assert.assertEquals((Object)(contentHeader + path), (Object)this.getAsString(path).trim());
        }
        for (String path : paths) {
            MockHttpServletResponse response = this.deleteAsServletResponse(path);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        for (String path : paths) {
            this.assertNotFound(path);
        }
    }

    @Test
    public void testUpdate() throws Exception {
        String fooTemplate = "/rest/templates/foo.ftl";
        String barTemplate = "/rest/templates/bar.ftl";
        String fooContent = "hello foo - longer than bar";
        String barContent = "hello bar";
        this.put(fooTemplate, fooContent).close();
        this.put(barTemplate, barContent).close();
        Assert.assertEquals((Object)fooContent, (Object)this.getAsString(fooTemplate).trim());
        Assert.assertEquals((Object)barContent, (Object)this.getAsString(barTemplate).trim());
        fooContent = "goodbye foo";
        this.put(fooTemplate, fooContent).close();
        Assert.assertEquals((Object)fooContent, (Object)this.getAsString(fooTemplate).trim());
        Assert.assertEquals((Object)barContent, (Object)this.getAsString(barTemplate).trim());
    }
}

