/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class StructuredCoverageStoresTest
extends CatalogRESTTestSupport {
    private static final String WATER_VIEW = "waterView";
    protected static QName WATTEMP = new QName(MockData.WCS_PREFIX, "watertemp", MockData.WCS_PREFIX);
    protected static QName S2_OVR = new QName(MockData.WCS_PREFIX, "s2_ovr", MockData.WCS_PREFIX);
    protected static QName IR_RGB = new QName(MockData.SF_URI, "ir-rgb", MockData.SF_PREFIX);
    private static final String RGB_IR_VIEW = "RgbIrView";
    List<File> movedFiles = new ArrayList<File>();
    private XpathEngine xpath;
    private File mosaic;

    @BeforeClass
    public static void setupTimeZone() {
        System.setProperty("user.timezone", "GMT");
        System.setProperty("gt2.jdbc.trace", "true");
    }

    @Before
    public void prepare() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @AfterClass
    public static void cleanupTimeZone() {
        System.clearProperty("user.timezone");
    }

    @Before
    public void setupWaterTemp() throws Exception {
        Catalog cat = this.getCatalog();
        CoverageInfo waterView = cat.getCoverageByName(WATER_VIEW);
        if (waterView != null) {
            cat.remove((ResourceInfo)waterView);
        }
        ((SystemTestData)this.getTestData()).addRasterLayer(WATTEMP, "watertemp.zip", null, null, SystemTestData.class, this.getCatalog());
        this.getGeoServer().reset();
        this.mosaic = new File(testData.getDataDirectoryRoot(), WATTEMP.getLocalPart());
        for (File file : FileUtils.listFiles((File)this.mosaic, (IOFileFilter)new RegexFileFilter("NCOM_.*100_.*tiff"), null)) {
            File target = new File(file.getParentFile().getParentFile(), file.getName());
            this.movedFiles.add(target);
            if (target.exists()) {
                Assert.assertTrue((boolean)target.delete());
            }
            Assert.assertTrue((boolean)file.renameTo(target));
        }
        for (File file : FileUtils.listFiles((File)this.mosaic, (IOFileFilter)new RegexFileFilter("watertemp.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("watertemp");
        CoverageView.InputCoverageBand band = new CoverageView.InputCoverageBand("watertemp", "0");
        CoverageView.CoverageBand outputBand = new CoverageView.CoverageBand(Collections.singletonList(band), "watertemp@0", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView(WATER_VIEW, Collections.singletonList(outputBand));
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(WATER_VIEW, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfo);
        this.getDataDirectory().getRoot(new String[]{"s2_ovr"}).delete();
        ((SystemTestData)this.getTestData()).addRasterLayer(S2_OVR, "hetero_s2_ovr.zip", null, null, StructuredCoverageStoresTest.class, this.getCatalog());
    }

    @Before
    public void setupIR_RGB() throws Exception {
        Catalog cat = this.getCatalog();
        CoverageInfo waterView = cat.getCoverageByName(RGB_IR_VIEW);
        if (waterView != null) {
            cat.remove((ResourceInfo)waterView);
        }
        this.getGeoServer().reset();
        File dir = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot(), "ir-rgb");
        FileUtils.deleteQuietly((File)dir);
        ((SystemTestData)this.getTestData()).addRasterLayer(IR_RGB, "ir-rgb.zip", null, null, SystemTestData.class, cat);
        CoverageView.CoverageBand rBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "0")), "rband", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand gBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "1")), "gband", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand bBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "2")), "bband", 2, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand irBand = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand("ir", "0")), "irband", 3, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView(RGB_IR_VIEW, Arrays.asList(rBand, gBand, bBand, irBand));
        coverageView.setEnvelopeCompositionType(null);
        coverageView.setSelectedResolution(null);
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("ir-rgb");
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(RGB_IR_VIEW, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfo);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addWorkspace(SystemTestData.WCS_PREFIX, SystemTestData.WCS_URI, this.getCatalog());
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("gf", "http://www.geoserver.org/rest/granules");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Test
    public void testIndexResourcesXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp", (String)"/coverageStore/name", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp", (String)"/coverage/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp", (String)"/coverage/nativeName", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//Schema/attributes/Attribute)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"org.locationtech.jts.geom.MultiPolygon", (String)"/Schema/attributes/Attribute[name='the_geom']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.String", (String)"/Schema/attributes/Attribute[name='location']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.util.Date", (String)"/Schema/attributes/Attribute[name='ingestion']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.Integer", (String)"/Schema/attributes/Attribute[name='elevation']/binding", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:elevation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:elevation", (Document)dom);
        String octoberId = this.xpath.evaluate("//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/@fid", dom);
        String novemberId = this.xpath.evaluate("//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/@fid", dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/" + octoberId + ".xml");
        XMLAssert.assertXpathEvaluatesTo((String)octoberId, (String)"//gf:watertemp/@fid", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"NCOM_wattemp_000_20081031T0000000_12.tiff", (String)"//gf:watertemp/gf:location", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp/gf:elevation", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/" + novemberId + ".xml");
        XMLAssert.assertXpathEvaluatesTo((String)novemberId, (String)"//gf:watertemp/@fid", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"NCOM_wattemp_000_20081101T0000000_12.tiff", (String)"//gf:watertemp/gf:location", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp/gf:elevation", (Document)dom);
    }

    @Test
    public void testGranulesOnRenamedCoverage() throws Exception {
        CoverageStoreInfo store = catalog.getCoverageStoreByName("watertemp");
        CoverageInfo coverage = catalog.getCoverageByCoverageStore(store, "watertemp");
        coverage.setName("renamed");
        catalog.save((ResourceInfo)coverage);
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/renamed/index.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//Schema/attributes/Attribute)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"org.locationtech.jts.geom.MultiPolygon", (String)"/Schema/attributes/Attribute[name='the_geom']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.String", (String)"/Schema/attributes/Attribute[name='location']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.util.Date", (String)"/Schema/attributes/Attribute[name='ingestion']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.Integer", (String)"/Schema/attributes/Attribute[name='elevation']/binding", (Document)dom);
    }

    @Test
    public void testIndexResourcesJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index.json");
        JSONObject schema = json.getJSONObject("Schema");
        JSONObject external = schema.getJSONObject("attributes");
        JSONArray attributes = external.getJSONArray("Attribute");
        Assert.assertEquals((long)4L, (long)attributes.size());
        Assert.assertEquals((Object)"org.locationtech.jts.geom.MultiPolygon", (Object)attributes.getJSONObject(0).get("binding"));
        json = (JSONObject)this.getAsJSON("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.json");
        JSONArray features = json.getJSONArray("features");
        String octoberId = null;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            String location = feature.getJSONObject("properties").getString("location");
            if (!"NCOM_wattemp_000_20081031T0000000_12.tiff".equals(location)) continue;
            octoberId = feature.getString("id");
        }
        json = (JSONObject)this.getAsJSON("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/" + octoberId + ".json", 200);
        features = json.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertEquals((Object)octoberId, (Object)feature.get("id"));
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertEquals((Object)"NCOM_wattemp_000_20081031T0000000_12.tiff", (Object)properties.get("location"));
        Assert.assertEquals((Object)0, (Object)properties.get("elevation"));
    }

    @Test
    public void testMissingGranule() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/notThere.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetWrongGranule() throws Exception {
        String ws = "wcs";
        String cs = "watertemp";
        String g = "notThere";
        String requestPath = "/rest/workspaces/" + ws + "/coveragestores/" + cs + "/coverages/" + cs + "/index/granules/" + g;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)g));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testDeleteSingleGranule() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        String octoberId = this.xpath.evaluate("//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/@fid", dom);
        Assert.assertNotNull((Object)octoberId);
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/" + octoberId);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:elevation", (Document)dom);
    }

    @Test
    public void testDeleteSingleGranuleGsConfigStyle() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        String octoberId = this.xpath.evaluate("//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/@fid", dom);
        Assert.assertNotNull((Object)octoberId);
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules/" + octoberId + "/.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:elevation", (Document)dom);
    }

    @Test
    public void testDeleteAllGranules() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gf:watertemp)", (Document)dom);
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gf:watertemp)", (Document)dom);
    }

    @Test
    public void testDeleteByFilter() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gf:watertemp)", (Document)dom);
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules?filter=ingestion=2008-11-01T00:00:00Z");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:elevation", (Document)dom);
    }

    @Test
    public void testHarvestSingle() throws Exception {
        File file = this.movedFiles.get(0);
        File target = new File(this.mosaic, file.getName());
        Assert.assertTrue((boolean)file.renameTo(target));
        URL url = URLs.fileToUrl((File)target.getCanonicalFile());
        String body = url.toExternalForm();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/external.imagemosaic", body, "text/plain");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//gf:watertemp[gf:location = '" + file.getName() + "'])"), (Document)dom);
    }

    @Test
    public void testHarvestSingleSimplePath() throws Exception {
        File file = this.movedFiles.get(0);
        File target = new File(this.mosaic, file.getName());
        Assert.assertTrue((boolean)file.renameTo(target));
        String body = target.getCanonicalPath();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/external.imagemosaic", body, "text/plain");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//gf:watertemp[gf:location = '" + file.getName() + "'])"), (Document)dom);
    }

    @Test
    public void testHarvestMulti() throws Exception {
        for (File file : this.movedFiles) {
            File target = new File(this.mosaic, file.getName());
            Assert.assertTrue((boolean)file.renameTo(target));
        }
        URL url = URLs.fileToUrl((File)this.mosaic.getCanonicalFile());
        String body = url.toExternalForm();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/external.imagemosaic", body, "text/plain");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/watertemp/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//gf:watertemp)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081031T0000000_12.tiff']/gf:elevation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_000_20081101T0000000_12.tiff']/gf:elevation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_100_20081031T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_100_20081031T0000000_12.tiff']/gf:elevation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00Z", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_100_20081101T0000000_12.tiff']/gf:ingestion", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100", (String)"//gf:watertemp[gf:location = 'NCOM_wattemp_100_20081101T0000000_12.tiff']/gf:elevation", (Document)dom);
    }

    @Test
    public void testGetIndexAndGranulesOnView() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/waterView/index.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//Schema/attributes/Attribute)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"org.locationtech.jts.geom.MultiPolygon", (String)"/Schema/attributes/Attribute[name='the_geom']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.String", (String)"/Schema/attributes/Attribute[name='location']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.util.Date", (String)"/Schema/attributes/Attribute[name='ingestion']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.Integer", (String)"/Schema/attributes/Attribute[name='elevation']/binding", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/waterView/index/granules.xml", 200);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gf:waterView)", (Document)dom);
    }

    @Test
    public void testGetIndexAndGranulesOnMultiCoverageView() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//Schema/attributes/Attribute)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"org.locationtech.jts.geom.Polygon", (String)"/Schema/attributes/Attribute[name='the_geom']/binding", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"java.lang.String", (String)"/Schema/attributes/Attribute[name='location']/binding", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index/granules.xml", 200);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gf:RgbIrView)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:RgbIrView[@fid='RgbIrView.rgb.1']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:RgbIrView[@fid='RgbIrView.ir.1']", (Document)dom);
    }

    @Test
    public void testGetGranuleInMultiCoverageView() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index/granules/RgbIrView.rgb.1", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:RgbIrView)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:RgbIrView[@fid='RgbIrView.rgb.1']", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index/granules/RgbIrView.ir.1", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:RgbIrView)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:RgbIrView[@fid='RgbIrView.ir.1']", (Document)dom);
    }

    @Test
    public void testDeleteGranuleInMultiCoverageView() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index/granules/RgbIrView.rgb.1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = this.getAsServletResponse("/rest/workspaces/sf/coveragestores/ir-rgb/coverages/RgbIrView/index/granules/RgbIrView.rgb.1");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetGranuleInSingleCoverageView() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/watertemp/coverages/waterView/index/granules/waterView.watertemp.1", 200);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gf:waterView)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:waterView[@fid='waterView.watertemp.1']", (Document)dom);
    }

    @Test
    public void testDeleteGranuleInSingleCoverageView() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/waterView/index/granules/waterView.watertemp.1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = this.getAsServletResponse("/rest/workspaces/wcs/coveragestores/watertemp/coverages/waterView/index/granules/waterView.watertemp.1");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDeletePurgeNoneFilter() throws Exception {
        List<String> filesAfter = this.removeWithPurge("&purge=none");
        Assert.assertThat(filesAfter, (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)"g3.tif"), (Matcher)Matchers.hasItem((Object)"g3.tif.ovr")));
    }

    @Test
    public void testDeletePurgeAll() throws Exception {
        List<String> filesAfter = this.removeWithPurge("&purge=all");
        Assert.assertThat(filesAfter, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)CoreMatchers.containsString((String)"g3.tif"))));
    }

    private List<String> removeWithPurge(String purgeSpec) throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/s2_ovr/coverages/s2_ovr/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//gf:s2_ovr)", (Document)dom);
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/s2_ovr/coverages/s2_ovr/index/granules?filter=location LIKE 'g3%25'" + purgeSpec);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/s2_ovr/coverages/s2_ovr/index/granules.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//gf:s2_ovr)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:s2_ovr[gf:location = 'g1.tif']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:s2_ovr[gf:location = 'g2.tif']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gf:s2_ovr[gf:location = 'g4.tif']", (Document)dom);
        Resource mosaicContents = this.getDataDirectory().getRoot(new String[]{"s2_ovr"});
        List<String> files = mosaicContents.list().stream().map(r -> r.name()).collect(Collectors.toList());
        return files;
    }
}

