/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamespaceTest
extends CatalogRESTTestSupport {
    @Before
    public void cleanNamespaces() {
        this.removeWorkspace("foo");
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces.xml", 200);
        Assert.assertEquals((long)catalog.getNamespaces().size(), (long)dom.getElementsByTagName("namespace").getLength());
    }

    @Test
    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/namespaces.json");
        Assert.assertTrue((boolean)(json instanceof JSONObject));
        JSONArray namespaces = ((JSONObject)json).getJSONObject("namespaces").getJSONArray("namespace");
        Assert.assertNotNull((Object)namespaces);
        Assert.assertEquals((long)catalog.getNamespaces().size(), (long)namespaces.size());
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces.html");
        List namespaces = catalog.getNamespaces();
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)namespaces.size(), (long)links.getLength());
        for (int i = 0; i < namespaces.size(); ++i) {
            NamespaceInfo ws = (NamespaceInfo)namespaces.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(ws.getPrefix() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/namespaces").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/namespaces").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/sf.xml", 200);
        Assert.assertEquals((Object)"namespace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("prefix").getLength());
        Element prefix = (Element)dom.getElementsByTagName("prefix").item(0);
        Assert.assertEquals((Object)"sf", (Object)prefix.getFirstChild().getTextContent());
        Element name = (Element)dom.getElementsByTagName("uri").item(0);
        Assert.assertEquals((Object)MockData.SF_URI, (Object)name.getFirstChild().getTextContent());
    }

    @Test
    public void testRoundTripXMLSerialization() throws Exception {
        this.removeNamespace("ian");
        String xml = "<namespace><prefix>ian</prefix><uri>http://ian.com</uri></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/namespaces/ian"));
        NamespaceInfo ws = this.getCatalog().getNamespaceByPrefix("ian");
        Assert.assertNotNull((Object)ws);
        Document dom = this.getAsDOM("/rest/namespaces/ian.xml");
        Assert.assertEquals((Object)"namespace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("prefix").getLength());
        Element prefix = (Element)dom.getElementsByTagName("prefix").item(0);
        Assert.assertEquals((Object)"ian", (Object)prefix.getFirstChild().getTextContent());
        Element name = (Element)dom.getElementsByTagName("uri").item(0);
        Assert.assertEquals((Object)"http://ian.com", (Object)name.getFirstChild().getTextContent());
    }

    @Test
    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/sf.html");
        List resources = catalog.getResourcesByNamespace("sf", ResourceInfo.class);
        NodeList listItems = xp.getMatchingNodes("//html:li", dom);
        Assert.assertEquals((long)resources.size(), (long)listItems.getLength());
        for (int i = 0; i < resources.size(); ++i) {
            ResourceInfo resource = (ResourceInfo)resources.get(i);
            Element listItem = (Element)listItems.item(i);
            Assert.assertTrue((boolean)listItem.getFirstChild().getNodeValue().endsWith(resource.getName()));
        }
    }

    @Test
    public void testGetWrongNamespace() throws Exception {
        String namespace = "sfsssss";
        String requestPath = "/rest/namespaces/" + namespace + ".html";
        String exception = "No such namespace: '" + namespace + "'";
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
    }

    @Test
    public void testGetNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/namespaces/none").getStatus());
    }

    @Test
    public void testPostAsXML() throws Exception {
        String xml = "<namespace><prefix>foo</prefix><uri>http://foo.com</uri></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/namespaces/foo"));
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix("foo");
        Assert.assertNotNull((Object)ns);
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        Assert.assertNotNull((Object)ws);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/namespaces/sf.json");
        JSONObject namespace = ((JSONObject)json).getJSONObject("namespace");
        Assert.assertEquals((Object)"sf", (Object)namespace.get("prefix"));
        Assert.assertEquals((Object)MockData.SF_URI, (Object)namespace.get("uri"));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeNamespace("foo");
        String json = "{'namespace':{ 'prefix':'foo', 'uri':'http://foo.com' }}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/namespaces/foo"));
        NamespaceInfo ws = this.getCatalog().getNamespaceByPrefix("foo");
        Assert.assertNotNull((Object)ws);
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<namespace><name>changed</name></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces/gs", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/namespaces/newExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        String xml = "<namespace><prefix>foo</prefix><uri>http://foo.com</uri></namespace>";
        this.post("/rest/namespaces", xml);
        Document dom = this.getAsDOM("/rest/namespaces/foo.xml");
        Assert.assertEquals((Object)"namespace", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/namespaces/foo").getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/namespaces/foo.xml").getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/foo.xml").getStatus());
    }

    @Test
    public void testDeleteNonEmpty() throws Exception {
        Assert.assertEquals((long)401L, (long)this.deleteAsServletResponse("/rest/namespaces/sf").getStatus());
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<namespace><uri>http://changed</uri></namespace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/namespaces/gs", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/namespaces/gs.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//namespace/uri[text()='http://changed'])", (Document)dom);
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<namespace><name>changed</name></namespace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/namespaces/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetDefaultNamespace() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/default.xml");
        Assert.assertEquals((Object)"namespace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("prefix").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("uri").getLength());
    }

    @Test
    public void testPutDefaultNamespace() throws Exception {
        NamespaceInfo def = this.getCatalog().getDefaultNamespace();
        Assert.assertEquals((Object)"gs", (Object)def.getPrefix());
        String json = "{'namespace':{ 'prefix':'sf' }}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/namespaces/default", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        def = this.getCatalog().getDefaultNamespace();
        Assert.assertEquals((Object)"sf", (Object)def.getPrefix());
    }

    @Test
    public void testIsolatedNamespacesHandling() throws Exception {
        String xmlPost = "<namespace>  <id>isolated_namespace</id>  <prefix>isolated_prefix</prefix>  <uri>http://www.isolated.org/1.0</uri>  <isolated>true</isolated></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces.xml", xmlPost, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        NamespaceInfo namespace = this.getCatalog().getNamespaceByPrefix("isolated_prefix");
        Assert.assertThat((Object)namespace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)namespace.isIsolated(), (Matcher)Matchers.is((Object)true));
        WorkspaceInfo workspace = this.getCatalog().getWorkspaceByName("isolated_prefix");
        Assert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)workspace.isIsolated(), (Matcher)Matchers.is((Object)true));
        String xmlPut = "<namespace>  <id>isolated_namespace</id>  <prefix>isolated_prefix</prefix>  <uri>http://www.isolated.org/1.0</uri>  <isolated>false</isolated></namespace>";
        response = this.putAsServletResponse("/rest/namespaces/isolated_prefix", xmlPut, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        namespace = this.getCatalog().getNamespaceByPrefix("isolated_prefix");
        Assert.assertThat((Object)namespace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)namespace.isIsolated(), (Matcher)Matchers.is((Object)false));
        workspace = this.getCatalog().getWorkspaceByName("isolated_prefix");
        Assert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)workspace.isIsolated(), (Matcher)Matchers.is((Object)false));
    }
}

