/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.data.DataAccess;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class FeatureTypeControllerTest
extends CatalogRESTTestSupport {
    private static String BASEPATH = "/rest";

    @Before
    public void removePropertyStores() {
        this.removeStore("gs", "pds");
        this.removeStore("gs", "ngpds");
    }

    @Before
    public void addPrimitiveGeoFeature() throws IOException {
        this.revertLayer(SystemTestData.PRIMITIVEGEOFEATURE);
    }

    @Test
    public void testGetAllByWorkspace() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/sf/featuretypes.xml");
        Assert.assertEquals((long)catalog.getFeatureTypesByNamespace(catalog.getNamespaceByPrefix("sf")).size(), (long)dom.getElementsByTagName("featureType").getLength());
    }

    void addPropertyDataStore(boolean configureFeatureType) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsa.0='zero'|POINT(0 0)\n");
        writer.write("pdsa.1='one'|POINT(1 1)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsa.properties"));
        zout.write(bytes.toByteArray());
        bytes.reset();
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsb.0='two'|POINT(2 2)\n");
        writer.write("pdsb.1='trhee'|POINT(3 3)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsb.properties"));
        zout.write(bytes.toByteArray());
        zout.flush();
        zout.close();
        String q = "configure=" + (configureFeatureType ? "all" : "none");
        this.put(BASEPATH + "/workspaces/gs/datastores/pds/file.properties?" + q, zbytes.toByteArray(), "application/zip");
    }

    void addGeomlessPropertyDataStore(boolean configureFeatureType) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
        writer.write("_=name:String,intProperty:Integer\n");
        writer.write("ngpdsa.0='zero'|0\n");
        writer.write("ngpdsa.1='one'|1\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("ngpdsa.properties"));
        zout.write(bytes.toByteArray());
        bytes.reset();
        writer.write("_=name:String,intProperty:Integer\n");
        writer.write("ngpdsb.0='two'|2\n");
        writer.write("ngpdsb.1='trhee'|3\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("ngpdsb.properties"));
        zout.write(bytes.toByteArray());
        zout.flush();
        zout.close();
        String q = "configure=" + (configureFeatureType ? "all" : "none");
        this.put(BASEPATH + "/workspaces/gs/datastores/ngpds/file.properties?" + q, zbytes.toByteArray(), "application/zip");
    }

    void addPropertyDataStoreOnlyConfigureFirst() throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsa.0='zero'|POINT(0 0)\n");
        writer.write("pdsa.1='one'|POINT(1 1)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsa.properties"));
        zout.write(bytes.toByteArray());
        bytes.reset();
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsb.0='two'|POINT(2 2)\n");
        writer.write("pdsb.1='trhee'|POINT(3 3)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsb.properties"));
        zout.write(bytes.toByteArray());
        zout.flush();
        zout.close();
        String q = "configure=first";
        this.put(BASEPATH + "/workspaces/gs/datastores/pds/file.properties?" + q, zbytes.toByteArray(), "application/zip");
    }

    @Test
    public void testGetAllByDataStore() throws Exception {
        this.addPropertyDataStore(true);
        this.addGeomlessPropertyDataStore(true);
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/gs/datastores/pds/featuretypes.xml");
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("featureType").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureType/name[text()='pdsa'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureType/name[text()='pdsb'])", (Document)dom);
    }

    @Test
    public void testGetAllAvailable() throws Exception {
        this.addPropertyDataStore(false);
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/gs/datastores/pds/featuretypes.xml?list=available");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsa'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsb'])", (Document)dom);
    }

    @Test
    public void testGetAllAvailableWithGeometryOnly() throws Exception {
        this.addGeomlessPropertyDataStore(false);
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/gs/datastores/ngpds/featuretypes.xml?list=available");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//featureTypeName)", (Document)dom);
        dom = this.getAsDOM(BASEPATH + "/workspaces/gs/datastores/ngpds/featuretypes.xml?list=available_with_geom");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//featureTypeName)", (Document)dom);
    }

    @Test
    public void testGetAllByDataStoreWithListAll() throws Exception {
        this.addPropertyDataStoreOnlyConfigureFirst();
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/gs/datastores/pds/featuretypes.xml?list=all");
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("featureTypeName").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsa'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsb'])", (Document)dom);
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes").getStatus());
    }

    @Test
    public void testPostToResource() throws Exception {
        this.addPropertyDataStore(true);
        String xml = "<featureType><name>pdsa</name></featureType>";
        MockHttpServletResponse response = this.postAsServletResponse(BASEPATH + "/workspaces/gs/datastores/pds/featuretypes/pdsa", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/sf/featuretypes/PrimitiveGeoFeature.xml");
        Assert.assertEquals((Object)"featureType", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"PrimitiveGeoFeature", (String)"/featureType/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"/featureType/srs", (Document)dom);
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)xp.evaluate("/featureType/nativeCRS", dom));
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        ReferencedEnvelope re = ft.getLatLonBoundingBox();
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinX() + ""), (String)"/featureType/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxX() + ""), (String)"/featureType/latLonBoundingBox/maxx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMinY() + ""), (String)"/featureType/latLonBoundingBox/miny", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(re.getMaxY() + ""), (String)"/featureType/latLonBoundingBox/maxy", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON(BASEPATH + "/workspaces/sf/featuretypes/PrimitiveGeoFeature.json");
        JSONObject featureType = ((JSONObject)json).getJSONObject("featureType");
        XMLAssert.assertNotNull((Object)featureType);
        Assert.assertEquals((Object)"PrimitiveGeoFeature", (Object)featureType.get("name"));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)featureType.get("nativeCRS"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)featureType.get("srs"));
    }

    @Test
    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.html");
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        this.addPropertyDataStore(true);
        String dom = this.getAsString(BASEPATH + "/workspaces/gs/datastores/pds/featuretypes.xml");
        System.out.println(dom);
    }

    @Test
    public void testGetWrongFeatureType() throws Exception {
        String ws = "sf";
        String ds = "sf";
        String ft = "PrimitiveGeoFeaturessss";
        String requestPath = BASEPATH + "/workspaces/" + ws + "/featuretypes/" + ft + ".html";
        String requestPath2 = BASEPATH + "/workspaces/" + ws + "/datastores/" + ds + "/featuretypes/" + ft + ".html";
        String exception = "No such feature type: " + ws + "," + ft;
        String exception2 = "No such feature type: " + ws + "," + ds + "," + ft;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        FeatureTypeControllerTest.assertContains(response.getContentAsString(), exception);
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
        response = this.getAsServletResponse(requestPath2);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        FeatureTypeControllerTest.assertContains(response.getContentAsString(), exception2);
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/featureType/title", (Document)dom);
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertEquals((Object)"new title", (Object)ft.getTitle());
    }

    @Test
    public void testPutWithoutStore() throws Exception {
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/featuretypes/PrimitiveGeoFeature", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM(BASEPATH + "/workspaces/sf/featuretypes/PrimitiveGeoFeature.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/featureType/title", (Document)dom);
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertEquals((Object)"new title", (Object)ft.getTitle());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertTrue((boolean)ft.isEnabled());
        boolean isAdvertised = ft.isAdvertised();
        int maxFeatures = ft.getMaxFeatures();
        int numDecimals = ft.getNumDecimals();
        boolean isOverridingServiceSRS = ft.isOverridingServiceSRS();
        boolean getSkipNumberMatched = ft.getSkipNumberMatched();
        boolean isCircularArcPresent = ft.isCircularArcPresent();
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ft = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertTrue((boolean)ft.isEnabled());
        Assert.assertEquals((Object)isAdvertised, (Object)ft.isAdvertised());
        Assert.assertEquals((long)maxFeatures, (long)ft.getMaxFeatures());
        Assert.assertEquals((long)numDecimals, (long)ft.getNumDecimals());
        Assert.assertEquals((Object)isOverridingServiceSRS, (Object)ft.isOverridingServiceSRS());
        Assert.assertEquals((Object)getSkipNumberMatched, (Object)ft.getSkipNumberMatched());
        Assert.assertEquals((Object)isCircularArcPresent, (Object)ft.isCircularArcPresent());
    }

    @Test
    public void testPutWithCalculation() throws Exception {
        DataStoreInfo dataStoreInfo = this.getCatalog().getDataStoreByName("sf", "sf");
        String dataStoreId = dataStoreInfo.getId();
        DataAccess dataAccessBefore = dataStoreInfo.getDataStore(null);
        XMLAssert.assertSame((String)"ResourcePool DataStoreCache", (Object)dataAccessBefore, this.getCatalog().getResourcePool().getDataStoreCache().get(dataStoreId));
        String clearLatLonBoundingBox = "<featureType><nativeBoundingBox><minx>-180.0</minx><maxx>180.0</maxx><miny>-90.0</miny><maxy>90.0</maxy><crs>EPSG:4326</crs></nativeBoundingBox><latLonBoundingBox/></featureType>";
        String path = BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature";
        MockHttpServletResponse response = this.putAsServletResponse(path, clearLatLonBoundingBox, "text/xml");
        Assert.assertEquals((String)("Couldn't remove lat/lon bounding box:\n" + response.getContentAsString()), (long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM(path + ".xml");
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"/featureType/latLonBoundingBox/minx", (Document)dom);
        DataAccess dataAccessAfter = this.getCatalog().getDataStoreByName("sf", "sf").getDataStore(null);
        XMLAssert.assertSame((String)"ResourcePool DataStoreCache check 1", (Object)dataAccessBefore, (Object)dataAccessAfter);
        XMLAssert.assertSame((String)"ResourcePool DataStoreCache", (Object)dataAccessBefore, this.getCatalog().getResourcePool().getDataStoreCache().get(dataStoreId));
        String updateNativeBounds = "<featureType><srs>EPSG:3785</srs><nativeBoundingBox><minx>-20037508.34</minx><maxx>20037508.34</maxx><miny>-20037508.34</miny><maxy>20037508.34</maxy><crs>EPSG:3785</crs></nativeBoundingBox></featureType>";
        response = this.putAsServletResponse(path + ".xml", updateNativeBounds, "text/xml");
        Assert.assertEquals((String)("Couldn't update native bounding box: \n" + response.getContentAsString()), (long)200L, (long)response.getStatus());
        dom = this.getAsDOM(path + ".xml");
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/featureType/latLonBoundingBox/minx[text()!='0.0']", (Document)dom);
        dataAccessAfter = this.getCatalog().getDataStoreByName("sf", "sf").getDataStore(null);
        XMLAssert.assertSame((String)"ResourcePool DataStoreCache check 2", (Object)dataAccessBefore, (Object)dataAccessAfter);
        XMLAssert.assertSame((String)"ResourcePool DataStoreCache", (Object)dataAccessBefore, this.getCatalog().getResourcePool().getDataStoreCache().get(dataStoreId));
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/NonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        String featureTypeId = featureType.getId();
        String dataStoreId = featureType.getStore().getId();
        Name name = featureType.getFeatureType().getName();
        XMLAssert.assertNotNull((String)"PrmitiveGeoFeature available", (Object)featureType);
        for (LayerInfo l : catalog.getLayers((ResourceInfo)featureType)) {
            catalog.remove(l);
        }
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature").getStatus());
        Assert.assertNull((Object)catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        if (catalog.getResourcePool().getFeatureTypeAttributeCache().containsKey(featureTypeId)) {
            List attributesList = (List)catalog.getResourcePool().getFeatureTypeAttributeCache().get(featureTypeId);
            Assert.assertNull((String)"attributes cleared", (Object)attributesList);
        }
        if (catalog.getResourcePool().getDataStoreCache().containsKey(dataStoreId)) {
            DataAccess dataStore = (DataAccess)catalog.getResourcePool().getDataStoreCache().get(dataStoreId);
            List names = dataStore.getNames();
            Assert.assertTrue((boolean)names.contains(name));
        }
    }

    @Test
    public void testDeleteWithoutStore() throws Exception {
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        String featureTypeId = featureType.getId();
        String dataStoreId = featureType.getStore().getId();
        Name name = featureType.getFeatureType().getName();
        XMLAssert.assertNotNull((String)"PrmitiveGeoFeature available", (Object)featureType);
        for (LayerInfo l : catalog.getLayers((ResourceInfo)featureType)) {
            catalog.remove(l);
        }
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/featuretypes/PrimitiveGeoFeature").getStatus());
        Assert.assertNull((Object)catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        if (catalog.getResourcePool().getFeatureTypeAttributeCache().containsKey(featureTypeId)) {
            List attributesList = (List)catalog.getResourcePool().getFeatureTypeAttributeCache().get(featureTypeId);
            Assert.assertNull((String)"attributes cleared", (Object)attributesList);
        }
        if (catalog.getResourcePool().getDataStoreCache().containsKey(dataStoreId)) {
            DataAccess dataStore = (DataAccess)catalog.getResourcePool().getDataStoreCache().get(dataStoreId);
            List names = dataStore.getNames();
            Assert.assertTrue((boolean)names.contains(name));
        }
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/NonExistant").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        XMLAssert.assertNotNull((Object)catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        XMLAssert.assertNotNull((Object)catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature").getStatus());
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        Assert.assertNull((Object)catalog.getLayerByName("sf:PrimitiveGeoFeature"));
    }

    @Test
    public void testPostGeometrylessFeatureType() throws Exception {
        this.addGeomlessPropertyDataStore(false);
        String xml = "<featureType><name>ngpdsa</name></featureType>";
        MockHttpServletResponse response = this.postAsServletResponse(BASEPATH + "/workspaces/gs/datastores/ngpds/featuretypes", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        XMLAssert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/datastores/ngpds/featuretypes/ngpdsa"));
    }

    @Test
    public void testDeleteWsNotSameAsStoreName() throws Exception {
        this.testPostGeometrylessFeatureType();
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(BASEPATH + "/workspaces/gs/datastores/ngpds/featuretypes/ngpdsa?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getFeatureTypeByName("gs", "ngpdsa"));
    }

    @Test
    public void testCreateFeatureType() throws Exception {
        String xml = "<featureType>\n  <name>states</name>\n  <nativeName>states</nativeName>\n  <namespace>\n    <name>cite</name>\n  </namespace>\n  <title>USA Population</title>\n  <srs>EPSG:4326</srs>\n  <attributes>\n    <attribute>\n      <name>the_geom</name>\n      <binding>org.locationtech.jts.geom.MultiPolygon</binding>\n    </attribute>\n    <attribute>\n      <name>STATE_NAME</name>\n      <binding>java.lang.String</binding>\n      <length>25</length>\n    </attribute>\n    <attribute>\n      <name>LAND_KM</name>\n      <binding>java.lang.Double</binding>\n    </attribute>\n  </attributes>\n</featureType>";
        MockHttpServletResponse response = this.postAsServletResponse(BASEPATH + "/workspaces/cite/datastores/default/featuretypes", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        XMLAssert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/cite/datastores/default/featuretypes/states"));
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("cite", "states");
        XMLAssert.assertNotNull((Object)ft);
        FeatureType schema = ft.getFeatureType();
        Assert.assertEquals((Object)"states", (Object)schema.getName().getLocalPart());
        Assert.assertEquals((Object)catalog.getNamespaceByPrefix("cite").getURI(), (Object)schema.getName().getNamespaceURI());
        Assert.assertEquals((long)3L, (long)schema.getDescriptors().size());
        XMLAssert.assertNotNull((Object)schema.getDescriptor("the_geom"));
        Assert.assertEquals(MultiPolygon.class, (Object)schema.getDescriptor("the_geom").getType().getBinding());
        XMLAssert.assertNotNull((Object)schema.getDescriptor("LAND_KM"));
        Assert.assertEquals(Double.class, (Object)schema.getDescriptor("LAND_KM").getType().getBinding());
    }

    @Test
    public void testRoundTripFeatureTypeXML() throws Exception {
        FeatureTypeInfo before = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        String xml = this.getAsString(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.xml");
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        FeatureTypeInfo after = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testRoundTripFeatureTypJSONL() throws Exception {
        FeatureTypeInfo before = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        String json = this.getAsString(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.json");
        System.out.println(json);
        MockHttpServletResponse response = this.putAsServletResponse(BASEPATH + "/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        FeatureTypeInfo after = catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        Assert.assertEquals((Object)before, (Object)after);
    }

    public static void assertContains(String message, String contains) {
        Assert.assertTrue((String)("Expected \"" + message + "\" to contain \"" + contains + "\""), (boolean)message.contains(contains));
    }

    @Test
    public void testEnabledServicesOnLayer() throws Exception {
        this.disableServicesOnBuildings();
        Document dom = this.getAsDOM("/rest/workspaces/cite/datastores/cite/featuretypes/Buildings.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//serviceConfiguration", (Document)dom);
        XMLAssert.assertXpathExists((String)"//disabledServices/string[.='WFS']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//disabledServices/string[.='CSW']", (Document)dom);
        this.enableServicesOnBuildings();
    }

    private void disableServicesOnBuildings() {
        LayerInfo linfo = this.getCatalog().getLayerByName("Buildings");
        ResourceInfo ri = linfo.getResource();
        ri.setServiceConfiguration(true);
        ri.setDisabledServices(new ArrayList<String>(Arrays.asList("WFS", "CSW")));
        this.getCatalog().save(ri);
        this.getCatalog().save(linfo);
    }

    private void enableServicesOnBuildings() {
        LayerInfo linfo = this.getCatalog().getLayerByName("Buildings");
        ResourceInfo ri = linfo.getResource();
        ri.setServiceConfiguration(false);
        ri.setDisabledServices(new ArrayList());
        this.getCatalog().save(ri);
        this.getCatalog().save(linfo);
    }
}

