/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.Filter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.filters.LoggingFilter;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.util.URLs;
import org.h2.tools.DeleteDbFiles;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataStoreFileUploadTest
extends CatalogRESTTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        NamespaceInfoImpl gsmlNamespace = new NamespaceInfoImpl();
        gsmlNamespace.setPrefix("gsml");
        gsmlNamespace.setURI("http://www.cgi-iugs.org/xml/GeoSciML/2");
        WorkspaceInfoImpl gsmlWorkspace = new WorkspaceInfoImpl();
        gsmlWorkspace.setName("gsml");
        this.getCatalog().add((NamespaceInfo)gsmlNamespace);
        this.getCatalog().add((WorkspaceInfo)gsmlWorkspace);
    }

    protected List<Filter> getFilters() {
        LoggingFilter filter = new LoggingFilter();
        filter.setEnabled(true);
        filter.setLogBodies(true);
        return Collections.singletonList(filter);
    }

    @Before
    public void removePdsDataStore() {
        this.removeStore("gs", "pds");
        this.removeStore("gs", "store with spaces");
    }

    @After
    public void cleanUpDbFiles() throws Exception {
        DeleteDbFiles.execute((String)"target", (String)"foo", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"pds", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"chinese_poly", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"san_andres_y_providencia", (boolean)true);
    }

    byte[] propertyFile() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("ds.0='zero'|POINT(0 0)\n");
        writer.write("ds.1='one'|POINT(1 1)\n");
        writer.flush();
        return output.toByteArray();
    }

    void assertFeatures(Document dom) throws Exception {
        this.assertFeatures(dom, "gs");
    }

    void assertFeatures(Document dom, String ns) throws Exception {
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName(ns + ":pds").getLength());
    }

    byte[] shpZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip"));
    }

    byte[] shpChineseZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/chinese_poly.zip"));
    }

    byte[] shpSanAndresShapefilesZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/san_andres_y_providencia.zip"));
    }

    byte[] shpMultiZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pdst.zip"));
    }

    byte[] toBytes(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    @Test
    public void testShapeFileUploadNotExisting() throws Exception {
        File file = new File("./target/notThere.tiff");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL url = URLs.fileToUrl((File)file.getCanonicalFile());
        String body = url.toExternalForm();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/datastores/pds/external.shp", body, "text/plain");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    @Ignore
    public void testShapeFileUploadWithSpaces() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "store with spaces"));
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/store%20with%20spaces/file.shp", bytes, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "store with spaces");
        Assert.assertNull((Object)ds);
    }

    @Test
    public void testShapefileUploadMultiple() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "pdst"));
        this.put("/rest/workspaces/gs/datastores/pdst/file.shp?configure=all", this.shpMultiZipAsBytes(), "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "pdst");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((long)2L, (long)cat.getFeatureTypesByDataStore(ds).size());
    }

    @Test
    public void testShapefileUploadZip() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "san_andres_y_providencia"));
        this.put("/rest/workspaces/gs/datastores/san_andres_y_providencia/file.shp", this.shpSanAndresShapefilesZipAsBytes(), "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "san_andres_y_providencia");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((long)1L, (long)cat.getFeatureTypesByDataStore(ds).size());
    }

    @Test
    public void testGetProperties() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", bytes, "text/plain");
        resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"application/zip", (Object)resp.getContentType());
        ByteArrayInputStream bin = this.getBinaryInputStream(resp);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"pds.properties", (Object)entry.getName());
    }

    @Test
    public void testAppSchemaMappingFileUpload() throws Exception {
        byte[] bytes = this.appSchemaMappingAsBytes();
        if (bytes == null) {
            LOGGER.warning("app-schema test data not available: skipping test");
            return;
        }
        this.loadAppSchemaTestData();
        this.put("/rest/workspaces/gsml/datastores/mappedPolygons/file.appschema", bytes, "text/xml");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gsml:MappedFeature");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        NodeList mappedFeatureNodes = dom.getDocumentElement().getElementsByTagNameNS("http://www.cgi-iugs.org/xml/GeoSciML/2", "MappedFeature");
        Assert.assertNotNull((Object)mappedFeatureNodes);
        Assert.assertEquals((long)2L, (long)mappedFeatureNodes.getLength());
        int namesCount = this.countNameAttributes(mappedFeatureNodes.item(0));
        Assert.assertEquals((long)2L, (long)namesCount);
        bytes = this.appSchemaAlternativeMappingAsBytes();
        this.put("/rest/workspaces/gsml/datastores/mappedPolygons/file.appschema?configure=none", bytes, "text/xml");
        dom = this.getAsDOM("wfs?request=getfeature&typename=gsml:MappedFeature");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        mappedFeatureNodes = dom.getDocumentElement().getElementsByTagNameNS("http://www.cgi-iugs.org/xml/GeoSciML/2", "MappedFeature");
        Assert.assertNotNull((Object)mappedFeatureNodes);
        Assert.assertEquals((long)2L, (long)mappedFeatureNodes.getLength());
        namesCount = this.countNameAttributes(mappedFeatureNodes.item(0));
        Assert.assertEquals((long)1L, (long)namesCount);
    }

    private int countNameAttributes(Node mappedFeatureNode) {
        NodeList attrNodes = mappedFeatureNode.getChildNodes();
        int namesCount = 0;
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            Node attribute = attrNodes.item(i);
            if (!"name".equals(attribute.getLocalName())) continue;
            ++namesCount;
        }
        return namesCount;
    }

    private void loadAppSchemaTestData() throws IOException {
        GeoServerResourceLoader loader = new GeoServerResourceLoader(((SystemTestData)this.getTestData()).getDataDirectoryRoot());
        loader.copyFromClassPath("test-data/mappedPolygons.properties", "data/gsml/mappedPolygons.properties");
        loader.copyFromClassPath("test-data/mappedPolygons.oasis.xml", "data/gsml/mappedPolygons.oasis.xml");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/CGI_basicTypes.xsd", "data/gsml/commonSchemas_new/GeoSciML/CGI_basicTypes.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/CGI_Value.xsd", "data/gsml/commonSchemas_new/GeoSciML/CGI_Value.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/earthMaterial.xsd", "data/gsml/commonSchemas_new/GeoSciML/earthMaterial.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/fossil.xsd", "data/gsml/commonSchemas_new/GeoSciML/fossil.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geologicStructure.xsd", "data/gsml/commonSchemas_new/GeoSciML/geologicStructure.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geologicUnit.xsd", "data/gsml/commonSchemas_new/GeoSciML/geologicUnit.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geosciml.xsd", "data/gsml/commonSchemas_new/GeoSciML/geosciml.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/Gsml.xsd", "data/gsml/commonSchemas_new/GeoSciML/Gsml.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/metadata.xsd", "data/gsml/commonSchemas_new/GeoSciML/metadata.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/ObsAndMeas.xsd", "data/gsml/commonSchemas_new/GeoSciML/ObsAndMeas.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/vocabulary.xsd", "data/gsml/commonSchemas_new/GeoSciML/vocabulary.xsd");
    }

    private byte[] appSchemaMappingAsBytes() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/test-data/mappedPolygons.xml");
        if (in != null) {
            byte[] original = this.toBytes(in);
            String originalAsString = new String(original, Charset.forName("UTF-8"));
            String modifiedAsString = originalAsString.replace("file:./", "file:../").replace("commonSchemas_new/", "../commonSchemas_new/").replace("mappedPolygons.oasis", "../mappedPolygons.oasis");
            byte[] modified = modifiedAsString.getBytes(Charset.forName("UTF-8"));
            return modified;
        }
        return null;
    }

    private byte[] appSchemaAlternativeMappingAsBytes() throws Exception {
        byte[] mapping = this.appSchemaMappingAsBytes();
        if (mapping != null) {
            Document mappingDom = this.dom(new ByteArrayInputStream(mapping));
            NodeList attrMappingNodes = mappingDom.getDocumentElement().getElementsByTagName("AttributeMapping");
            block0: for (int i = 0; i < attrMappingNodes.getLength(); ++i) {
                Node attrMapping = attrMappingNodes.item(i);
                NodeList children = attrMapping.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    if (!"MappedFeature/gml:name[2]".equals(children.item(j).getTextContent())) continue;
                    attrMapping.getParentNode().removeChild(attrMapping);
                    continue block0;
                }
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.print(mappingDom, output);
            return output.toByteArray();
        }
        return null;
    }
}

