/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.rest.util.RESTUtils;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.util.URLs;
import org.geotools.util.factory.GeoTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.referencing.FactoryException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CoverageStoreFileUploadTest
extends CatalogRESTTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo store = cb.buildDataStore("h2test");
        store.getConnectionParameters().put("dbtype", "h2");
        store.getConnectionParameters().put("database", new File(this.getDataDirectory().findOrCreateDir(new String[]{"data"}), "h2_test").getAbsolutePath());
        store.getConnectionParameters().put("MVCC", true);
        catalog.save((StoreInfo)store);
    }

    @Before
    public void cleanup() throws IOException {
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName("mosaic", CoverageInfo.class);
        if (coverage != null) {
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
    }

    @Test
    public void testWorldImageUploadZipped() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/coveragestores/usa/file.worldimage", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        Assert.assertEquals((Object)"coverageStore", (Object)d.getDocumentElement().getNodeName());
        CoverageStoreInfo cs = this.getCatalog().getCoverageStoreByName("sf", "usa");
        Assert.assertNotNull((Object)cs);
        CoverageInfo ci = this.getCatalog().getCoverageByName("sf", "usa");
        Assert.assertNotNull((Object)ci);
    }

    @Test
    @Ignore
    public void testUploadWithSpaces() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/store%20with%20spaces/file.worldimage", bytes, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testUploadImageMosaic() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
    }

    @Test
    public void testUploadImageMosaicRepoReference() throws Exception {
        URL zip = CoverageStoreFileUploadTest.class.getResource("watertemp-repo.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp-repo/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp-repo", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp-repo");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp-repo");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        DataStore ds = (DataStore)this.getCatalog().getDataStoreByName("h2test").getDataStore(null);
        Assert.assertNotNull((Object)ds);
        SimpleFeatureSource fs = ds.getFeatureSource("watertemp-repo");
        Assert.assertNotNull((Object)fs);
        Assert.assertEquals((long)4L, (long)fs.getCount(Query.ALL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(URL zip) throws IOException {
        byte[] bytes;
        InputStream is = null;
        try {
            is = zip.openStream();
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestImageMosaic() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp2/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp2", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp2");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp2");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        InputStream is = null;
        try {
            is = zipHarvest.openStream();
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp2/file.imagemosaic");
        request.setMethod("POST");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        this.dispatch((HttpServletRequest)request);
        GridCoverageReader reader = storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
    }

    @Test
    public void testHarvestNotAllowedOnSimpleCoverageStore() throws Exception {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        byte[] bytes = this.getBytes(zipHarvest);
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/wcs/coveragestores/BlueMarble");
        request.setMethod("POST");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testHarvestImageMosaicWithDirectory() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp3/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp3", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp3");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp3");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        Resource newZip = Files.asResource((File)new File("./target/harvesting2.zip"));
        IOUtils.copyStream((InputStream)zipHarvest.openStream(), (OutputStream)newZip.out(), (boolean)true, (boolean)true);
        Resource outputDirectory = Files.asResource((File)new File("./target/harvesting"));
        RESTUtils.unzipFile((Resource)newZip, (Resource)outputDirectory);
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp3/external.imagemosaic");
        request.setMethod("POST");
        request.setContentType("text/plain");
        request.setContent(("file:///" + outputDirectory.dir().getAbsolutePath()).getBytes("UTF-8"));
        request.addHeader("Content-type", (Object)"text/plain");
        this.dispatch((HttpServletRequest)request);
        GridCoverageReader reader = storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        outputDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestExternalImageMosaic() throws Exception {
        File oldDir;
        URL resource = ((Object)((Object)this)).getClass().getResource("test-data/mosaic");
        if (resource != null && (oldDir = URLs.urlToFile((URL)resource)).exists()) {
            FileUtils.deleteDirectory((File)oldDir);
        }
        Resource mosaic = this.readMosaic();
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("gs");
        CoverageStoreInfo store = builder.buildCoverageStore("watertemp4");
        store.setURL(URLs.fileToUrl((File)Resources.find((Resource)mosaic)).toExternalForm());
        store.setWorkspace(ws);
        ImageMosaicFormat imageMosaicFormat = new ImageMosaicFormat();
        store.setType(imageMosaicFormat.getName());
        this.getCatalog().add((StoreInfo)store);
        builder.setStore((StoreInfo)store);
        ImageMosaicReader reader = null;
        StructuredGridCoverage2DReader reader2 = null;
        try {
            reader = imageMosaicFormat.getReader((Object)DataUtilities.fileToURL((File)Resources.find((Resource)mosaic)));
            this.configureCoverageInfo(builder, store, (GridCoverage2DReader)reader);
            CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp4");
            Assert.assertNotNull((Object)storeInfo);
            CoverageInfo ci = this.getCatalog().getCoverageByName("mosaic");
            Assert.assertNotNull((Object)ci);
            Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
            URL zipHarvest = MockData.class.getResource("harvesting.zip");
            byte[] bytes = this.getBytes(zipHarvest);
            MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp4/file.imagemosaic");
            request.setMethod("POST");
            request.setContentType("application/zip");
            request.setContent(bytes);
            request.addHeader("Content-type", (Object)"application/zip");
            MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
            reader2 = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
            String[] metadataNames = reader2.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader2.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader2.getMetadataValue(metadataNames[0]));
            reader2.delete(true);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            if (reader2 != null) {
                try {
                    reader2.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReHarvestSingleTiff() throws Exception {
        File oldDir;
        URL resource = ((Object)((Object)this)).getClass().getResource("test-data/mosaic");
        if (resource != null && (oldDir = URLs.urlToFile((URL)resource)).exists()) {
            FileUtils.deleteDirectory((File)oldDir);
        }
        Resource mosaic = this.readMosaic();
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("gs");
        CoverageStoreInfo store = builder.buildCoverageStore("watertemp5");
        store.setURL(URLs.fileToUrl((File)Resources.find((Resource)mosaic)).toExternalForm());
        store.setWorkspace(ws);
        ImageMosaicFormat imageMosaicFormat = new ImageMosaicFormat();
        store.setType(imageMosaicFormat.getName());
        this.getCatalog().add((StoreInfo)store);
        builder.setStore((StoreInfo)store);
        ImageMosaicReader reader = null;
        StructuredGridCoverage2DReader reader2 = null;
        try {
            reader = imageMosaicFormat.getReader((Object)DataUtilities.fileToURL((File)Resources.find((Resource)mosaic)));
            this.configureCoverageInfo(builder, store, (GridCoverage2DReader)reader);
            CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp5");
            Assert.assertNotNull((Object)storeInfo);
            CoverageInfo ci = this.getCatalog().getCoverageByName("mosaic");
            Assert.assertNotNull((Object)ci);
            Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
            URL zipHarvest = MockData.class.getResource("harvesting.zip");
            byte[] bytes = null;
            try (ZipInputStream zis = new ZipInputStream(zipHarvest.openStream());){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!"NCOM_wattemp_000_20081102T0000000_12.tiff".equals(entry.getName())) continue;
                    bytes = IOUtils.toByteArray((InputStream)zis);
                }
                if (bytes == null) {
                    Assert.fail((String)"Could not find the expected zip entry NCOM_wattemp_000_20081102T0000000_12.tiff");
                }
            }
            reader2 = this.uploadGeotiffAndCheck(storeInfo, bytes, "NCOM_wattemp_000_20081102T0000000_12.tiff");
            reader2 = this.uploadGeotiffAndCheck(storeInfo, bytes, "NCOM_wattemp_000_20081102T0000000_12.tiff");
            reader2.delete(true);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            if (reader2 != null) {
                try {
                    reader2.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private StructuredGridCoverage2DReader uploadGeotiffAndCheck(CoverageStoreInfo storeInfo, byte[] bytes, String filename) throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp5/file.imagemosaic?filename=" + filename);
        request.setMethod("POST");
        request.setContentType("image/tiff");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"image/tiff");
        Assert.assertEquals((long)202L, (long)this.dispatch((HttpServletRequest)request).getStatus());
        StructuredGridCoverage2DReader reader2 = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader2.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader2.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader2.getMetadataValue(metadataNames[0]));
        return reader2;
    }

    private Resource readMosaic() throws FactoryException, IOException {
        URL mosaicZip = ((Object)((Object)this)).getClass().getResource("test-data/watertemp2.zip");
        Resource zipFile = Files.asResource((File)URLs.urlToFile((URL)mosaicZip));
        Resource newZip = zipFile.parent().get("watertemp2_temp.zip");
        IOUtils.copyStream((InputStream)zipFile.in(), (OutputStream)newZip.out(), (boolean)true, (boolean)true);
        Resource mosaic = zipFile.parent().get("mosaic");
        mosaic.delete();
        RESTUtils.unzipFile((Resource)newZip, (Resource)mosaic);
        return mosaic;
    }

    private void configureCoverageInfo(CatalogBuilder builder, CoverageStoreInfo storeInfo, GridCoverage2DReader reader) throws Exception {
        HashMap customParameters = new HashMap();
        CoverageInfo cinfo = builder.buildCoverage(reader, customParameters);
        String name = reader.getGridCoverageNames()[0];
        cinfo.setName(name);
        cinfo.setNativeCoverageName(name);
        this.getCatalog().add((ResourceInfo)cinfo);
    }
}

