/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.HashMap;
import java.util.Properties;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Before;

public abstract class CatalogRESTTestSupport
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;
    protected static XpathEngine xp;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"*"});
        catalog = this.getCatalog();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("html", "http://www.w3.org/1999/xhtml");
        namespaces.put("sld", "http://www.opengis.net/sld");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("atom", "http://www.w3.org/2005/Atom");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xp = XMLUnit.newXpathEngine();
    }

    protected final void setUpUsers(Properties props) {
    }

    protected final void setUpLayerRoles(Properties properties) {
    }

    @Before
    public void login() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }
}

