/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.Collections;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class AdminRequestTest
extends CatalogRESTTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("global");
        lg.getLayers().add(catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        lg.getLayers().add(catalog.getLayerByName("sf:AggregateGeoFeature"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326")));
        catalog.add(lg);
        lg = catalog.getFactory().createLayerGroup();
        lg.setName("local");
        lg.setWorkspace(catalog.getWorkspaceByName("sf"));
        lg.getLayers().add(catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        lg.getLayers().add(catalog.getLayerByName("sf:AggregateGeoFeature"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326")));
        catalog.add(lg);
        Catalog cat = this.getCatalog();
        StyleInfo s = cat.getFactory().createStyle();
        s.setName("sf_style");
        s.setWorkspace(cat.getWorkspaceByName("sf"));
        s.setFilename("sf.sld");
        cat.add(s);
        s = cat.getFactory().createStyle();
        s.setName("cite_style");
        s.setWorkspace(cat.getWorkspaceByName("cite"));
        s.setFilename("cite.sld");
        cat.add(s);
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_CITE_ADMIN"));
        this.addUser("sf", "sf", null, Collections.singletonList("ROLE_SF_ADMIN"));
        this.addLayerAccessRule("*", "*", AccessMode.ADMIN, new String[]{"ROLE_ADMINISTRATOR"});
        this.addLayerAccessRule("cite", "*", AccessMode.ADMIN, new String[]{"ROLE_CITE_ADMIN"});
        this.addLayerAccessRule("sf", "*", AccessMode.ADMIN, new String[]{"ROLE_SF_ADMIN"});
    }

    @After
    public void clearAdminRequest() {
        AdminRequest.finish();
    }

    @Override
    public void login() throws Exception {
    }

    void loginAsCite() {
        this.login("cite", "cite", new String[]{"ROLE_CITE_ADMIN"});
    }

    void loginAsSf() {
        this.login("sf", "sf", new String[]{"ROLE_SF_ADMIN"});
    }

    @Test
    public void testWorkspaces() throws Exception {
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/workspaces.xml").getStatus());
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("workspace").getLength());
        super.login();
        dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)this.getCatalog().getWorkspaces().size(), (long)dom.getElementsByTagName("workspace").getLength());
        this.loginAsCite();
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/workspaces.xml").getStatus());
        dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("workspace").getLength());
    }

    @Test
    public void testWorkspacesWithProxyHeaders() throws Exception {
        GeoServerInfo ginfo = this.getGeoServer().getGlobal();
        SettingsInfo settings = this.getGeoServer().getGlobal().getSettings();
        ginfo.setUseHeadersProxyURL(Boolean.valueOf(true));
        settings.setProxyBaseUrl("${X-Forwarded-Proto}://${X-Forwarded-Host}/${X-Forwarded-Path} ${X-Forwarded-Proto}://${X-Forwarded-Host}");
        ginfo.setSettings(settings);
        this.getGeoServer().save(ginfo);
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/workspaces.xml").getStatus());
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("workspace").getLength());
        super.login();
        dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)this.getCatalog().getWorkspaces().size(), (long)dom.getElementsByTagName("workspace").getLength());
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/workspaces.xml").getStatus());
        dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)this.getCatalog().getWorkspaces().size(), (long)dom.getElementsByTagName("workspace").getLength());
    }

    @Test
    public void testWorkspace() throws Exception {
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/sf.xml").getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/cite.xml").getStatus());
        this.loginAsCite();
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/sf.xml").getStatus());
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/workspaces/cite.xml").getStatus());
    }

    @Test
    public void testGlobalLayerGroupReadOnly() throws Exception {
        this.loginAsSf();
        Document dom = this.getAsDOM("/rest/layergroups.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("layerGroup").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"global", (String)"//layerGroup/name", (Document)dom);
        dom = this.getAsDOM("/rest/layergroups/global.xml");
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
        String xml = "<layerGroup><styles><style>polygon</style><style>line</style></styles></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/global", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        xml = "<layerGroup><name>newLayerGroup</name><layers><layer>Ponds</layer><layer>Forests</layer></layers><styles><style>polygon</style><style>point</style></styles></layerGroup>";
        response = this.postAsServletResponse("/rest/layergroups", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testLocalLayerGroupHidden() throws Exception {
        this.loginAsSf();
        Document dom = this.getAsDOM("/rest/layergroups.xml");
        this.print(dom);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("layerGroup").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"global", (String)"//layerGroup/name", (Document)dom);
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/cite/layergroups.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.getAsServletResponse("/rest/workspaces/cite/layergroups.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/layergroups.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("layerGroup").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"global", (String)"//layerGroup/name", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/sf/layergroups.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("layerGroup").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"local", (String)"//layerGroup/name", (Document)dom);
    }

    @Test
    public void testGlobalStyleReadOnly() throws Exception {
        this.loginAsSf();
        Document dom = this.getAsDOM("/rest/styles.xml");
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'sf_style']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'cite_style']", (Document)dom);
        dom = this.getAsDOM("/rest/styles/point.xml");
        Assert.assertEquals((Object)"style", (Object)dom.getDocumentElement().getNodeName());
        String xml = "<style><filename>foo.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/point", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        xml = "<style><name>foo</name><filename>foo.sld</filename></style>";
        response = this.postAsServletResponse("/rest/styles", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testLocalStyleHidden() throws Exception {
        this.loginAsCite();
        Document dom = this.getAsDOM("/rest/styles.xml");
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'cite_style']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'sf_style']", (Document)dom);
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/styles.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.loginAsSf();
        dom = this.getAsDOM("/rest/styles.xml");
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'cite_style']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//style/name[text() = 'sf_style']", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/sf/styles.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("style").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"sf_style", (String)"//style/name", (Document)dom);
    }
}

