/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class SettingsControllerTest
extends CatalogRESTTestSupport {
    protected GeoServer geoServer;

    @Before
    public void init() {
        this.geoServer = this.getGeoServer();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getJAI().setAllowInterpolation(false);
        global.getJAI().setMemoryThreshold(0.75);
        global.getJAI().setTilePriority(5);
        global.getCoverageAccess().setQueueType(CoverageAccessInfo.QueueType.UNBOUNDED);
        this.getGeoServer().save(global);
        this.revertSettings(null);
        this.revertSettings("sf");
    }

    public void initContact() {
        ContactInfoImpl contactInfo = new ContactInfoImpl();
        contactInfo.setAddress("1600 Pennsylvania Avenue");
        contactInfo.setAddressCity("Washington");
        contactInfo.setAddressPostalCode("20001");
        contactInfo.setAddressCountry("United States");
        contactInfo.setAddressState("DC");
        contactInfo.setAddressDeliveryPoint("The White House");
        contactInfo.setAddressElectronicMailAddress("info@whitehouse.gov");
        GeoServerInfo geoServerInfo = this.geoServer.getGlobal();
        SettingsInfo settingsInfo = geoServerInfo.getSettings();
        settingsInfo.setContact((ContactInfo)contactInfo);
        this.geoServer.save(geoServerInfo);
    }

    @After
    public void reset() throws Exception {
        LocalWorkspace.remove();
    }

    @Test
    public void testGetContactAsJSON() throws Exception {
        this.initContact();
        JSON json = this.getAsJSON("/rest/settings/contact.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject contactInfo = jsonObject.getJSONObject("contact");
        Assert.assertNotNull((Object)contactInfo);
        Assert.assertEquals((Object)"United States", (Object)contactInfo.get("addressCountry"));
        Assert.assertEquals((Object)"1600 Pennsylvania Avenue", (Object)contactInfo.get("address"));
        Assert.assertEquals((Object)"Washington", (Object)contactInfo.get("addressCity"));
        Assert.assertEquals((Object)"DC", (Object)contactInfo.get("addressState"));
        Assert.assertEquals((Object)"20001", (Object)contactInfo.get("addressPostalCode").toString());
        Assert.assertEquals((Object)"The White House", (Object)contactInfo.get("addressDeliveryPoint").toString());
        Assert.assertEquals((Object)"info@whitehouse.gov", (Object)contactInfo.get("addressElectronicMailAddress").toString());
    }

    @Test
    public void testGetContactAsXML() throws Exception {
        this.initContact();
        Document dom = this.getAsDOM("/rest/settings/contact.xml");
        Assert.assertEquals((Object)"contact", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"United States", (String)"/contact/addressCountry", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Washington", (String)"/contact/addressCity", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1600 Pennsylvania Avenue", (String)"/contact/address", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"DC", (String)"/contact/addressState", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20001", (String)"/contact/addressPostalCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"The White House", (String)"/contact/addressDeliveryPoint", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"info@whitehouse.gov", (String)"/contact/addressElectronicMailAddress", (Document)dom);
    }

    @Test
    public void testGetContactAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/settings/contact.html", 200);
    }

    @Test
    public void testPutContactAsJSON() throws Exception {
        this.initContact();
        String inputJson = "{'contact':{    'id':'contact',    'address':'500 Market Street',    'addressCity':'Philadelphia',    'addressCountry':'United States',    'addressPostalCode':'19106',    'addressState':'PA',    'addressDeliveryPoint':'The White House',    'addressElectronicMailAddress':'info@whitehouse.gov'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/settings/contact", inputJson, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/settings/contact.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject contactInfo = jsonObject.getJSONObject("contact");
        Assert.assertEquals((Object)"United States", (Object)contactInfo.get("addressCountry"));
        Assert.assertEquals((Object)"500 Market Street", (Object)contactInfo.get("address"));
        Assert.assertEquals((Object)"Philadelphia", (Object)contactInfo.get("addressCity"));
        Assert.assertEquals((Object)"PA", (Object)contactInfo.get("addressState"));
        Assert.assertEquals((Object)"19106", (Object)contactInfo.get("addressPostalCode").toString());
        Assert.assertEquals((Object)"The White House", (Object)contactInfo.get("addressDeliveryPoint").toString());
        Assert.assertEquals((Object)"info@whitehouse.gov", (Object)contactInfo.get("addressElectronicMailAddress").toString());
    }

    @Test
    public void testPutContactAsXML() throws Exception {
        this.initContact();
        String xml = "<contact> <address>1600 Pennsylvania Avenue</address><addressCity>Washington</addressCity><addressCountry>United States</addressCountry><addressPostalCode>20001</addressPostalCode><addressDeliveryPoint>The White House</addressDeliveryPoint><addressElectronicMailAddress>info@whitehouse.gov</addressElectronicMailAddress><addressState>DC</addressState><addressType>Avenue</addressType><contactEmail>chief.geographer@mail.com</contactEmail><contactOrganization>GeoServer</contactOrganization><contactPerson>ContactPerson</contactPerson><contactPosition>Chief Geographer</contactPosition> </contact>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/settings/contact", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/settings/contact.xml");
        Assert.assertEquals((Object)"contact", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"United States", (String)"/contact/addressCountry", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1600 Pennsylvania Avenue", (String)"/contact/address", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Washington", (String)"/contact/addressCity", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"DC", (String)"/contact/addressState", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20001", (String)"/contact/addressPostalCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Chief Geographer", (String)"/contact/contactPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ContactPerson", (String)"/contact/contactPerson", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"The White House", (String)"/contact/addressDeliveryPoint", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"chief.geographer@mail.com", (String)"/contact/addressElectronicMailAddress", (Document)dom);
    }

    @Test
    public void testGetGlobalAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/settings.json");
        this.print(json);
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject global = jsonObject.getJSONObject("global");
        Assert.assertNotNull((Object)global);
        JSONObject settings = global.getJSONObject("settings");
        JSONObject contact = settings.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((Object)"Andrea Aime", (Object)contact.get("contactPerson"));
        Assert.assertEquals((Object)"UTF-8", (Object)settings.get("charset"));
        Assert.assertEquals((Object)"8", (Object)settings.get("numDecimals").toString().trim());
        Assert.assertEquals((Object)"http://geoserver.org", (Object)settings.get("onlineResource"));
        JSONObject jaiInfo = global.getJSONObject("jai");
        Assert.assertNotNull((Object)jaiInfo);
        Assert.assertEquals((Object)"false", (Object)jaiInfo.get("allowInterpolation").toString().trim());
        Assert.assertEquals((Object)"0.75", (Object)jaiInfo.get("memoryThreshold").toString().trim());
        Assert.assertEquals((Object)"5", (Object)jaiInfo.get("tilePriority").toString().trim());
        JSONObject covInfo = global.getJSONObject("coverageAccess");
        Assert.assertEquals((Object)"UNBOUNDED", (Object)covInfo.get("queueType"));
    }

    @Test
    public void testGetGlobalAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/settings.xml");
        Assert.assertEquals((Object)"global", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"UTF-8", (String)"/global/settings/charset", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"8", (String)"/global/settings/numDecimals", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)"/global/settings/onlineResource", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Andrea Aime", (String)"/global/settings/contact/contactPerson", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/global/jai/allowInterpolation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.75", (String)"/global/jai/memoryThreshold", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"UNBOUNDED", (String)"/global/coverageAccess/queueType", (Document)dom);
    }

    @Test
    public void testPutGlobalAsJSON() throws Exception {
        String inputJson = "{'global': {'settings':   {'contact':     {'contactPerson': 'Claudius Ptolomaeus'},'charset': 'UTF-8','numDecimals': '10','onlineResource': 'http://geoserver2.org','verbose': 'false','verboseExceptions': 'false'},'jai':   {'allowInterpolation': 'false','recycling': 'true','tilePriority': '5','tileThreads': '7','memoryCapacity': '0.5','memoryThreshold': '0.75','imageIOCache': 'false','pngAcceleration': 'true','jpegAcceleration': 'true','allowNativeMosaic': 'false'},'coverageAccess':   {'maxPoolSize': '5','corePoolSize': '5','keepAliveTime': '30000','queueType': 'UNBOUNDED','imageIOCacheThreshold': '10240'},'updateSequence': '0','featureTypeCacheSize': '0','globalServices': 'true','xmlPostRequestLogBufferSize': '2048'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/settings/", inputJson, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject global = jsonObject.getJSONObject("global");
        Assert.assertNotNull((Object)global);
        Assert.assertEquals((Object)"true", (Object)global.get("globalServices").toString().trim());
        Assert.assertEquals((Object)"2048", (Object)global.get("xmlPostRequestLogBufferSize").toString().trim());
        JSONObject settings = global.getJSONObject("settings");
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)"UTF-8", (Object)settings.get("charset"));
        Assert.assertEquals((Object)"10", (Object)settings.get("numDecimals").toString().trim());
        Assert.assertEquals((Object)"http://geoserver2.org", (Object)settings.get("onlineResource"));
        JSONObject contact = settings.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((Object)"Claudius Ptolomaeus", (Object)contact.get("contactPerson"));
        JSONObject jaiInfo = global.getJSONObject("jai");
        Assert.assertNotNull((Object)jaiInfo);
        Assert.assertEquals((Object)"false", (Object)jaiInfo.get("allowInterpolation").toString().trim());
        Assert.assertEquals((Object)"0.75", (Object)jaiInfo.get("memoryThreshold").toString().trim());
        JSONObject covInfo = global.getJSONObject("coverageAccess");
        Assert.assertEquals((Object)"UNBOUNDED", (Object)covInfo.get("queueType"));
    }

    @Test
    public void testGetGlobalAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/settings.html", 200);
    }

    @Test
    public void testPutGlobalAsXML() throws Exception {
        String xml = "<global><settings><charset>UTF-8</charset><numDecimals>10</numDecimals><onlineResource>http://geoserver.org</onlineResource><verbose>false</verbose><verboseExceptions>false</verboseExceptions><contact><contactPerson>Justin Deoliveira</contactPerson></contact></settings><jai><allowInterpolation>true</allowInterpolation><recycling>false</recycling><tilePriority>5</tilePriority><tileThreads>7</tileThreads><memoryCapacity>0.5</memoryCapacity><memoryThreshold>0.85</memoryThreshold><imageIOCache>false</imageIOCache><pngAcceleration>true</pngAcceleration><jpegAcceleration>true</jpegAcceleration><allowNativeMosaic>false</allowNativeMosaic></jai><coverageAccess><maxPoolSize>10</maxPoolSize><corePoolSize>5</corePoolSize><keepAliveTime>30000</keepAliveTime><queueType>UNBOUNDED</queueType><imageIOCacheThreshold>10240</imageIOCacheThreshold></coverageAccess><updateSequence>97</updateSequence><featureTypeCacheSize>0</featureTypeCacheSize><globalServices>false</globalServices><xmlPostRequestLogBufferSize>2048</xmlPostRequestLogBufferSize></global>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/settings/", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/settings.xml");
        Assert.assertEquals((Object)"global", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/global/globalServices", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2048", (String)"/global/xmlPostRequestLogBufferSize", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"UTF-8", (String)"/global/settings/charset", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)"/global/settings/numDecimals", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)"/global/settings/onlineResource", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Justin Deoliveira", (String)"/global/settings/contact/contactPerson", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/global/jai/allowInterpolation", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.85", (String)"/global/jai/memoryThreshold", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"UNBOUNDED", (String)"/global/coverageAccess/queueType", (Document)dom);
    }

    @Test
    public void testGetLocalAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject settings = jsonObject.getJSONObject("settings");
        Assert.assertNotNull((Object)settings);
        JSONObject workspace = settings.getJSONObject("workspace");
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertEquals((Object)"UTF-8", (Object)settings.get("charset"));
        Assert.assertEquals((Object)"8", (Object)settings.get("numDecimals").toString().trim());
        Assert.assertEquals((Object)"false", (Object)settings.get("verbose").toString().trim());
        Assert.assertEquals((Object)"false", (Object)settings.get("verboseExceptions").toString().trim());
        JSONObject contact = settings.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((Object)"Andrea Aime", (Object)contact.get("contactPerson"));
    }

    @Test
    public void testGetLocalAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"settings", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/settings/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"UTF-8", (String)"/settings/charset", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"8", (String)"/settings/numDecimals", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/settings/verbose", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/settings/verboseExceptions", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Andrea Aime", (String)"/settings/contact/contactPerson", (Document)dom);
    }

    @Test
    public void testGetLocalAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/settings.html", 200);
    }

    @Test
    public void testCreateLocalAsJSON() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        geoServer.remove(geoServer.getSettings(geoServer.getCatalog().getWorkspaceByName("sf")));
        String json = "{'settings':{'workspace':{'name':'sf'},'contact':{'addressCity':'Alexandria','addressCountry':'Egypt','addressType':'Work','contactEmail':'claudius.ptolomaeus@gmail.com','contactOrganization':'The ancient geographes INC','contactPerson':'Claudius Ptolomaeus','contactPosition':'Chief geographer'},'charset':'UTF-8','numDecimals':10,'onlineResource':'http://geoserver.org','proxyBaseUrl':'http://proxy.url','verbose':false,'verboseExceptions':'true'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/settings", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject settings = jsonObject.getJSONObject("settings");
        Assert.assertNotNull((Object)settings);
        JSONObject workspace = settings.getJSONObject("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertEquals((Object)"10", (Object)settings.get("numDecimals").toString().trim());
        Assert.assertEquals((Object)"http://geoserver.org", (Object)settings.get("onlineResource"));
        Assert.assertEquals((Object)"http://proxy.url", (Object)settings.get("proxyBaseUrl"));
        JSONObject contact = settings.getJSONObject("contact");
        Assert.assertEquals((Object)"Claudius Ptolomaeus", (Object)contact.get("contactPerson"));
        Assert.assertEquals((Object)"The ancient geographes INC", (Object)contact.get("contactOrganization"));
        Assert.assertEquals((Object)"Work", (Object)contact.get("addressType"));
        Assert.assertEquals((Object)"claudius.ptolomaeus@gmail.com", (Object)contact.get("contactEmail"));
    }

    @Test
    public void testCreateLocalAsXML() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        geoServer.remove(geoServer.getSettings(geoServer.getCatalog().getWorkspaceByName("sf")));
        String xml = "<settings><workspace><name>sf</name></workspace><contact><addressCity>Alexandria</addressCity><addressCountry>Egypt</addressCountry><addressType>Work</addressType><contactEmail>claudius.ptolomaeus@gmail.com</contactEmail><contactOrganization>The ancient geographes INC</contactOrganization><contactPerson>Claudius Ptolomaeus</contactPerson><contactPosition>Chief geographer</contactPosition></contact><charset>UTF-8</charset><numDecimals>8</numDecimals><onlineResource>http://geoserver.org</onlineResource><proxyBaseUrl>http://proxy.url</proxyBaseUrl><verbose>false</verbose><verboseExceptions>false</verboseExceptions></settings>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"settings", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/settings/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/settings/verbose", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/settings/verboseExceptions", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)"/settings/onlineResource", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://proxy.url", (String)"/settings/proxyBaseUrl", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Claudius Ptolomaeus", (String)"/settings/contact/contactPerson", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"claudius.ptolomaeus@gmail.com", (String)"/settings/contact/contactEmail", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Chief geographer", (String)"/settings/contact/contactPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"The ancient geographes INC", (String)"/settings/contact/contactOrganization", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Egypt", (String)"/settings/contact/addressCountry", (Document)dom);
    }

    @Test
    public void testCreateLocalAlreadyExists() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        geoServer.remove(geoServer.getSettings(geoServer.getCatalog().getWorkspaceByName("sf")));
        String xml = "<settings><workspace><name>sf</name></workspace><contact><addressCity>Alexandria</addressCity><addressCountry>Egypt</addressCountry><addressType>Work</addressType><contactEmail>claudius.ptolomaeus@gmail.com</contactEmail><contactOrganization>The ancient geographes INC</contactOrganization><contactPerson>Claudius Ptolomaeus</contactPerson><contactPosition>Chief geographer</contactPosition></contact><charset>UTF-8</charset><numDecimals>8</numDecimals><onlineResource>http://geoserver.org</onlineResource><proxyBaseUrl>http://proxy.url</proxyBaseUrl><verbose>false</verbose><verboseExceptions>false</verboseExceptions></settings>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response = this.postAsServletResponse("/rest/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testPutLocalAsJSON() throws Exception {
        String inputJson = "{'settings':{'workspace':{'name':'sf'},'contact':{'addressCity':'Cairo','addressCountry':'Egypt','addressType':'Work','contactEmail':'claudius.ptolomaeus@gmail.com','contactOrganization':'The ancient geographes INC','contactPerson':'Claudius Ptolomaeus','contactPosition':'Chief geographer'},'charset':'UTF-8','numDecimals':8,'onlineResource':'http://geoserver2.org','proxyBaseUrl':'http://proxy2.url','verbose':true,'verboseExceptions':'true'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/settings", inputJson, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject settings = jsonObject.getJSONObject("settings");
        Assert.assertNotNull((Object)settings);
        JSONObject workspace = settings.getJSONObject("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertEquals((Object)"8", (Object)settings.get("numDecimals").toString().trim());
        Assert.assertEquals((Object)"http://geoserver2.org", (Object)settings.get("onlineResource"));
        Assert.assertEquals((Object)"http://proxy2.url", (Object)settings.get("proxyBaseUrl"));
        Assert.assertEquals((Object)"true", (Object)settings.get("verbose").toString().trim());
        Assert.assertEquals((Object)"true", (Object)settings.get("verboseExceptions").toString().trim());
        JSONObject contact = settings.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((Object)"Claudius Ptolomaeus", (Object)contact.get("contactPerson"));
        Assert.assertEquals((Object)"Cairo", (Object)contact.get("addressCity"));
    }

    @Test
    public void testPutLocalAsXML() throws Exception {
        String xml = "<settings><workspace><name>sf</name></workspace><contact><addressCity>Cairo</addressCity><addressCountry>Egypt</addressCountry><addressType>Work</addressType><contactEmail>claudius.ptolomaeus@gmail.com</contactEmail><contactOrganization>The ancient geographes INC</contactOrganization><contactPerson>Claudius Ptolomaeus</contactPerson><contactPosition>Chief geographer</contactPosition></contact><charset>UTF-8</charset><numDecimals>10</numDecimals><onlineResource>http://geoserver2.org</onlineResource><proxyBaseUrl>http://proxy2.url</proxyBaseUrl><verbose>true</verbose><verboseExceptions>true</verboseExceptions></settings>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"settings", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/settings/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/settings/verbose", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/settings/verboseExceptions", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver2.org", (String)"/settings/onlineResource", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://proxy2.url", (String)"/settings/proxyBaseUrl", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Claudius Ptolomaeus", (String)"/settings/contact/contactPerson", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"claudius.ptolomaeus@gmail.com", (String)"/settings/contact/contactEmail", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Chief geographer", (String)"/settings/contact/contactPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"The ancient geographes INC", (String)"/settings/contact/contactOrganization", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Cairo", (String)"/settings/contact/addressCity", (Document)dom);
    }

    @Test
    public void testDeleteLocal() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/settings").getStatus());
        json = this.getAsJSON("/rest/workspaces/sf/settings.json");
        JSONObject deletedJson = (JSONObject)json;
        Assert.assertNull((Object)deletedJson.get("workspace"));
    }
}

