/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.util.ZipTestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IOUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder(new File("target"));

    @Test
    public void testInflateBadEntryName() throws IOException {
        File destDir = this.temp.newFolder("d1").toPath().toFile();
        destDir.mkdirs();
        Resource directory = new GeoServerResourceLoader(destDir).get("");
        File file = ZipTestUtil.initZipSlipFile((File)this.temp.newFile("d1.zip"));
        try {
            IOUtils.inflate((ZipFile)new ZipFile(file), (Resource)directory, null, null, null, null, (boolean)false, (boolean)false);
            Assert.fail((String)"Expected decompression to fail");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Entry is outside of the target directory"));
        }
    }
}

