/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.context.SecurityContextHolder;

public class EnviromentInjectionCallbackTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void logout() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testNoUser() throws Exception {
        MockHttpServletResponse r = this.getAsServletResponse("/rest/gsuser");
        Assert.assertEquals((long)200L, (long)r.getStatus());
        Assert.assertTrue((boolean)r.getContentType().startsWith("text/plain"));
        Assert.assertEquals((Object)"USER_NOT_FOUND", (Object)r.getContentAsString());
    }

    @Test
    public void testUser() throws Exception {
        this.login("testUser", "testPassword", new String[0]);
        MockHttpServletResponse r = this.getAsServletResponse("/rest/gsuser");
        Assert.assertEquals((long)200L, (long)r.getStatus());
        String contentType = r.getContentType();
        Assert.assertTrue((boolean)contentType.startsWith("text/plain"));
        Assert.assertEquals((Object)"testUser", (Object)r.getContentAsString());
    }
}

