/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.geoserver.ows.kvp.TimeKvpParser;
import org.geoserver.ows.kvp.TimeParser;
import org.geotools.util.DateRange;

public class TimeKvpParserTest
extends TestCase {
    private static final String PERIOD = "2007-01-01T12Z/2007-01-31T12Z/P1DT12H";
    private static final String CONTINUOUS_PERIOD = "2007-01-01T12Z/2007-01-31T12Z";
    private static final String CONTINUOUS_PERIOD_TIME_DURATION = "2007-01-01T12Z/P1DT1H";
    private static final String CONTINUOUS_PERIOD_INVALID_DURATION = "P1D/P1DT1H";
    private static final String CONTINUOUS_RELATIVE_PERIOD_H = "PT2H/PRESENT";
    private static final String CONTINUOUS_RELATIVE_PERIOD_D = "P10D/PRESENT";
    private static final String CONTINUOUS_RELATIVE_PERIOD_W = "P2W/PRESENT";
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH'Z'");

    public void testReducedAccuracyYear() throws Exception {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).setTimeZone(TimeParser.UTC_TZ);
        DateRange year = (DateRange)TimeParser.getFuzzyDate((String)"2000");
        c.clear();
        c.set(1, 2000);
        TimeKvpParserTest.assertRangeStarts(year, c.getTime());
        c.set(1, 2001);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(year, c.getTime());
        year = (DateRange)TimeParser.getFuzzyDate((String)"2001");
        c.clear();
        c.set(1, 2001);
        TimeKvpParserTest.assertRangeStarts(year, c.getTime());
        c.set(1, 2002);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(year, c.getTime());
        year = (DateRange)TimeParser.getFuzzyDate((String)"-6052");
        c.clear();
        c.set(0, 0);
        c.set(1, 6053);
        TimeKvpParserTest.assertRangeStarts(year, c.getTime());
        c.set(1, 6052);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(year, c.getTime());
    }

    public void testReducedAccuracyHour() throws Exception {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).setTimeZone(TimeParser.UTC_TZ);
        c.clear();
        DateRange hour = (DateRange)TimeParser.getFuzzyDate((String)"2000-04-04T12Z");
        c.set(1, 2000);
        c.set(2, 3);
        c.set(5, 4);
        c.set(11, 12);
        TimeKvpParserTest.assertRangeStarts(hour, c.getTime());
        ((Calendar)c).add(11, 1);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(hour, c.getTime());
        hour = (DateRange)TimeParser.getFuzzyDate((String)"2005-12-31T23Z");
        c.clear();
        c.set(1, 2005);
        c.set(2, 11);
        c.set(5, 31);
        c.set(11, 23);
        TimeKvpParserTest.assertRangeStarts(hour, c.getTime());
        ((Calendar)c).add(11, 1);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(hour, c.getTime());
        hour = (DateRange)TimeParser.getFuzzyDate((String)"-25-06-08T17Z");
        c.clear();
        c.set(0, 0);
        c.set(1, 26);
        c.set(2, 5);
        c.set(5, 8);
        c.set(11, 17);
        TimeKvpParserTest.assertRangeStarts(hour, c.getTime());
        ((Calendar)c).add(11, 1);
        ((Calendar)c).add(14, -1);
        TimeKvpParserTest.assertRangeEnds(hour, c.getTime());
    }

    public void testReducedAccuracyMilliseconds() throws Exception {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).setTimeZone(TimeParser.UTC_TZ);
        c.clear();
        Date instant = (Date)TimeParser.getFuzzyDate((String)"2000-04-04T12:00:00.000Z");
        c.set(1, 2000);
        c.set(2, 3);
        c.set(5, 4);
        c.set(11, 12);
        TimeKvpParserTest.assertEquals((Object)instant, (Object)c.getTime());
        instant = (Date)TimeParser.getFuzzyDate((String)"2005-12-31T23:59:60.000Z");
        c.clear();
        c.set(1, 2005);
        c.set(2, 11);
        c.set(5, 31);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 60);
        TimeKvpParserTest.assertEquals((Object)instant, (Object)c.getTime());
        instant = (Date)TimeParser.getFuzzyDate((String)"-25-06-08T17:15:00.123Z");
        c.clear();
        c.set(0, 0);
        c.set(1, 26);
        c.set(2, 5);
        c.set(5, 8);
        c.set(11, 17);
        c.set(12, 15);
        c.set(14, 123);
        TimeKvpParserTest.assertEquals((Object)instant, (Object)c.getTime());
    }

    public void testPeriod() throws ParseException {
        long millisInDay = 86400000L;
        TimeKvpParserTest.assertEquals((long)86400000L, (long)TimeParser.parsePeriod((String)"P1D"));
        TimeKvpParserTest.assertEquals((long)259200000L, (long)TimeParser.parsePeriod((String)"P3D"));
        TimeKvpParserTest.assertEquals((long)1209600000L, (long)TimeParser.parsePeriod((String)"P2W"));
        TimeKvpParserTest.assertEquals((long)691200000L, (long)TimeParser.parsePeriod((String)"P1W1D"));
        TimeKvpParserTest.assertEquals((long)86400000L, (long)TimeParser.parsePeriod((String)"PT24H"));
        TimeKvpParserTest.assertEquals((long)Math.round(1.296E8), (long)TimeParser.parsePeriod((String)"P1.5D"));
    }

    public void testInterval() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse(PERIOD));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertInstant(format.parse("2007-01-01T12Z"), l.get(0));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-03T00Z"), l.get(1));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-04T12Z"), l.get(2));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-06T00Z"), l.get(3));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-07T12Z"), l.get(4));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-09T00Z"), l.get(5));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-10T12Z"), l.get(6));
        TimeKvpParserTest.assertInstant(format.parse("2007-01-12T00Z"), l.get(7));
        l = new ArrayList((Collection)timeKvpParser.parse("2007-01-01T12Z/2007-01-01T13Z/PT10M"));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertEquals((int)12, (int)l.size());
        TimeKvpParserTest.assertInstant(format.parse("2007-01-01T12Z"), l.get(0));
    }

    public void testContinuousInterval() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse(CONTINUOUS_PERIOD));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        DateRange range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-01T12Z"), (Object)range.getMinValue());
        Date end = format.parse("2007-01-31T13Z");
        end.setTime(end.getTime() - 1L);
        TimeKvpParserTest.assertEquals((Object)end, (Object)range.getMaxValue());
    }

    public void testContinuousIntervalDuration() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse(CONTINUOUS_PERIOD_TIME_DURATION));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        DateRange range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-01T12Z"), (Object)range.getMinValue());
        Date end = format.parse("2007-01-02T13Z");
        TimeKvpParserTest.assertEquals((Object)end, (Object)range.getMaxValue());
    }

    public void testInvalidDualDuration() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        boolean exception = false;
        try {
            timeKvpParser.parse(CONTINUOUS_PERIOD_INVALID_DURATION);
            TimeKvpParserTest.fail((String)"No exception thrown for invalid duration");
        }
        catch (ParseException ex) {
            TimeKvpParserTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid time period"));
        }
    }

    public void testContinuousRelativeInterval() throws ParseException {
        ArrayList l;
        Calendar check;
        Calendar now;
        int millisInDay = 86400000;
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        do {
            now = Calendar.getInstance();
            l = new ArrayList((Collection)timeKvpParser.parse(CONTINUOUS_RELATIVE_PERIOD_H));
            check = Calendar.getInstance();
            now.set(14, 0);
            check.set(14, 0);
        } while (!now.equals(check));
        Calendar back = (Calendar)now.clone();
        back.add(10, -2);
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        DateRange range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)back.getTime(), (Object)range.getMinValue());
        TimeKvpParserTest.assertEquals((Object)now.getTime(), (Object)range.getMaxValue());
        do {
            now = Calendar.getInstance();
            l = new ArrayList((Collection)timeKvpParser.parse(CONTINUOUS_RELATIVE_PERIOD_D));
            check = Calendar.getInstance();
            now.set(14, 0);
            check.set(14, 0);
        } while (!now.equals(check));
        back = (Calendar)now.clone();
        back.add(14, -864000000);
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)back.getTime(), (Object)range.getMinValue());
        TimeKvpParserTest.assertEquals((Object)now.getTime(), (Object)range.getMaxValue());
        do {
            now = Calendar.getInstance();
            l = new ArrayList((Collection)timeKvpParser.parse(CONTINUOUS_RELATIVE_PERIOD_W));
            check = Calendar.getInstance();
            now.set(14, 0);
            check.set(14, 0);
        } while (!now.equals(check));
        back = (Calendar)now.clone();
        back.add(14, -1209600000);
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)back.getTime(), (Object)range.getMinValue());
        TimeKvpParserTest.assertEquals((Object)now.getTime(), (Object)range.getMaxValue());
    }

    public void testMixedValues() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse("2007-01-01T12Z/2007-01-31T12Z,2007-02-01T12Z"));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        DateRange range = (DateRange)l.get(0);
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-01T12Z"), (Object)range.getMinValue());
        Date end = format.parse("2007-01-31T13Z");
        end.setTime(end.getTime() - 1L);
        TimeKvpParserTest.assertEquals((Object)end, (Object)range.getMaxValue());
        TimeKvpParserTest.assertRange((DateRange)l.get(1), format.parse("2007-02-01T12Z"), format.parse("2007-02-01T13Z"));
    }

    public void testInclusions() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse("2007-01-01T12Z/2007-01-31T12Z,2007-01-29T12Z,2007-01-12T12Z,2007-01-17T12Z,2007-01-01T12Z/2007-01-15T12Z"));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        TimeKvpParserTest.assertTrue((boolean)(l.get(0) instanceof DateRange));
        DateRange range = (DateRange)l.get(0);
        TimeKvpParserTest.assertRange(range, format.parse("2007-01-01T12Z"), format.parse("2007-01-31T13Z"));
    }

    public void testOrderedValues() throws Exception {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        ArrayList l = new ArrayList((Collection)timeKvpParser.parse("2007-01-29T12Z,2007-01-12T12Z,2007-01-17T12Z,2007-01-01T12Z,2007-01-05T12Z"));
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertTrue((l.size() == 5 ? 1 : 0) != 0);
        TimeKvpParserTest.assertRange((DateRange)l.get(0), format.parse("2007-01-01T12Z"), format.parse("2007-01-01T13Z"));
        TimeKvpParserTest.assertRange((DateRange)l.get(1), format.parse("2007-01-05T12Z"), format.parse("2007-01-05T13Z"));
        TimeKvpParserTest.assertRange((DateRange)l.get(2), format.parse("2007-01-12T12Z"), format.parse("2007-01-12T13Z"));
        TimeKvpParserTest.assertRange((DateRange)l.get(3), format.parse("2007-01-17T12Z"), format.parse("2007-01-17T13Z"));
        TimeKvpParserTest.assertRange((DateRange)l.get(4), format.parse("2007-01-29T12Z"), format.parse("2007-01-29T13Z"));
    }

    public void testNegativeYearCompliance() throws Exception {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        DateRange date = (DateRange)((List)timeKvpParser.parse("01-06-01")).get(0);
        cal.setTime(date.getMinValue());
        TimeKvpParserTest.assertEquals((int)1, (int)cal.get(1));
        TimeKvpParserTest.assertEquals((int)1, (int)cal.get(0));
        date = (DateRange)((List)timeKvpParser.parse("00-06-01")).get(0);
        cal.setTime(date.getMinValue());
        TimeKvpParserTest.assertEquals((int)1, (int)cal.get(1));
        TimeKvpParserTest.assertEquals((int)0, (int)cal.get(0));
        date = (DateRange)((List)timeKvpParser.parse("-01-06-01")).get(0);
        cal.setTime(date.getMinValue());
        TimeKvpParserTest.assertEquals((int)2, (int)cal.get(1));
        TimeKvpParserTest.assertEquals((int)0, (int)cal.get(0));
        date = (DateRange)((List)timeKvpParser.parse("-18000-06-01")).get(0);
        cal.setTime(date.getMinValue());
        TimeKvpParserTest.assertEquals((int)18001, (int)cal.get(1));
        TimeKvpParserTest.assertEquals((int)0, (int)cal.get(0));
    }

    private static void assertInstant(Date expected, Object object) {
        if (object instanceof DateRange) {
            TimeKvpParserTest.assertEquals((String)(object + " Should start at"), (Object)expected, (Object)((DateRange)object).getMinValue());
            TimeKvpParserTest.assertEquals((String)(object + " Should end at"), (Object)expected, (Object)((DateRange)object).getMaxValue());
        } else if (object instanceof Date) {
            TimeKvpParserTest.assertEquals((Object)expected, (Object)object);
        } else {
            TimeKvpParserTest.fail((String)("Should have a DateRange: " + object));
        }
    }

    private static void assertRange(DateRange range, Date start, Date end) {
        TimeKvpParserTest.assertRangeStarts(range, start);
        TimeKvpParserTest.assertRangeEnds(range, new Date(end.getTime() - 1L));
    }

    public static void assertRangeLength(DateRange range, long expectedLength) {
        if (range.getMinValue() == null) {
            TimeKvpParserTest.fail((String)("Expected finite range, saw: " + range));
        }
        if (range.getMaxValue() == null) {
            TimeKvpParserTest.fail((String)("Expected finite range, saw: " + range));
        }
        long min = range.getMinValue().getTime();
        long max = range.getMaxValue().getTime();
        TimeKvpParserTest.assertEquals((String)("Range " + range + " should have length"), (long)expectedLength, (long)(max - min));
    }

    public static void assertRangeStarts(DateRange range, Date expectedStart) {
        if (range.getMinValue() == null) {
            TimeKvpParserTest.fail((String)("Expected valid start date in range " + range));
        }
        TimeKvpParserTest.assertEquals((String)("Range " + range + " should have start"), (Object)expectedStart, (Object)range.getMinValue());
    }

    public static void assertRangeEnds(DateRange range, Date expectedEnd) {
        if (range.getMaxValue() == null) {
            TimeKvpParserTest.fail((String)("Expected valid end date in range " + range));
        }
        TimeKvpParserTest.assertEquals((String)("Range " + range + " should have end"), (Object)expectedEnd, (Object)range.getMaxValue());
    }

    static {
        format.setTimeZone(TimeParser.UTC_TZ);
    }
}

