/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.geoserver.ows.kvp.ElevationKvpParser;
import org.geotools.util.NumberRange;

public class ElevationKvpParserTest
extends TestCase {
    public void testPeriod() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("1/100/1"));
        ElevationKvpParserTest.assertTrue((boolean)(elements.get(0) instanceof Double));
        ElevationKvpParserTest.assertTrue((elements.size() == 100 ? 1 : 0) != 0);
        ElevationKvpParserTest.assertEquals((Object)1.0, (Object)((Double)elements.get(0)));
    }

    public void testMixed() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("5,3,4,1,2,8.9,1/9"));
        ElevationKvpParserTest.assertTrue((boolean)(elements.get(0) instanceof NumberRange));
        ElevationKvpParserTest.assertEquals((Object)1.0, (Object)((NumberRange)elements.get(0)).getMinimum());
        ElevationKvpParserTest.assertEquals((Object)9.0, (Object)((NumberRange)elements.get(0)).getMaximum());
    }

    public void testOutOfOrderSequence() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("5,3,4,1,2,8.9"));
        ElevationKvpParserTest.assertEquals((Object)1.0, elements.get(0));
        ElevationKvpParserTest.assertEquals((Object)2.0, elements.get(1));
        ElevationKvpParserTest.assertEquals((Object)3.0, elements.get(2));
        ElevationKvpParserTest.assertEquals((Object)4.0, elements.get(3));
        ElevationKvpParserTest.assertEquals((Object)5.0, elements.get(4));
        ElevationKvpParserTest.assertEquals((Object)8.9, elements.get(5));
    }

    public ElevationKvpParser testOrderedSequence() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("1,2,3,4,5,8.9"));
        ElevationKvpParserTest.assertEquals((Object)1.0, elements.get(0));
        ElevationKvpParserTest.assertEquals((Object)2.0, elements.get(1));
        ElevationKvpParserTest.assertEquals((Object)3.0, elements.get(2));
        ElevationKvpParserTest.assertEquals((Object)4.0, elements.get(3));
        ElevationKvpParserTest.assertEquals((Object)5.0, elements.get(4));
        ElevationKvpParserTest.assertEquals((Object)8.9, elements.get(5));
        return parser;
    }
}

