/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

public class TestDispatcherCallback
implements DispatcherCallback {
    public ThreadLocal<Status> dispatcherStatus = new ThreadLocal();

    public Request init(Request request) {
        this.dispatcherStatus.set(Status.INIT);
        return request;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        this.dispatcherStatus.set(Status.SERVICE_DISPATCHED);
        return service;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        this.dispatcherStatus.set(Status.OPERATION_DISPATCHED);
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        this.dispatcherStatus.set(Status.OPERATION_EXECUTED);
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        this.dispatcherStatus.set(Status.RESPONSE_DISPATCHED);
        return response;
    }

    public void finished(Request request) {
        this.dispatcherStatus.set(Status.FINISHED);
    }

    public static enum Status {
        INIT,
        SERVICE_DISPATCHED,
        OPERATION_DISPATCHED,
        OPERATION_EXECUTED,
        RESPONSE_DISPATCHED,
        FINISHED;

    }
}

