/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.DirectInvocationService;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.HelloWorld;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Message;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.TestDispatcherCallback;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;

public class DispatcherTest
extends TestCase {
    public void testReadContextAndPath() throws Exception {
        Dispatcher dispatcher = new Dispatcher();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        DispatcherTest.assertNull((Object)req.context);
        DispatcherTest.assertEquals((String)"hello", (String)req.path);
        request.setRequestURI("/geoserver/foo/hello");
        dispatcher.init(req);
        DispatcherTest.assertEquals((String)"foo", (String)req.context);
        DispatcherTest.assertEquals((String)"hello", (String)req.path);
        request.setRequestURI("/geoserver/foo/baz/hello/");
        dispatcher.init(req);
        DispatcherTest.assertEquals((String)"foo/baz", (String)req.context);
        DispatcherTest.assertEquals((String)"hello", (String)req.path);
    }

    public void testReadOpContext() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        Map map = Dispatcher.readOpContext((Request)req);
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/foobar/hello");
        request.setMethod("get");
        map = Dispatcher.readOpContext((Request)req);
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/foobar/hello/");
        request.setMethod("get");
        map = Dispatcher.readOpContext((Request)req);
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
    }

    public void testReadOpPost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String body = "<Hello service=\"hello\"/>";
        DelegatingServletInputStream input = new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(body.getBytes()));
        Dispatcher dispatcher = new Dispatcher();
        BufferedReader buffered = new BufferedReader(new InputStreamReader((InputStream)input));
        buffered.mark(2048);
        Map map = Dispatcher.readOpPost((BufferedReader)buffered);
        DispatcherTest.assertNotNull((Object)map);
        DispatcherTest.assertEquals((Object)"Hello", map.get("request"));
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
    }

    public void testParseKVP() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.addParameter("service", "hello");
        request.addParameter("request", "Hello");
        request.addParameter("message", "Hello world!");
        request.setQueryString("service=hello&request=hello&message=Hello World!");
        Request req = new Request();
        req.setHttpRequest((HttpServletRequest)request);
        dispatcher.parseKVP(req);
        Message message = (Message)dispatcher.parseRequestKVP(Message.class, req);
        DispatcherTest.assertEquals((Object)new Message("Hello world!"), (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParseXML() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\"/>";
        File file = File.createTempFile("geoserver", "req");
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(body.getBytes());
            output.flush();
            output.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            input.mark(8192);
            Request req = new Request();
            req.setInput(input);
            Object object = dispatcher.parseRequestXML(null, input, req);
            DispatcherTest.assertEquals((Object)new Message("Hello world!"), (Object)object);
        }
        finally {
            file.delete();
        }
    }

    public void testHelloOperationGet() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("service", "hello");
        request.addParameter("request", "Hello");
        request.addParameter("version", "1.0.0");
        request.addParameter("message", "Hello world!");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        dispatcher.callbacks.add(new AbstractDispatcherCallback(){

            public Object operationExecuted(Request request, Operation operation, Object result) {
                Operation op = ((Request)Dispatcher.REQUEST.get()).getOperation();
                TestCase.assertNotNull((Object)op);
                TestCase.assertTrue((boolean)(op.getService().getService() instanceof HelloWorld));
                TestCase.assertTrue((boolean)(op.getParameters()[0] instanceof Message));
                return result;
            }
        });
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
    }

    public void testHelloOperationPost() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }

            public ServletInputStream getInputStream() {
                final ServletInputStream stream = super.getInputStream();
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return stream.read();
                    }

                    public int available() {
                        return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                    }
                };
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        request.setRequestURI("http://localhost/geoserver/ows");
        request.setContentType("application/xml");
        request.setContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".getBytes("UTF-8"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
    }

    public void testHelloOperationMixed() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContextOnlyXml.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }

            public ServletInputStream getInputStream() {
                final ServletInputStream stream = super.getInputStream();
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return stream.read();
                    }

                    public int available() {
                        return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                    }
                };
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        request.setRequestURI("http://localhost/geoserver/ows");
        request.setContentType("application/xml");
        request.setContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".getBytes("UTF-8"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("strict", "true");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
    }

    public void testHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("httpErrorCodeException", 204);
    }

    public void testWrappedHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("wrappedHttpErrorCodeException", 204);
    }

    public void testBadRequestHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("badRequestHttpErrorCodeException", 400);
    }

    public void testHttpErrorCodeExceptionWithContentType() throws Exception {
        CodeExpectingHttpServletResponse rsp = this.assertHttpErrorCode("httpErrorCodeExceptionWithContentType", 200);
        DispatcherTest.assertEquals((String)"application/json", (String)rsp.getContentType());
    }

    private CodeExpectingHttpServletResponse assertHttpErrorCode(String requestType, int expectedCode) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        request.addParameter("service", "hello");
        request.addParameter("request", requestType);
        request.addParameter("version", "1.0.0");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((int)expectedCode, (int)response.getStatusCode());
        DispatcherTest.assertEquals((expectedCode >= 400 ? 1 : 0) != 0, (boolean)response.isError());
        return response;
    }

    public void testDirectInvocationService() throws Throwable {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        final AtomicBoolean invokeDirectCalled = new AtomicBoolean();
        DirectInvocationService serviceBean = new DirectInvocationService(){

            public Object invokeDirect(String operationName, Object[] parameters) throws IllegalArgumentException, Exception {
                invokeDirectCalled.set(true);
                if ("concat".equals(operationName)) {
                    String param1 = (String)parameters[0];
                    String param2 = (String)parameters[1];
                    return this.concat(param1, param2);
                }
                throw new IllegalArgumentException("Unknown operation name");
            }

            public String concat(String param1, String param2) {
                return param1 + param2;
            }
        };
        Service service = new Service("directCallService", (Object)serviceBean, new Version("1.0.0"), Collections.singletonList("concat"));
        Method method = serviceBean.getClass().getMethod("concat", String.class, String.class);
        Object[] parameters = new Object[]{"p1", "p2"};
        Operation opDescriptor = new Operation("concat", service, method, parameters);
        Object result = dispatcher.execute(new Request(), opDescriptor);
        DispatcherTest.assertEquals((Object)"p1p2", (Object)result);
        DispatcherTest.assertTrue((boolean)invokeDirectCalled.get());
    }

    public void testDispatchWithNamespace() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContextNamespace.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContentType("application/xml");
        request.setContent("<h:Hello service='hello' message='Hello world!' xmlns:h='http://hello.org' />".getBytes("UTF-8"));
        request.setRequestURI("http://localhost/geoserver/hello");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
        request.setContent("<h:Hello service='hello' message='Hello world!' xmlns:h='http://hello.org/v2' />".getBytes("UTF-8"));
        response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!:V2", (String)response.getContentAsString());
    }

    public MockHttpServletRequest setupRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        request.addParameter("service", "hello");
        request.addParameter("request", "Hello");
        request.addParameter("version", "1.0.0");
        request.addParameter("message", "Hello world!");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        return request;
    }

    public void testDispatcherCallback() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback = new TestDispatcherCallback();
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailInit() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            @Override
            public Request init(Request request) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.INIT);
                throw new RuntimeException("TestDispatcherCallbackFailInit");
            }
        };
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailServiceDispatched() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            @Override
            public Service serviceDispatched(Request request, Service service) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.SERVICE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailServiceDispatched");
            }
        };
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailOperationDispatched() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            @Override
            public Operation operationDispatched(Request request, Operation operation) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationDispatched");
            }
        };
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailOperationExecuted() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            @Override
            public Object operationExecuted(Request request, Operation operation, Object result) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_EXECUTED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationExecuted");
            }
        };
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailResponseDispatched() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            @Override
            public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.RESPONSE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailResponseDispatched");
            }
        };
        MockHttpServletRequest request = this.setupRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
        DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
    }

    public void testDispatcherCallbackFailFinished() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            final AtomicBoolean firedCallback = new AtomicBoolean(false);
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback(){

                @Override
                public void finished(Request request) {
                    firedCallback.set(true);
                    super.finished(request);
                }
            };
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public void finished(Request request) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.FINISHED);
                    throw new Error("TestDispatcherCallbackFailFinished");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
            DispatcherTest.assertTrue((boolean)firedCallback.get());
            DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            DispatcherTest.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    public void testErrorSavedOnRequestOnGenericException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        RuntimeException genericError = new RuntimeException("foo");
        dispatcher.exception((Throwable)genericError, null, req);
        DispatcherTest.assertEquals((String)"Exception did not get saved", (Object)genericError, (Object)req.error);
    }

    public void testErrorSavedOnRequestOnNon304ErrorCodeException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        HttpErrorCodeException genericError = new HttpErrorCodeException(500, "Internal Server Error");
        dispatcher.exception((Throwable)genericError, null, req);
        DispatcherTest.assertEquals((String)"Exception did not get saved", (Object)genericError, (Object)req.error);
    }

    public void testNoErrorOn304ErrorCodeException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        HttpErrorCodeException error = new HttpErrorCodeException(304, "Not Modified");
        dispatcher.exception((Throwable)error, null, req);
        DispatcherTest.assertNull((String)"Exception erroneously saved", (Object)req.error);
    }

    public void testDispatchXMLException() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContextNamespace.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContentType("application/xml");
        request.setContent("<h:Hello xmlns:h='http:/hello.org' />".getBytes("UTF-8"));
        request.setRequestURI("http://localhost/geoserver/hello");
        response = new MockHttpServletResponse();
        ModelAndView mov = dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertNull((Object)mov);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("Could not parse the XML"));
    }

    public void testDispatchKVPException() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext4.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        request.addParameter("request", "Hello");
        request.setRequestURI("http://localhost/geoserver/hello");
        request.setQueryString("message=Hello World!");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response = new MockHttpServletResponse();
        ModelAndView mov = dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertNull((Object)mov);
        DispatcherTest.assertTrue((boolean)response.getContentAsString().contains("Could not parse the KVP"));
    }

    public void testMultiPartFormUpload() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String xml = "<Hello service='hello' message='Hello world!' version='1.0.0' />";
        MimeMultipart body = new MimeMultipart();
        request.setContentType(body.getContentType());
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Disposition", "form-data; name=\"upload\"; filename=\"request.xml\"");
        headers.setHeader("Content-Type", "application/xml");
        body.addBodyPart((BodyPart)new MimeBodyPart(headers, xml.getBytes()));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        body.writeTo((OutputStream)bout);
        request.setContent(bout.toByteArray());
        MockHttpServletResponse response = new MockHttpServletResponse();
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
    }

    public void testMultiPartFormUploadWithBodyField() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String xml = "<Hello service='hello' message='Hello world!' version='1.0.0' />";
        MimeMultipart body = new MimeMultipart();
        request.setContentType(body.getContentType());
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Disposition", "form-data; name=\"body\";");
        headers.setHeader("Content-Type", "application/xml");
        body.addBodyPart((BodyPart)new MimeBodyPart(headers, xml.getBytes()));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        body.writeTo((OutputStream)bout);
        request.setContent(bout.toByteArray());
        MockHttpServletResponse response = new MockHttpServletResponse();
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getContentAsString());
    }

    public void testErrorThrowingResponse() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext-errorResponse.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            String outputContent = response.getContentAsString();
            Assert.assertThat((Object)outputContent, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Hello world!")));
            Document dom = XMLUnit.buildTestDocument((String)outputContent);
            DispatcherTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        }
    }
}

