/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.geotools.util.logging.Logging;

public class RESTAccessRuleDAO
extends AbstractAccessRuleDAO<String> {
    private static final Logger LOGGER = Logging.getLogger(RESTAccessRuleDAO.class);
    static final Pattern PATTERN = Pattern.compile("\\S+;(GET|POST|PUT|DELETE|HEAD)(,(GET|POST|PUT|DELETE|HEAD))*=\\S+(, ?\\S+)*");

    public static RESTAccessRuleDAO get() {
        return (RESTAccessRuleDAO)GeoServerExtensions.bean(RESTAccessRuleDAO.class);
    }

    protected RESTAccessRuleDAO(GeoServerDataDirectory dd) throws IOException {
        super(dd, "rest.properties");
    }

    @Override
    protected void loadRules(Properties props) {
        this.rules = new LinkedHashSet();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String rule = key + "=" + val;
            if (!PATTERN.matcher(rule).matches()) {
                LOGGER.severe("Ignoring '" + rule + "' not matching " + PATTERN);
                continue;
            }
            rule = rule.replaceAll(";", ":");
            this.rules.add(rule);
        }
    }

    @Override
    protected Properties toProperties() {
        Properties props = new Properties();
        for (String rule : this.rules) {
            if (!PATTERN.matcher(rule = rule.replaceAll(":", ";")).matches()) {
                LOGGER.severe("Invalid '" + rule + "' not matching " + PATTERN);
                continue;
            }
            String[] parts = rule.split("=");
            props.setProperty(parts[0], parts[1]);
        }
        return props;
    }
}

