/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.InMemorySecurityFilter;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WMTSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geoserver.security.impl.SecureTreeNode;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.springframework.security.core.Authentication;

public class DefaultResourceAccessManager
implements ResourceAccessManager,
DataAccessManager {
    static final Logger LOGGER = Logging.getLogger(DefaultResourceAccessManager.class);
    SecureTreeNode root;
    DataAccessRuleDAO dao;
    Catalog rawCatalog;
    long lastLoaded = Long.MIN_VALUE;
    LayerGroupContainmentCache groupsCache;

    @Deprecated
    public DefaultResourceAccessManager(DataAccessRuleDAO dao) {
        this(dao, (Catalog)GeoServerExtensions.bean((String)"rawCatalog"));
    }

    public DefaultResourceAccessManager(DataAccessRuleDAO dao, Catalog rawCatalog) {
        this.dao = dao;
        this.rawCatalog = rawCatalog;
        this.root = this.buildAuthorizationTree(dao);
        this.groupsCache = new LayerGroupContainmentCache(rawCatalog);
    }

    @Override
    public CatalogMode getMode() {
        return this.dao.getMode();
    }

    @Override
    public boolean canAccess(Authentication user, WorkspaceInfo workspace, AccessMode mode) {
        this.checkPropertyFile();
        SecureTreeNode node = this.root.getDeepestNode(workspace.getName());
        if (node.canAccess(user, mode)) {
            return true;
        }
        return mode == AccessMode.READ && this.canAccessChild(node, user, mode);
    }

    private boolean canAccessChild(SecureTreeNode node, Authentication user, AccessMode mode) {
        if (node.canAccess(user, mode)) {
            return true;
        }
        for (SecureTreeNode child : node.getChildren().values()) {
            if (!this.canAccessChild(child, user, mode)) continue;
            return true;
        }
        return false;
    }

    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode, boolean directAccess) {
        this.checkPropertyFile();
        if (layer.getResource() == null) {
            LOGGER.log(Level.FINE, "Layer " + layer + " has no attached resource, assuming it's possible to access it");
            return true;
        }
        return this.canAccess(user, layer.getResource(), mode, directAccess);
    }

    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode, boolean directAccess) {
        String workspace;
        this.checkPropertyFile();
        String resourceName = resource.getName();
        try {
            workspace = resource.getStore().getWorkspace().getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Errors occurred trying to gather workspace of resource " + resourceName);
            return true;
        }
        SecureTreeNode securityNode = this.root.getDeepestNode(workspace, resourceName);
        int catalogNodeDepth = securityNode.getDepth();
        boolean rulesAllowAccess = securityNode.canAccess(user, mode);
        if (catalogNodeDepth == SecureTreeNode.RESOURCE_DEPTH || !this.layerGroupContainmentCheckRequired()) {
            return rulesAllowAccess;
        }
        Collection<LayerGroupContainmentCache.LayerGroupSummary> containers = this.groupsCache.getContainerGroupsFor(resource);
        if (containers.isEmpty()) {
            return rulesAllowAccess;
        }
        List groupOverrides = containers.stream().filter(sg -> {
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            if (gi == null) {
                return false;
            }
            SecureTreeNode node = this.getNodeForGroup(gi);
            return node != null && node.getDepth() > catalogNodeDepth || sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER;
        }).collect(Collectors.toList());
        if (!groupOverrides.isEmpty()) {
            rulesAllowAccess = groupOverrides.stream().anyMatch(sg -> {
                if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                    return false;
                }
                LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
                return gi != null && this.canAccess(user, gi, directAccess) && (!directAccess || this.allowsAccessViaNonOpaqueGroup(gi, resource));
            });
        }
        if (rulesAllowAccess) {
            return true;
        }
        return containers.stream().anyMatch(sg -> {
            if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                return false;
            }
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            if (gi == null) {
                return false;
            }
            SecureTreeNode node = this.getNodeForGroup(gi);
            return node == null && this.canAccess(user, gi, directAccess) && (!directAccess || this.allowsAccessViaNonOpaqueGroup(gi, resource));
        });
    }

    private boolean allowsAccessViaNonOpaqueGroup(LayerGroupInfo gi, ResourceInfo resource) {
        for (PublishedInfo pi : gi.getLayers()) {
            LayerGroupInfo lg;
            if (!(pi instanceof LayerInfo ? resource.equals(((LayerInfo)pi).getResource()) : (lg = (LayerGroupInfo)pi).getMode() != LayerGroupInfo.Mode.OPAQUE_CONTAINER && this.allowsAccessViaNonOpaqueGroup(lg, resource))) continue;
            return true;
        }
        return false;
    }

    private SecureTreeNode getNodeForGroup(LayerGroupInfo lg) {
        SecureTreeNode node;
        if (lg.getWorkspace() == null) {
            node = this.root.getNode(lg.getName());
        } else {
            String[] path = this.getLayerGroupPath(lg);
            node = this.root.getNode(path);
        }
        return node;
    }

    private boolean layerGroupContainmentCheckRequired() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return false;
        }
        String service = request.getService();
        return "WMS".equalsIgnoreCase(service) || "gwc".equalsIgnoreCase(service);
    }

    void checkPropertyFile() {
        this.rebuildAuthorizationTree(false);
    }

    private void rebuildAuthorizationTree(boolean force) {
        long daoLastModified = this.dao.getLastModified();
        if (this.lastLoaded < daoLastModified || force) {
            this.root = this.buildAuthorizationTree(this.dao);
            this.lastLoaded = daoLastModified;
        }
    }

    SecureTreeNode buildAuthorizationTree(DataAccessRuleDAO dao) {
        SecureTreeNode root = new SecureTreeNode();
        for (DataAccessRule rule : dao.getRules()) {
            SecureTreeNode node;
            String workspace = rule.getRoot();
            String layer = rule.getLayer();
            AccessMode accessMode = rule.getAccessMode();
            if ("*".equals(workspace)) {
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(workspace);
                if (ws == null) {
                    ws = root.addChild(workspace);
                }
                if ("*".equals(layer)) {
                    node = ws;
                } else if (rule.isGlobalGroupRule()) {
                    node = ws;
                } else {
                    SecureTreeNode layerNode = ws.getChild(layer);
                    if (layerNode == null) {
                        layerNode = ws.addChild(layer);
                    }
                    node = layerNode;
                }
            }
            if (node.getAuthorizedRoles(accessMode) != null && node.getAuthorizedRoles(accessMode).size() > 0 && node != root) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(accessMode, rule.getRoles());
        }
        return root;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> context) {
        boolean directAccess = context == null || context.isEmpty();
        boolean read = this.canAccess(user, layer, AccessMode.READ, directAccess);
        boolean write = this.canAccess(user, layer, AccessMode.WRITE, directAccess);
        IncludeFilter readFilter = read ? Filter.INCLUDE : Filter.EXCLUDE;
        IncludeFilter writeFilter = write ? Filter.INCLUDE : Filter.EXCLUDE;
        return this.buildLimits(layer.getResource().getClass(), (Filter)readFilter, (Filter)writeFilter);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        boolean read = this.canAccess(user, resource, AccessMode.READ);
        boolean write = this.canAccess(user, resource, AccessMode.WRITE);
        IncludeFilter readFilter = read ? Filter.INCLUDE : Filter.EXCLUDE;
        IncludeFilter writeFilter = write ? Filter.INCLUDE : Filter.EXCLUDE;
        return this.buildLimits(resource.getClass(), (Filter)readFilter, (Filter)writeFilter);
    }

    DataAccessLimits buildLimits(Class<? extends ResourceInfo> resourceClass, Filter readFilter, Filter writeFilter) {
        CatalogMode mode = this.getMode();
        if ((readFilter == null || readFilter == Filter.INCLUDE) && (writeFilter == null || writeFilter == Filter.INCLUDE || WMSLayerInfo.class.isAssignableFrom(resourceClass) || WMTSLayerInfo.class.isAssignableFrom(resourceClass) || CoverageInfo.class.isAssignableFrom(resourceClass))) {
            return null;
        }
        if (FeatureTypeInfo.class.isAssignableFrom(resourceClass)) {
            return new VectorAccessLimits(mode, null, readFilter, null, writeFilter);
        }
        if (CoverageInfo.class.isAssignableFrom(resourceClass)) {
            return new CoverageAccessLimits(mode, readFilter, null, null);
        }
        if (WMSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMSAccessLimits(mode, readFilter, null, true);
        }
        if (WMTSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMTSAccessLimits(mode, readFilter, null);
        }
        LOGGER.log(Level.INFO, "Warning, adapting to generic access limits for unrecognized resource type " + resourceClass);
        return new DataAccessLimits(mode, readFilter);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        boolean readable = this.canAccess(user, workspace, AccessMode.READ);
        boolean writable = this.canAccess(user, workspace, AccessMode.WRITE);
        boolean adminable = this.canAccess(user, workspace, AccessMode.ADMIN);
        CatalogMode mode = this.getMode();
        if (readable && writable && AdminRequest.get() == null) {
            return null;
        }
        return new WorkspaceAccessLimits(mode, readable, writable, adminable);
    }

    @Override
    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        return null;
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        boolean allowAccess = this.canAccess(user, layerGroup, containers == null || containers.isEmpty());
        return allowAccess ? null : new LayerGroupAccessLimits(this.getMode());
    }

    private boolean canAccess(Authentication user, LayerGroupInfo layerGroup, boolean directAccess) {
        Collection<LayerGroupContainmentCache.LayerGroupSummary> directContainers;
        String[] path = this.getLayerGroupPath(layerGroup);
        SecureTreeNode node = this.root.getDeepestNode(path);
        boolean catalogNodeAllowsAccess = node.canAccess(user, AccessMode.READ);
        boolean allowAccess = node != null && !catalogNodeAllowsAccess ? false : ((directContainers = this.groupsCache.getContainerGroupsFor(layerGroup)).isEmpty() ? true : directContainers.stream().anyMatch(sg -> {
            if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                return false;
            }
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            return gi != null && this.canAccess(user, gi, directAccess);
        }));
        return allowAccess;
    }

    private String[] getLayerGroupPath(LayerGroupInfo layerGroup) {
        if (layerGroup.getWorkspace() == null) {
            return new String[]{layerGroup.getName()};
        }
        return new String[]{layerGroup.getWorkspace().getName(), layerGroup.getName()};
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        if (this.getMode() == CatalogMode.CHALLENGE) {
            return InMemorySecurityFilter.buildUserAccessFilter(this, user);
        }
        if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("name", wsName));
            }
            if (exceptions.size() == 0) {
                return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        if (PublishedInfo.class.isAssignableFrom(clazz) || ResourceInfo.class.isAssignableFrom(clazz) || CoverageInfo.class.isAssignableFrom(clazz)) {
            Filter filter;
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            String wsNameProperty = PublishedInfo.class.isAssignableFrom(clazz) ? "resource.store.workspace.name" : "store.workspace.name";
            for (Map.Entry<String, SecureTreeNode> wsEntry : this.root.getChildren().entrySet()) {
                String wsName = wsEntry.getKey();
                SecureTreeNode wsNode = wsEntry.getValue();
                boolean wsAccess = this.canAccess(user, wsNode);
                ArrayList<Filter> layerExceptions = new ArrayList<Filter>();
                for (Map.Entry<String, SecureTreeNode> layerEntry : wsNode.getChildren().entrySet()) {
                    String layerName = layerEntry.getKey();
                    SecureTreeNode layerNode = layerEntry.getValue();
                    boolean layerAccess = this.canAccess(user, layerNode);
                    if (layerAccess == wsAccess) continue;
                    if (wsAccess) {
                        layerExceptions.add(Predicates.notEqual("prefixedName", wsName + ":" + layerName));
                        continue;
                    }
                    layerExceptions.add(Predicates.equal("prefixedName", wsName + ":" + layerName));
                }
                Filter wsFilter = null;
                if (rootAccess && !wsAccess) {
                    wsFilter = Predicates.notEqual(wsNameProperty, wsName);
                } else if (!rootAccess && wsAccess) {
                    wsFilter = Predicates.equal(wsNameProperty, wsName);
                }
                if (layerExceptions.isEmpty()) {
                    if (wsFilter == null) continue;
                    exceptions.add(wsFilter);
                    continue;
                }
                if (wsFilter != null) {
                    layerExceptions.add(wsFilter);
                }
                Filter combined = wsAccess ? Predicates.and(layerExceptions) : Predicates.or(layerExceptions);
                exceptions.add(combined);
            }
            if (exceptions.size() == 0) {
                return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
            }
            Filter filter2 = filter = rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
            if (PublishedInfo.class.equals(clazz)) {
                Filter layerFilter = Predicates.and(Predicates.isInstanceOf(LayerInfo.class), filter);
                Filter layerGroupFilter = Predicates.isInstanceOf(LayerGroupInfo.class);
                return Predicates.or(layerFilter, layerGroupFilter);
            }
            return filter;
        }
        if (StyleInfo.class.isAssignableFrom(clazz) || LayerGroupInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("workspace.name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("workspace.name", wsName));
            }
            if (exceptions.size() == 0) {
                return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        return InMemorySecurityFilter.buildUserAccessFilter(this, user);
    }

    private boolean canAccess(Authentication user, SecureTreeNode node) {
        boolean access = node.canAccess(user, AccessMode.READ);
        if (access && AdminRequest.get() != null) {
            return node.canAccess(user, AccessMode.ADMIN);
        }
        return access;
    }

    @Override
    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode) {
        return this.canAccess(user, resource, mode, true);
    }

    @Override
    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode) {
        return this.canAccess(user, layer, mode, true);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        return this.getAccessLimits(user, layer, Collections.emptyList());
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        return this.getAccessLimits(user, layerGroup, Collections.emptyList());
    }

    static class SecuredGroupSummary
    extends LayerGroupContainmentCache.LayerGroupSummary {
        private SecureTreeNode node;

        SecuredGroupSummary(LayerGroupContainmentCache.LayerGroupSummary origin, SecureTreeNode node) {
            super(origin);
            this.node = node;
        }

        boolean canAccess(Authentication user, AccessMode mode) {
            return this.node == null || this.node.canAccess(user, mode);
        }

        public SecureTreeNode getNode() {
            return this.node;
        }
    }
}

