/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.config.CredentialsFromRequestHeaderFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;

public class GeoServerCredentialsFromRequestHeaderFilter
extends GeoServerSecurityFilter
implements AuthenticationCachingFilter,
GeoServerAuthenticationFilter {
    private String userNameHeaderName;
    private String passwordHeaderName;
    private Pattern userNameRegex;
    private Pattern passwordRegex;
    private boolean decodeURI = true;
    private MessageDigest digest;
    protected AuthenticationEntryPoint aep;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.aep = new Http403ForbiddenEntryPoint();
        CredentialsFromRequestHeaderFilterConfig authConfig = (CredentialsFromRequestHeaderFilterConfig)config;
        this.userNameHeaderName = authConfig.getUserNameHeaderName();
        this.passwordHeaderName = authConfig.getPasswordHeaderName();
        this.userNameRegex = Pattern.compile(authConfig.getUserNameRegex());
        this.passwordRegex = Pattern.compile(authConfig.getPasswordRegex());
        this.decodeURI = authConfig.isParseAsUriComponents();
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm available!");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String cacheKey = this.authenticateFromCache(this, (HttpServletRequest)request);
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            this.doAuthenticate((HttpServletRequest)request, (HttpServletResponse)response);
            Authentication postAuthentication = SecurityContextHolder.getContext().getAuthentication();
            if (postAuthentication != null && cacheKey != null && this.cacheAuthentication(postAuthentication, (HttpServletRequest)request)) {
                this.getSecurityManager().getAuthenticationCache().put(this.getName(), cacheKey, postAuthentication);
            }
        }
        request.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        chain.doFilter(request, response);
    }

    private String parseHeader(String header, Pattern pattern) {
        Matcher m = pattern.matcher(header);
        if (m.find() && m.groupCount() == 1) {
            String res = m.group(1);
            return res;
        }
        return null;
    }

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String usHeader = request.getHeader(this.userNameHeaderName);
        String pwHeader = request.getHeader(this.passwordHeaderName);
        if (usHeader == null || pwHeader == null) {
            return;
        }
        String us = this.parseHeader(usHeader, this.userNameRegex);
        String pw = this.parseHeader(pwHeader, this.passwordRegex);
        if (us == null || pw == null) {
            return;
        }
        if (this.decodeURI) {
            us = URLDecoder.decode(us, "UTF-8");
            pw = URLDecoder.decode(pw, "UTF-8");
        }
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)us, (Object)pw, new ArrayList());
        Authentication auth = null;
        try {
            auth = this.getSecurityManager().authenticationManager().authenticate((Authentication)result);
        }
        catch (ProviderNotFoundException e) {
            LOGGER.log(Level.WARNING, "couldn't to authenticate user:" + us);
            return;
        }
        LOGGER.log(Level.FINER, "logged in as {0}", us);
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        for (GrantedAuthority grauth : auth.getAuthorities()) {
            roles.add((GeoServerRole)grauth);
        }
        if (!roles.contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        }
        response.addHeader("X-GeoServer-Auth-User", us);
        UsernamePasswordAuthenticationToken newResult = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), roles);
        newResult.setDetails(auth.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newResult);
    }

    @Override
    public boolean applicableForHtml() {
        return true;
    }

    @Override
    public boolean applicableForServices() {
        return true;
    }

    @Override
    public String getCacheKey(HttpServletRequest req) {
        String usHeader = req.getHeader(this.userNameHeaderName);
        String pwHeader = req.getHeader(this.passwordHeaderName);
        if (usHeader == null || pwHeader == null) {
            return null;
        }
        String username = this.parseHeader(usHeader, this.userNameRegex);
        String password = this.parseHeader(pwHeader, this.passwordRegex);
        if (username == null && password == null) {
            return null;
        }
        if (this.decodeURI) {
            try {
                username = URLDecoder.decode(username, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.WARNING, "unsupported decode user name");
            }
        }
        StringBuffer buff = new StringBuffer(password);
        buff.append(":");
        buff.append(this.getName());
        String digestString = null;
        try {
            MessageDigest md = (MessageDigest)this.digest.clone();
            digestString = new String(Hex.encode((byte[])md.digest(buff.toString().getBytes("utf-8"))));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        buff = new StringBuffer(username);
        buff.append(":");
        buff.append(digestString);
        return buff.toString();
    }

    protected boolean cacheAuthentication(Authentication auth, HttpServletRequest request) {
        return request.getSession(false) == null;
    }
}

