/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjectFactory;

public class SecuredObjects {
    static final Map<Class<?>, SecuredObjectFactory> FACTORY_CACHE = new ConcurrentHashMap();

    public static Object secure(Object object, WrapperPolicy policy) {
        if (object == null) {
            return null;
        }
        Object unwrappedObject = ModificationProxy.unwrap(object);
        Class<?> clazz = unwrappedObject.getClass();
        SecuredObjectFactory candidate = FACTORY_CACHE.get(clazz);
        if (candidate == null) {
            List factories = GeoServerExtensions.extensions(SecuredObjectFactory.class);
            for (SecuredObjectFactory factory : factories) {
                if (!factory.canSecure(clazz)) continue;
                candidate = factory;
                break;
            }
            if (candidate == null) {
                throw new IllegalArgumentException("Could not find a security wrapper for class " + clazz + ", cannot secure the object");
            }
            FACTORY_CACHE.put(clazz, candidate);
        }
        return candidate.secure(object, policy);
    }
}

