/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.AbstractDecorator;
import org.geoserver.catalog.impl.FilteredList;
import org.geoserver.security.decorators.DecoratingLayerGroupInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;

public class SecuredLayerGroupInfo
extends DecoratingLayerGroupInfo {
    private LayerInfo rootLayer;
    private List<PublishedInfo> layers;
    private List<StyleInfo> styles;

    public SecuredLayerGroupInfo(LayerGroupInfo delegate, LayerInfo rootLayer, List<PublishedInfo> layers, List<StyleInfo> styles) {
        super(delegate);
        this.rootLayer = rootLayer;
        this.layers = layers;
        this.styles = styles;
    }

    @Override
    public LayerInfo getRootLayer() {
        return this.rootLayer;
    }

    @Override
    public void setRootLayer(LayerInfo rootLayer) {
        this.rootLayer = rootLayer;
        ((LayerGroupInfo)this.delegate).setRootLayer((LayerInfo)SecuredLayerGroupInfo.unwrap(rootLayer));
    }

    @Override
    public List<PublishedInfo> getLayers() {
        return new FilteredList<PublishedInfo>(this.layers, ((LayerGroupInfo)this.delegate).getLayers()){

            @Override
            protected PublishedInfo unwrap(PublishedInfo element) {
                return SecuredLayerGroupInfo.unwrap(element);
            }
        };
    }

    @Override
    public List<StyleInfo> getStyles() {
        return new FilteredList<StyleInfo>(this.styles, ((LayerGroupInfo)this.delegate).getStyles());
    }

    private static PublishedInfo unwrap(PublishedInfo pi) {
        if (pi instanceof SecuredLayerInfo || pi instanceof SecuredLayerGroupInfo) {
            AbstractDecorator decorator = (AbstractDecorator)((Object)pi);
            return (PublishedInfo)decorator.unwrap(PublishedInfo.class);
        }
        return pi;
    }
}

