/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredGetMapRequest;
import org.geoserver.security.decorators.SecuredWMSLayer;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.ows.ServiceException;

public class SecuredGetFeatureInfoRequest
implements GetFeatureInfoRequest {
    List<Layer> queryLayers = new ArrayList<Layer>();
    GetFeatureInfoRequest delegate;
    int x;
    int y;
    GetMapRequest getMap;

    public SecuredGetFeatureInfoRequest(GetFeatureInfoRequest delegate, GetMapRequest getMap) {
        this.delegate = delegate;
        this.getMap = getMap;
    }

    public void addQueryLayer(Layer layer) {
        this.queryLayers.add(layer);
    }

    public void setQueryLayers(Set layers) {
        this.queryLayers.clear();
        this.queryLayers.addAll(layers);
    }

    public void setQueryPoint(int x, int y) {
        this.x = x;
        this.y = y;
        this.delegate.setQueryPoint(x, y);
    }

    public URL getFinalURL() {
        SecuredGetMapRequest sgm;
        String encodedFilter;
        for (int i = 0; i < this.queryLayers.size(); ++i) {
            WMSAccessLimits limits;
            Layer layer = this.queryLayers.get(i);
            if (!(layer instanceof SecuredWMSLayer)) continue;
            SecuredWMSLayer secured = (SecuredWMSLayer)layer;
            WrapperPolicy policy = secured.getPolicy();
            if (policy.getLimits() instanceof WMSAccessLimits && !(limits = (WMSAccessLimits)policy.getLimits()).isAllowFeatureInfo()) {
                if (policy.getResponse() == Response.CHALLENGE) {
                    SecureCatalogImpl.unauthorizedAccess(layer.getName());
                } else {
                    throw new IllegalArgumentException("Layer " + layer.getName() + " is not queriable");
                }
            }
            this.delegate.addQueryLayer(layer);
        }
        if (this.getMap instanceof SecuredGetMapRequest && (encodedFilter = (sgm = (SecuredGetMapRequest)this.getMap).buildCQLFilter()) != null) {
            this.delegate.setProperty("CQL_FILTER", encodedFilter);
        }
        return this.delegate.getFinalURL();
    }

    public org.geotools.data.ows.Response createResponse(HTTPResponse response) throws ServiceException, IOException {
        return this.delegate.createResponse(response);
    }

    public String getPostContentType() {
        return this.delegate.getPostContentType();
    }

    public Properties getProperties() {
        return this.delegate.getProperties();
    }

    public void performPostOutput(OutputStream outputStream) throws IOException {
        this.delegate.performPostOutput(outputStream);
    }

    public boolean requiresPost() {
        return this.delegate.requiresPost();
    }

    public void setFeatureCount(int featureCount) {
        this.delegate.setFeatureCount(featureCount);
    }

    public void setFeatureCount(String featureCount) {
        this.delegate.setFeatureCount(featureCount);
    }

    public void setInfoFormat(String infoFormat) {
        this.delegate.setInfoFormat(infoFormat);
    }

    public void setProperty(String name, String value) {
        this.delegate.setProperty(name, value);
    }
}

