/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerSecurityManager;

public class WorkspaceAccessLimits
extends AccessLimits {
    private static final long serialVersionUID = -1852838160677767466L;
    boolean readable;
    boolean writable;
    boolean adminable;

    public WorkspaceAccessLimits(CatalogMode mode, boolean readable, boolean writable) {
        this(mode, readable, writable, WorkspaceAccessLimits.isAuthenticatedAsAdmin());
    }

    private static boolean isAuthenticatedAsAdmin() {
        return ((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class)).checkAuthenticationForAdminRole();
    }

    public WorkspaceAccessLimits(CatalogMode mode, boolean readable, boolean writable, boolean adminable) {
        super(mode);
        this.readable = readable;
        this.writable = writable;
        this.adminable = adminable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isAdminable() {
        return this.adminable;
    }

    public String toString() {
        return "WorkspaceAccessLimits [readable=" + this.readable + ", writable=" + this.writable + ", adminable = " + this.adminable + ", mode=" + (Object)((Object)this.mode) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.readable ? 1231 : 1237);
        result = 31 * result + (this.writable ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceAccessLimits other = (WorkspaceAccessLimits)obj;
        if (this.readable != other.readable) {
            return false;
        }
        return this.writable == other.writable;
    }
}

